/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.embed;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.zkoss.json.JSONArray;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public class Bridge {
    private Execution _exec;
    private Object _updctx;
    private Object _locale;

    public static Bridge start(ServletContext svlctx, HttpServletRequest request, HttpServletResponse response, Desktop desktop) {
        try {
            return new Bridge(svlctx, request, response, desktop, Charsets.setup((ServletRequest)request, (ServletResponse)response, (String)"utf-8"));
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
    }

    public static Desktop getDesktop(ServletContext svlctx, HttpServletRequest request, String dtid) {
        return ((WebAppCtrl)WebManager.getWebApp((ServletContext)svlctx)).getDesktopCache(WebManager.getSession((ServletContext)svlctx, (HttpServletRequest)request)).getDesktop(dtid);
    }

    protected Bridge(ServletContext svlctx, HttpServletRequest request, HttpServletResponse response, Desktop desktop, Object locale) throws Exception {
        this._exec = new ExecutionImpl(svlctx, request, response, desktop, null);
        this._updctx = ((WebAppCtrl)desktop.getWebApp()).getUiEngine().startUpdate(this._exec);
        this._locale = locale;
    }

    public Execution getExecution() {
        return this._exec;
    }

    public String getResult() {
        Desktop desktop = this._exec.getDesktop();
        try {
            JSONArray result = ((WebAppCtrl)desktop.getWebApp()).getUiEngine().finishUpdate(this._updctx);
            return new StringBuffer(512).append("zAu.doCmds('").append(desktop.getId()).append("',").append(result.toString()).append(");").toString();
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
    }

    public void close() {
        HttpServletRequest request = (HttpServletRequest)this._exec.getNativeRequest();
        try {
            ((WebAppCtrl)this._exec.getDesktop().getWebApp()).getUiEngine().closeUpdate(this._updctx);
            this._updctx = null;
            this._exec = null;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
        finally {
            Charsets.cleanup((ServletRequest)request, (Object)this._locale);
            this._locale = null;
        }
    }
}

