/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Strings;
import org.zkoss.util.Converter;
import org.zkoss.util.Maps;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.Html;
import org.zkoss.zul.ItemRenderer;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.Utils;

public class Searchbox<E>
extends HtmlBasedComponent
implements Disable {
    private static final long serialVersionUID = 20190715143656L;
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.onInitLaterPosted";
    private Boolean SELECTIVE_COMPONENT_UPDATE = null;
    private transient ListModel<E> _model;
    private transient ListModel<E> _subModel;
    private transient ListDataListener _dataListener;
    private transient EventListener<InputEvent> _onSearchingListener;
    private transient ItemRenderer<E> _renderer;
    private transient Converter<Collection<E>, String> _converter;
    private transient boolean _ignoreDataSelectionEvent;
    private String _searchMessage;
    private String _placeholder;
    private boolean _multiple;
    private boolean _open;
    private boolean _disabled;
    private boolean _autoclose;
    private boolean _childable;
    private transient List<E> _items;
    private transient Map<E, String> _itemHtmlRelations;
    private transient Map<E, String> _itemUuidRelations;
    private transient Map<String, E> _uuidItemRelations;
    private String _searchText;
    private static final ItemRenderer<?> DEFAULT_ITEM_RENDERER;
    private static final Converter<Collection<?>, String> DEFAULT_CONVERTER;

    public ListModel<E> getModel() {
        return this._model;
    }

    private Selectable<E> getSelectableModel() {
        return (Selectable)this._model;
    }

    public void setModel(ListModel<E> model) {
        if (model != null && !(model instanceof Selectable)) {
            throw new UiException(String.valueOf(model.getClass()) + " must implement Selectable class");
        }
        if (this._model != model) {
            if (this._model != null) {
                this._model.removeListDataListener(this._dataListener);
                if (this.isRenderByServer()) {
                    this.removeEventListener("onSearching", this._onSearchingListener);
                    this._subModel = null;
                }
            }
            this._model = model;
            if (this._model != null) {
                this.initDataListener();
            }
            this.smartUpdate("renderByServer", this.isRenderByServer());
            this.postOnInitRender();
        }
    }

    private boolean isRenderByServer() {
        return this._model instanceof ListSubModel;
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = this::onListDataChange;
        }
        if (this._onSearchingListener == null) {
            this._onSearchingListener = this::onSearching;
        }
        this._model.addListDataListener(this._dataListener);
        if (this.isRenderByServer()) {
            this.addEventListener("onSearching", this._onSearchingListener);
        }
    }

    private void onListDataChange(ListDataEvent event) {
        if (this.SELECTIVE_COMPONENT_UPDATE == null) {
            this.SELECTIVE_COMPONENT_UPDATE = Utils.testAttribute((Component)this, (String)"org.zkoss.zul.model.selectiveComponentUpdate.enable", (boolean)false, (boolean)true);
        }
        int eventType = event.getType();
        switch (eventType) {
            case 0: 
            case 1: 
            case 2: {
                int startIndex = event.getIndex0();
                int endIndex = event.getIndex1();
                boolean isIntervalRemoved = eventType == 2;
                boolean isPartialUpdate = startIndex >= 0 && endIndex >= 0;
                this.prepareItems(this._model);
                if (this.isRenderByServer()) break;
                List<Map<String, Object>> contents = isPartialUpdate ? (isIntervalRemoved ? null : this.encloseItems(this.getItems().subList(startIndex, endIndex + 1))) : this.encloseItems(this.getItems());
                this.response((AuResponse)new AuInvoke((Component)this, "_updateItems", new Object[]{contents, isPartialUpdate, eventType, startIndex, endIndex}));
                if (this.SELECTIVE_COMPONENT_UPDATE.booleanValue() || !isPartialUpdate || eventType == 0) break;
                endIndex = this._model.getSize() - 1;
                this.response((AuResponse)new AuInvoke((Component)this, "_updateItems", new Object[]{this.encloseItems(this.getItems().subList(startIndex, endIndex + 1)), isPartialUpdate, 0, startIndex, endIndex}));
                break;
            }
            case 4: {
                if (this._ignoreDataSelectionEvent) break;
                this.doSelectionChanged();
                break;
            }
            case 6: {
                this.setMultiple(this.getSelectableModel().isMultiple());
                break;
            }
            default: {
                this.postOnInitRender();
            }
        }
    }

    private void onSearching(InputEvent event) {
        if (this.isRenderByServer()) {
            String value = event.getValue();
            if (Strings.isEmpty((String)value)) {
                this.smartUpdate("items", new String[0]);
            } else {
                this._subModel = ((ListSubModel)this._model).getSubModel((Object)value, -1);
                this.prepareItems(this._subModel);
                this.smartUpdate("items", this.encloseItems(this.getItems()));
            }
        }
    }

    private void doSelectionChanged() {
        this.updateLabel();
        this.updatePlaceholderVisible();
        this.smartUpdate("selectedUuids", this.getItemUuids(this.getReadonlySelectedItems()));
    }

    private void prepareData() {
        if (!this.isRenderByServer()) {
            this.prepareItems(this._model);
        }
        if (this._model != null) {
            Selectable<E> smodel = this.getSelectableModel();
            this.setMultiple(smodel.isMultiple());
        }
    }

    private void prepareItems(ListModel<E> model) {
        if (model != null) {
            int sz = model.getSize();
            ArrayList<Object> items = new ArrayList<Object>(sz);
            boolean oldChildable = this._childable;
            try {
                this._childable = true;
                Map<E, String> itemHtmlRelations = this.getItemHtmlRelations();
                ItemRenderer<E> renderer = this.getRealRenderer();
                for (int i = 0; i < sz; ++i) {
                    Object item = model.getElementAt(i);
                    itemHtmlRelations.put(item, renderer.render((Component)this, item, i));
                    items.add(item);
                }
                this._items = items;
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            finally {
                this._childable = oldChildable;
                this.getChildren().clear();
            }
        }
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        this.resetItemRelations();
        this.prepareData();
        this.updateLabel();
        this.updatePlaceholderVisible();
        if (!this.isRenderByServer()) {
            this.smartUpdate("items", this.encloseItems(this.getItems()));
            this.smartUpdate("selectedUuids", this.getItemUuids(this.getReadonlySelectedItems()));
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    private ItemRenderer<E> getRealRenderer() {
        return this._renderer != null ? this._renderer : DEFAULT_ITEM_RENDERER;
    }

    public ItemRenderer<E> getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ItemRenderer<E> renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            this.invalidate();
        }
    }

    public void setItemRenderer(String clsnm) throws ReflectiveOperationException {
        if (clsnm != null) {
            this.setItemRenderer((ItemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public Converter<Collection<E>, String> getItemConverter() {
        return this._converter;
    }

    public void setItemConverter(Converter<Collection<E>, String> converter) {
        if (this._converter != converter) {
            this._converter = converter;
            this.updateLabel();
        }
    }

    public void setItemConverter(String clsnm) throws ReflectiveOperationException {
        if (clsnm != null) {
            this.setItemConverter((Converter)Classes.newInstanceByThread((String)clsnm));
        }
    }

    private void updateLabel() {
        this.smartUpdate("label", this.getLabel());
    }

    private void updatePlaceholderVisible() {
        this.smartUpdate("placeholderVisible", this.getReadonlySelectedItems().isEmpty());
    }

    private String getLabel() {
        Set<E> selectedItems = this.getReadonlySelectedItems();
        if (this._converter != null) {
            return (String)this._converter.convert(selectedItems);
        }
        return (String)DEFAULT_CONVERTER.convert(selectedItems);
    }

    public String getSearchMessage() {
        return this._searchMessage;
    }

    public void setSearchMessage(String searchMessage) {
        if (!org.zkoss.lang.Objects.equals((Object)this._searchMessage, (Object)searchMessage)) {
            this._searchMessage = searchMessage;
            this.smartUpdate("searchMessage", this._searchMessage);
        }
    }

    public String getPlaceholder() {
        return this._placeholder;
    }

    public void setPlaceholder(String placeholder) {
        if (!org.zkoss.lang.Objects.equals((Object)this._placeholder, (Object)placeholder)) {
            this._placeholder = placeholder;
            this.smartUpdate("placeholder", this._placeholder);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (this._model != null) {
                this.getSelectableModel().setMultiple(multiple);
            }
            this.smartUpdate("multiple", this._multiple);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", this._open);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isAutoclose() {
        return this._autoclose;
    }

    public void setAutoclose(boolean autoclose) {
        if (this._autoclose != autoclose) {
            this._autoclose = autoclose;
            this.smartUpdate("autoclose", this._autoclose);
        }
    }

    public Set<E> getSelectedItems() {
        if (this._model == null) {
            return Collections.emptySet();
        }
        return new LinkedHashSet(this.getSelectableModel().getSelection());
    }

    private Set<E> getReadonlySelectedItems() {
        if (this._model == null) {
            return Collections.emptySet();
        }
        return this.getSelectableModel().getSelection();
    }

    public void setSelectedItems(Collection<E> selectedItems) {
        Objects.requireNonNull(selectedItems);
        Selectable<E> smodel = this.getSelectableModel();
        if (smodel != null) {
            smodel.setSelection(selectedItems);
        }
    }

    public E getSelectedItem() {
        Set<E> selectedItems = this.getReadonlySelectedItems();
        return selectedItems.isEmpty() ? null : (E)selectedItems.iterator().next();
    }

    public void setSelectedItem(E item) {
        if (item != this.getSelectedItem()) {
            this.clearSelection();
            if (item != null) {
                this.setSelectedItems(Collections.singleton(item));
            }
        }
    }

    public int getSelectedCount() {
        return this.getReadonlySelectedItems().size();
    }

    public void clearSelection() {
        Selectable<E> smodel = this.getSelectableModel();
        if (smodel != null) {
            smodel.clearSelection();
        }
    }

    public String getSearchText() {
        return this._searchText;
    }

    public void setSearchText(String searchText) {
        if (!org.zkoss.lang.Objects.equals((Object)this._searchText, (Object)searchText)) {
            this._searchText = searchText;
            this.smartUpdate("searchText", this._searchText);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        this.render(renderer, "searchMessage", this._searchMessage);
        this.render(renderer, "placeholder", this._placeholder);
        this.render(renderer, "multiple", this._multiple);
        this.render(renderer, "open", this._open);
        this.render(renderer, "disabled", this._disabled);
        this.render(renderer, "autoclose", this._autoclose);
        this.render(renderer, "items", this.encloseItems(this.getItems()));
        this.render(renderer, "label", this.getLabel());
        Set<E> selection = this.getReadonlySelectedItems();
        this.render(renderer, "selectedUuids", this.getItemUuids(selection));
        this.render(renderer, "placeholderVisible", selection.isEmpty());
        this.render(renderer, "renderByServer", this.isRenderByServer());
        this.render(renderer, "searchText", this._searchText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        switch (cmd) {
            case "onOpen": {
                OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
                this._open = evt.isOpen();
                Events.postEvent((Event)evt);
                break;
            }
            case "onSearching": {
                InputEvent inputEvent = InputEvent.getInputEvent((AuRequest)request, data.get("oldValue"));
                this._searchText = inputEvent.getValue();
                Events.postEvent((Event)inputEvent);
                break;
            }
            case "onSelect": {
                Map selectedUuids = (Map)data.get("selectedUuids");
                boolean singleSelection = AuRequests.getBoolean((Map)data, (String)"singleSelection");
                Selectable<E> smodel = this.getSelectableModel();
                Set prevSelection = smodel.getSelection();
                boolean oldIDSE = this._ignoreDataSelectionEvent;
                this._ignoreDataSelectionEvent = true;
                try {
                    if (singleSelection) {
                        smodel.clearSelection();
                    }
                    for (Map.Entry entry : selectedUuids.entrySet()) {
                        E selectItem = this.getItemByUuid((String)entry.getKey());
                        if (selectItem == null) continue;
                        if (((Boolean)entry.getValue()).booleanValue()) {
                            smodel.addToSelection(selectItem);
                            continue;
                        }
                        smodel.removeFromSelection(selectItem);
                    }
                }
                finally {
                    this._ignoreDataSelectionEvent = oldIDSE;
                }
                Set selection = smodel.getSelection();
                Events.postEvent((Event)new SelectEvent("onSelect", (Component)this, null, null, null, selection, prevSelection, this.collectUnselectedObjects(prevSelection, selection), null, null, 0));
                this.updateLabel();
                this.updatePlaceholderVisible();
                break;
            }
            default: {
                super.service(request, everError);
            }
        }
    }

    private Set<E> collectUnselectedObjects(Set<E> previousSelection, Set<E> currentSelection) {
        LinkedHashSet<E> prevSelectedItems = new LinkedHashSet<E>(previousSelection);
        if (currentSelection != null && prevSelectedItems.size() > 0) {
            prevSelectedItems.removeAll(currentSelection);
        }
        return prevSelectedItems;
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-searchbox";
    }

    protected boolean isChildable() {
        return this._childable;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (this._model != null) {
            this.postOnInitRender();
            if (this._dataListener != null) {
                this._model.removeListDataListener(this._dataListener);
                this._model.addListDataListener(this._dataListener);
            }
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this._model != null && this._dataListener != null) {
            this._model.removeListDataListener(this._dataListener);
        }
    }

    public void invalidate() {
        if (this._model != null && this._model.getSize() > 0 && (this._items == null && !this.isRenderByServer() || !this.getSelectableModel().isSelectionEmpty())) {
            this.postOnInitRender();
        } else {
            super.invalidate();
        }
    }

    public Object clone() {
        Searchbox clone = (Searchbox)((Object)super.clone());
        if (clone._model != null) {
            ListModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (ListModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone.postOnInitRender();
            clone._dataListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private List<Map<String, Object>> encloseItems(List<E> items) {
        if (items == null) {
            return Collections.emptyList();
        }
        return items.stream().map(opt -> Maps.of((Object[])new Object[]{"id", this.getUuidByItem(opt), "content", this.getHtmlByItem(opt)})).collect(Collectors.toList());
    }

    private String getUuidByItem(E item) {
        Map<E, String> itemUuidRelations = this.getItemUuidRelations();
        String uuid = itemUuidRelations.get(item);
        DesktopCtrl dc = (DesktopCtrl)this.getDesktop();
        if (uuid == null && dc != null) {
            uuid = dc.getNextUuid((Component)this);
            this.getUuidItemRelations().put(uuid, item);
            itemUuidRelations.put(item, uuid);
        }
        return uuid;
    }

    private List<E> getItems() {
        if (this._items == null) {
            this._items = new ArrayList();
        }
        return this._items;
    }

    private Map<E, String> getItemHtmlRelations() {
        if (this._itemHtmlRelations == null) {
            this._itemHtmlRelations = new HashMap<E, String>();
        }
        return this._itemHtmlRelations;
    }

    private Map<E, String> getItemUuidRelations() {
        if (this._itemUuidRelations == null) {
            this._itemUuidRelations = new HashMap<E, String>();
        }
        return this._itemUuidRelations;
    }

    private Map<String, E> getUuidItemRelations() {
        if (this._uuidItemRelations == null) {
            this._uuidItemRelations = new HashMap<String, E>();
        }
        return this._uuidItemRelations;
    }

    private E getItemByUuid(String uuid) {
        return this.getUuidItemRelations().get(uuid);
    }

    private String getHtmlByItem(E item) {
        return this.getItemHtmlRelations().get(item);
    }

    private List<String> getItemUuids(Collection<E> items) {
        if (!items.isEmpty()) {
            Map<E, String> itemUuidRelations = this.getItemUuidRelations();
            return items.stream().map(itemUuidRelations::get).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void resetItemRelations() {
        this._items = null;
        this._itemHtmlRelations = null;
        this._itemUuidRelations = null;
        this._uuidItemRelations = null;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, this._model);
        this.willSerialize(this._renderer);
        Serializables.smartWrite((ObjectOutputStream)s, this._renderer);
        this.willSerialize(this._converter);
        Serializables.smartWrite((ObjectOutputStream)s, this._converter);
        s.writeObject(this._itemUuidRelations);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (ListModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (ItemRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this._converter = (Converter)s.readObject();
        this.didDeserialize(this._converter);
        if (this._model != null) {
            this.initDataListener();
        }
        this.onInitRender();
        this._itemUuidRelations = (Map)s.readObject();
        if (this._itemUuidRelations != null) {
            this.rebuildUuidItemRelations();
        }
    }

    private void rebuildUuidItemRelations() {
        Map<String, E> uuidItemRelations = this.getUuidItemRelations();
        for (Map.Entry<E, String> item : this._itemUuidRelations.entrySet()) {
            uuidItemRelations.put(item.getValue(), item.getKey());
        }
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
        this.willPassivate(this._converter);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
        this.didActivate(this._converter);
        if (this._model != null) {
            this.postOnInitRender();
        }
    }

    static {
        Searchbox.addClientEvent(Searchbox.class, (String)"onOpen", (int)8193);
        Searchbox.addClientEvent(Searchbox.class, (String)"onSearching", (int)8192);
        Searchbox.addClientEvent(Searchbox.class, (String)"onSelect", (int)3);
        Searchbox.addClientEvent(Searchbox.class, (String)"onFocus", (int)8192);
        Searchbox.addClientEvent(Searchbox.class, (String)"onBlur", (int)8192);
        DEFAULT_ITEM_RENDERER = (owner, data, index) -> {
            Template tm = owner.getTemplate("model");
            if (tm == null) {
                return org.zkoss.lang.Objects.toString((Object)data);
            }
            Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])tm.create(owner, null, name -> {
                if ("each".equals(name)) {
                    return data;
                }
                if ("forEachStatus".equals(name)) {
                    return new ForEachStatus(){

                        public ForEachStatus getPrevious() {
                            return null;
                        }

                        public Object getEach() {
                            return this.getCurrent();
                        }

                        public int getIndex() {
                            return index;
                        }

                        public Integer getBegin() {
                            return 0;
                        }

                        public Integer getEnd() {
                            return ((Searchbox)owner).getModel().getSize();
                        }

                        public Object getCurrent() {
                            return data;
                        }

                        public boolean isFirst() {
                            return this.getCount() == 1;
                        }

                        public boolean isLast() {
                            return this.getIndex() + 1 == this.getEnd();
                        }

                        public Integer getStep() {
                            return null;
                        }

                        public int getCount() {
                            return this.getIndex() + 1;
                        }
                    };
                }
                return null;
            }, null));
            if (items.length != 1) {
                throw new UiException("The model template must have exactly one item, not " + items.length);
            }
            items[0].detach();
            if (items[0] instanceof Label) {
                return ((Label)items[0]).getValue();
            }
            if (items[0] instanceof Html) {
                return ((Html)items[0]).getContent();
            }
            throw new UiException("The model template can only support Label or Html component, not " + String.valueOf(items[0]));
        };
        DEFAULT_CONVERTER = obj -> obj.stream().map(Object::toString).collect(Collectors.joining(", "));
    }
}

