/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.zul.Rangeslider;
import org.zkoss.zkex.zul.Sliderbuttons;

public class Multislider
extends Rangeslider {
    private int _min = 0;
    private int _max = 100;

    protected void initSliderButtons() {
    }

    public int getMin() {
        return this._min;
    }

    public void setMin(int min) {
        if (min < 0) {
            throw new WrongValueException("Negative min is not allowed: " + min);
        }
        if (min > this._max) {
            throw new WrongValueException("Min (" + min + ") should not be greater than max (" + this._max + ").");
        }
        if (this._min != min) {
            this._min = min;
            this.smartUpdate("min", this._min);
            List children = this.getChildren();
            for (Sliderbuttons btns : children) {
                boolean changed = false;
                if (btns.getStartValue() < min) {
                    btns.setStartValueDirectly(min);
                    changed = true;
                }
                if (btns.getEndValue() < min) {
                    btns.setEndValueDirectly(min);
                    changed = true;
                }
                if (!changed) continue;
                btns.updateValues();
            }
        }
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int max) {
        if (max < 0) {
            throw new WrongValueException("Negative max is not allowed: " + max);
        }
        if (max < this._min) {
            throw new WrongValueException("Max (" + max + ") should not be less than min (" + this._min + ").");
        }
        if (this._max != max) {
            this._max = max;
            this.smartUpdate("max", this._max);
            List children = this.getChildren();
            for (Sliderbuttons btns : children) {
                boolean changed = false;
                if (btns.getStartValue() > max) {
                    btns.setStartValueDirectly(max);
                    changed = true;
                }
                if (btns.getEndValue() > max) {
                    btns.setEndValueDirectly(max);
                    changed = true;
                }
                if (!changed) continue;
                btns.updateValues();
            }
        }
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Sliderbuttons)) {
            throw new UiException("Unsupported child for Multislider " + String.valueOf(child));
        }
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (this.isInitialized()) {
            this.handleOtherButtonsValues((Sliderbuttons)child);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        if (this._min != 0) {
            renderer.render("min", this._min);
        }
        if (this._max != 100) {
            renderer.render("max", this._max);
        }
    }

    public void service(AuRequest request, boolean everError) {
        if ("onRangeValueChange".equals(request.getCommand())) {
            return;
        }
        super.service(request, everError);
    }

    protected void handleOtherButtonsValues(Sliderbuttons child) {
        List children = this.getChildren();
        int newStartValue = child.getStartValue();
        int newEndValue = child.getEndValue();
        boolean beforeBtns = true;
        for (Sliderbuttons btns : children) {
            if (Objects.equals((Object)btns, (Object)child)) {
                beforeBtns = false;
                continue;
            }
            int startValue = btns.getStartValue();
            int endValue = btns.getEndValue();
            boolean changed = false;
            if (beforeBtns && startValue > newStartValue || !beforeBtns && startValue < newStartValue) {
                btns.setStartValueDirectly(newStartValue);
                if (newStartValue > endValue) {
                    btns.setEndValueDirectly(newStartValue);
                }
                changed = true;
            }
            if (beforeBtns && endValue < newEndValue || !beforeBtns && endValue > newEndValue) {
                btns.setEndValueDirectly(newEndValue);
                if (newEndValue < startValue) {
                    btns.setStartValueDirectly(newEndValue);
                }
                changed = true;
            }
            if (!changed) continue;
            btns.updateValues();
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-multislider";
    }
}

