/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.WeakIdentityMap;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.sys.tracker.TrackerNode;
import org.zkoss.bind.tracker.impl.TrackerImpl;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.IdentityHashSet;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zkmax.bind.impl.LinkedHashBiMap;
import org.zkoss.zkmax.bind.impl.TrackerNodeImplEx;

public class TrackerImplEx
extends TrackerImpl {
    private static final long serialVersionUID = 20141226171420L;
    private transient Map<Pair<Object, Object>, TrackerNode> _sharableTrackerNodes;
    private transient Object _targetValue = null;
    protected Map<Component, Set<TrackerNode>> _compTailMap = LinkedHashBiMap.create();

    protected TrackerImpl.EqualBeansMap newEqualBeansMap() {
        return new EqualBeansMapEx();
    }

    public void setTargetValue(Object obj) {
        this._targetValue = obj;
        this.init();
    }

    protected Map<Component, Map<Object, TrackerNode>> initCompMap() {
        return LinkedHashBiMap.create();
    }

    private void init() {
        if (this._sharableTrackerNodes == null) {
            this._sharableTrackerNodes = LinkedHashBiMap.create();
        }
    }

    public void addTracking(Component comp, String[] series, Binding binding) {
        if (!(binding instanceof LoadBinding)) {
            return;
        }
        TrackerNode node = this.getOrCreateTrackerNode(comp, series);
        node.addBinding(binding);
        Set set = this._compTailMap.get(comp);
        if (set == null) {
            set = AllocUtil.inst.addSet(set, (Object)node);
            this._compTailMap.put(comp, set);
        } else {
            set = AllocUtil.inst.addSet(set, (Object)node);
        }
    }

    protected TrackerNode newTrackerNode(Object script) {
        return this.newTrackerNode(script, false);
    }

    private TrackerNode newTrackerNode(Object script, boolean inTemplate) {
        return new TrackerNodeImplEx(AllocUtil.inst.processScript(script), inTemplate);
    }

    protected Object getTargetValueAndReset() {
        Object old = this._targetValue;
        this._targetValue = Objects.UNKNOWN;
        return old == null ? this._targetValue : old;
    }

    protected void addBeanMap(TrackerNode node, Object value, Object basePath) {
        if (!TrackerImplEx.testEqualsBean((Object)node.getBean(), (Object)value)) {
            StringBuilder bashPathStr = new StringBuilder(!Strings.isEmpty((String)((String)basePath)) ? (String)basePath : "");
            String fieldString = (String)node.getFieldScript();
            if (!(bashPathStr.length() == 0 || fieldString.startsWith("[") && fieldString.endsWith("]"))) {
                bashPathStr.append(".");
            }
            String keyScript = bashPathStr.append(fieldString).toString();
            Pair key = new Pair(node.getBean() == null ? Objects.UNKNOWN : node.getBean(), (Object)keyScript);
            TrackerNode trackerNode = this._sharableTrackerNodes.remove(key);
            if (trackerNode != null) {
                this._sharableTrackerNodes.put((Pair<Object, Object>)new Pair(value, (Object)keyScript), trackerNode);
            }
        }
        super.addBeanMap(node, value, basePath);
    }

    protected void removeAllFromBeanMap(Collection<TrackerNode> removed) {
        for (TrackerNode tn : removed) {
            Set tns;
            Object bean = tn.getBean();
            if (bean == null || (tns = (Set)this._beanMap.get(bean)) == null) continue;
            tns.removeAll(removed);
            if (!tns.isEmpty()) continue;
            this._beanMap.remove(bean);
            this._equalBeansMap.remove(bean);
        }
    }

    protected TrackerNode getOrCreateTrackerNode(Component comp, String[] series) {
        Map nodes = (Map)this._compMap.get(comp);
        HashMap<TrackerNode, Boolean> parents = new HashMap<TrackerNode, Boolean>(series.length);
        StringBuilder currentSeries = new StringBuilder(32);
        boolean isInTemplate = comp.hasAttribute("$isTemplateModelEnabled$");
        TrackerNode parentNode = null;
        for (String script : series) {
            TrackerNode node = null;
            if (parentNode == null) {
                currentSeries.append(script);
                TrackerNode trackerNode = node = nodes == null ? null : (TrackerNode)nodes.get(script);
                if (node == null) {
                    Map nodes0;
                    Pair key = new Pair(Objects.UNKNOWN, (Object)script);
                    node = this.getNodeFromSharable(key, isInTemplate);
                    if (node == null) {
                        key = new Pair(this.getTargetValueAndReset(), (Object)script);
                        node = this.getNodeFromSharable(key, isInTemplate);
                    } else {
                        Object newKey = this.getTargetValueAndReset();
                        if (newKey != Objects.UNKNOWN) {
                            this._sharableTrackerNodes.remove(key);
                            key = new Pair(newKey, (Object)script);
                            if (node != null) {
                                AllocUtil.inst.putMap(this._sharableTrackerNodes, (Object)key, (Object)node);
                            }
                        }
                    }
                    if (node == null) {
                        node = this.newTrackerNode(script, isInTemplate);
                        AllocUtil.inst.putMap(this._sharableTrackerNodes, (Object)key, (Object)node);
                    }
                    if (nodes != (nodes0 = AllocUtil.inst.putMap(nodes, (Object)script, (Object)node))) {
                        this._compMap.put(comp, nodes0);
                    }
                }
            } else {
                boolean isMethodScript;
                String keyScript = null;
                boolean bl = isMethodScript = script.contains("(") && script.contains(")");
                if (script.startsWith("[") && script.endsWith("]") || isMethodScript) {
                    int currentSeriesStringLength = currentSeries.length();
                    if (currentSeriesStringLength > 0) {
                        currentSeries.deleteCharAt(currentSeriesStringLength - 1);
                    }
                    if (isMethodScript) {
                        keyScript = script;
                    }
                    node = null;
                } else {
                    node = parentNode.getDependent((Object)script);
                }
                if (keyScript == null) {
                    keyScript = currentSeries.append(script).toString();
                }
                if (node == null) {
                    Pair key = new Pair(Objects.UNKNOWN, (Object)keyScript);
                    node = this.getNodeFromSharable(key, isInTemplate);
                    if (node == null) {
                        key = new Pair(this.getTargetValueAndReset(), (Object)keyScript);
                        node = this.getNodeFromSharable(key, isInTemplate);
                    } else {
                        Object newKey = this.getTargetValueAndReset();
                        if (newKey != Objects.UNKNOWN) {
                            this._sharableTrackerNodes.remove(key);
                            key = new Pair(newKey, (Object)keyScript);
                            if (node != null) {
                                AllocUtil.inst.putMap(this._sharableTrackerNodes, (Object)key, (Object)node);
                            }
                        }
                    }
                    if (node == null || node.getBean() == null) {
                        node = this.newTrackerNode(script, isInTemplate);
                        AllocUtil.inst.putMap(this._sharableTrackerNodes, (Object)key, (Object)node);
                    } else if (parents.containsKey(node)) {
                        if (key.getX() == Objects.UNKNOWN) {
                            key = new Pair(Objects.UNKNOWN, (Object)keyScript);
                        }
                        node = this.newTrackerNode(script, isInTemplate);
                        AllocUtil.inst.putMap(this._sharableTrackerNodes, (Object)key, (Object)node);
                    }
                }
                parentNode.addDependent((Object)script, node);
                if (node instanceof TrackerNodeImplEx) {
                    ((TrackerNodeImplEx)node).setParentNode(parentNode);
                }
            }
            parentNode = node;
            parents.put(parentNode, Boolean.TRUE);
            currentSeries.append('.');
        }
        return parentNode;
    }

    private TrackerNode getNodeFromSharable(Pair key, boolean isInTemplate) {
        TrackerNode trackerNode = this._sharableTrackerNodes.get(key);
        if (trackerNode != null && ((TrackerNodeImplEx)trackerNode).isInTemplate() && !isInTemplate) {
            trackerNode = null;
        }
        return trackerNode;
    }

    private void removeAllReference(Set<TrackerNode> removed) {
        if (!removed.isEmpty()) {
            for (TrackerNode node : removed) {
                this._sharableTrackerNodes.values().remove(node);
            }
            this.removeAllFromBeanMap(removed);
            this.removeAllFromNullMap(removed);
        }
    }

    public void removeTrackings(Set<Component> comps) {
        for (Component comp : comps) {
            this.removeTrackings(comp);
        }
    }

    public void removeTrackings(Component comp) {
        Map nodesMap = (Map)this._compMap.remove(comp);
        HashMap<TrackerNodeImplEx, Pair> removeDependentsNodes = new HashMap<TrackerNodeImplEx, Pair>();
        if (nodesMap != null) {
            TrackerNodeImplEx tnParent;
            HashSet<TrackerNode> removed = new HashSet<TrackerNode>();
            Collection nodes = nodesMap.values();
            for (TrackerNode node : nodes) {
                LoadBinding next;
                if (!this.hasAnotherOwner(node)) {
                    removed.add(node);
                    removed.addAll(node.getDependents());
                    if (!(node instanceof TrackerNodeImplEx)) continue;
                    TrackerNodeImplEx trackerNodeImplEx = (TrackerNodeImplEx)node;
                    trackerNodeImplEx.getLoadBindings().clear();
                    trackerNodeImplEx.getReferenceBindings().clear();
                    TrackerNodeImplEx tnParent2 = (TrackerNodeImplEx)trackerNodeImplEx.getParentNode();
                    if (tnParent2 == null) continue;
                    removeDependentsNodes.put(tnParent2, new Pair(trackerNodeImplEx.getFieldScript(), (Object)trackerNodeImplEx));
                    continue;
                }
                if (!(node instanceof TrackerNodeImplEx)) continue;
                TrackerNodeImplEx trackerNodeImplEx = (TrackerNodeImplEx)node;
                Iterator<LoadBinding> it = trackerNodeImplEx.getLoadBindings().iterator();
                while (it.hasNext()) {
                    next = it.next();
                    if (!comp.equals(next.getComponent())) continue;
                    it.remove();
                }
                it = trackerNodeImplEx.getReferenceBindings().iterator();
                while (it.hasNext()) {
                    next = (ReferenceBinding)it.next();
                    if (!comp.equals(next.getComponent())) continue;
                    it.remove();
                }
            }
            Set<TrackerNode> remove = this._compTailMap.remove(comp);
            for (TrackerNode trackerNode : remove) {
                LoadBinding next;
                if (!this.isUsedInOtherComponent(trackerNode)) {
                    removed.add(trackerNode);
                    removed.addAll(trackerNode.getDependents());
                }
                if (!(trackerNode instanceof TrackerNodeImplEx)) continue;
                TrackerNodeImplEx tn = (TrackerNodeImplEx)trackerNode;
                Iterator<LoadBinding> it = tn.getLoadBindings().iterator();
                while (it.hasNext()) {
                    next = it.next();
                    if (!comp.equals(next.getComponent())) continue;
                    it.remove();
                }
                it = tn.getReferenceBindings().iterator();
                while (it.hasNext()) {
                    next = (ReferenceBinding)it.next();
                    if (!comp.equals(next.getComponent())) continue;
                    it.remove();
                }
                if (tn.getLoadBindings().size() != 0 || tn.getReferenceBindings().size() != 0 || tn.getDependents().size() != 0 || (tnParent = (TrackerNodeImplEx)tn.getParentNode()) == null) continue;
                removeDependentsNodes.put(tnParent, new Pair(tn.getFieldScript(), (Object)tn));
            }
            for (Map.Entry entry : removeDependentsNodes.entrySet()) {
                Pair nodeInfo = (Pair)entry.getValue();
                tnParent = (TrackerNodeImplEx)entry.getKey();
                tnParent.removeDependent(nodeInfo.x, (TrackerNode)nodeInfo.y);
                if (tnParent.getLoadBindings().size() != 0 || tnParent.getReferenceBindings().size() != 0 || tnParent.getDependents().size() != 0) continue;
                removed.add(tnParent);
            }
            this.removeAllReference(removed);
        }
    }

    private boolean hasAnotherOwner(TrackerNode node) {
        if (this._compMap instanceof LinkedHashBiMap) {
            return ((LinkedHashBiMap)this._compMap).inverseFromMapValue().containsKey(node);
        }
        for (Map trackers : this._compMap.values()) {
            if (!trackers.containsValue(node)) continue;
            return true;
        }
        return false;
    }

    private boolean isUsedInOtherComponent(TrackerNode node) {
        return ((LinkedHashBiMap)this._compTailMap).inverseFromSetValue().containsKey(node) || !node.getDependents().isEmpty();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    private static class EqualBeans {
        private transient int _beanHash;
        private transient Set<Object> _beanSet;

        public EqualBeans(Object value) {
            this._beanHash = value == null ? 0 : value.hashCode();
            this.add(value);
        }

        public void add(Object value) {
            this._beanSet = AllocUtil.inst.addWeakIdentityHashSet(this._beanSet, value);
        }

        public Set<Object> getBeans() {
            return this._beanSet != null ? new IdentityHashSet(this._beanSet) : Collections.emptySet();
        }

        public boolean remove(Object value) {
            if (this._beanSet == null) {
                return false;
            }
            boolean result = this._beanSet.remove(value);
            if (this._beanSet.isEmpty()) {
                this._beanSet = null;
            }
            return result;
        }

        public int getBeanHash() {
            return this._beanHash;
        }
    }

    protected static class EqualBeansMapEx
    extends TrackerImpl.EqualBeansMap {
        private transient WeakHashMap<Object, EqualBeans> _innerMap = new WeakHashMap();
        private transient WeakIdentityMap<Object, EqualBeans> _identityMap = new WeakIdentityMap();

        protected EqualBeansMapEx() {
        }

        private void syncInnerMap0(EqualBeans equalBeans, Object bean) {
            int beanHash = equalBeans.getBeanHash();
            ProxyBean fake = new ProxyBean(beanHash, bean);
            this._innerMap.remove(fake);
            equalBeans.remove(bean);
            this.syncEqualBeans(equalBeans);
        }

        public void put(Object bean) {
            EqualBeans equalBeans = this._innerMap.get(bean);
            if (equalBeans == null) {
                equalBeans = (EqualBeans)this._identityMap.remove(bean);
                if (equalBeans != null) {
                    this.syncInnerMap0(equalBeans, bean);
                    this.put(bean);
                    return;
                }
                equalBeans = new EqualBeans(bean);
                this._innerMap.put(bean, equalBeans);
            } else {
                equalBeans.add(bean);
                equalBeans = new EqualBeans(bean);
            }
            this._identityMap.put(bean, (Object)equalBeans);
        }

        public void remove(Object bean) {
            EqualBeans equalBeans = this._innerMap.remove(bean);
            if (equalBeans == null) {
                equalBeans = (EqualBeans)this._identityMap.remove(bean);
                if (equalBeans != null) {
                    this.syncInnerMap0(equalBeans, bean);
                }
            } else {
                this._identityMap.remove(bean);
                equalBeans.remove(bean);
                this.syncEqualBeans(equalBeans);
            }
        }

        public Set<Object> getEqualBeans(Object bean) {
            EqualBeans equalBeans;
            boolean doSync = false;
            if (bean instanceof Collection) {
                equalBeans = (EqualBeans)this._identityMap.get(bean);
                EqualBeans innerBean = this._innerMap.get(bean);
                if (equalBeans == null) {
                    equalBeans = innerBean;
                } else if (innerBean == null) {
                    this._identityMap.remove(bean);
                    doSync = true;
                }
            } else {
                equalBeans = this._innerMap.get(bean);
                if (equalBeans == null && (equalBeans = (EqualBeans)this._identityMap.remove(bean)) != null) {
                    doSync = true;
                }
            }
            if (doSync) {
                this.syncInnerMap0(equalBeans, bean);
                this.put(bean);
                equalBeans = (EqualBeans)this._identityMap.get(bean);
            }
            return equalBeans == null ? Collections.emptySet() : equalBeans.getBeans();
        }

        public int size() {
            return this._innerMap.size();
        }

        private void syncEqualBeans(EqualBeans equalBeans) {
            int beanHash = equalBeans.getBeanHash();
            boolean proxied = false;
            for (Object proxy : equalBeans.getBeans()) {
                if (proxy.hashCode() != beanHash) {
                    equalBeans.remove(proxy);
                    this._identityMap.remove(proxy);
                    this.put(proxy);
                    continue;
                }
                if (proxied) continue;
                proxied = true;
                this._innerMap.put(proxy, equalBeans);
            }
        }
    }

    private static class ProxyBean {
        private final int _hashCode;
        private final Object _innerBean;

        private ProxyBean(int hashCode, Object innerBean) {
            this._hashCode = hashCode;
            this._innerBean = innerBean;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            return Objects.equals((Object)this._innerBean, (Object)o);
        }
    }
}

