/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.Orgchildren;
import org.zkoss.zkmax.zul.Orgitem;
import org.zkoss.zkmax.zul.OrgitemRenderer;
import org.zkoss.zkmax.zul.Orgnode;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.SelectionControl;
import org.zkoss.zul.ext.TreeOpenableModel;
import org.zkoss.zul.ext.TreeSelectableModel;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Organigram
extends XulElement {
    private static final Logger log = LoggerFactory.getLogger(Organigram.class);
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zkmax.zul.Organigram.onInitLaterPosted";
    private Orgchildren _orgchildren;
    private TreeModel<Object> _model;
    private Orgitem _selectedItem;
    private TreeDataListener _dataListener;
    private OrgitemRenderer<?> _itemRenderer;
    private Boolean SELECTIVE_COMPONENT_UPDATE = null;
    private static final OrgitemRenderer _defaultRenderer;

    public Orgchildren getOrgchildren() {
        return this._orgchildren;
    }

    public Collection<Orgitem> getItems() {
        if (this._orgchildren != null) {
            return this._orgchildren.getItems();
        }
        return Collections.emptyList();
    }

    public int getItemCount() {
        return this._orgchildren != null ? this._orgchildren.getItemCount() : 0;
    }

    public int getVisibleItemCount() {
        return this._orgchildren != null ? this._orgchildren.getVisibleItemCount() : 0;
    }

    public Orgitem getSelectedItem() {
        return this._selectedItem;
    }

    public void setSelectedItem(Orgitem selectedItem) {
        if (selectedItem != this._selectedItem) {
            if (this._selectedItem != null) {
                this.toggleItemSelection(this._selectedItem);
            }
            if (selectedItem != null) {
                this.toggleItemSelection(selectedItem);
            }
        }
    }

    void toggleItemSelection(Orgitem orgitem) {
        if (orgitem.isSelected()) {
            this.removeItemFromSelection(orgitem);
        } else {
            this.addItemToSelection(orgitem);
        }
        this.smartUpdate("selectedItem", (Object)this._selectedItem);
    }

    private void addItemToSelection(Orgitem orgitem) {
        if (orgitem.getOrganigram() != this) {
            throw new UiException("Not a child: " + String.valueOf((Object)orgitem));
        }
        this._selectedItem = orgitem;
        this._selectedItem.setSelectedDirectly(true);
    }

    private void removeItemFromSelection(Orgitem orgitem) {
        orgitem.setSelectedDirectly(false);
        this._selectedItem = null;
    }

    public void clear() {
        if (this._orgchildren != null) {
            this._orgchildren.getChildren().clear();
        }
    }

    public void beforeChildAdded(Component child, Component insertBefore) {
        if (child instanceof Orgchildren && this._orgchildren != null && this._orgchildren != child) {
            throw new UiException("Only one orgchildren is allowed: " + String.valueOf((Object)this));
        }
        super.beforeChildAdded(child, insertBefore);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Orgchildren && super.insertBefore(newChild, refChild)) {
            this._orgchildren = (Orgchildren)newChild;
            return true;
        }
        return false;
    }

    void onOrgitemAdded(Orgitem item) {
        this.fixNewChild(item);
        this.onOrgchildrenAdded(item.getOrgchildren());
    }

    void onOrgitemRemoved(Orgitem item) {
        if (item.isSelected() && this._selectedItem == item) {
            this._selectedItem = null;
        }
        this.onOrgchildrenRemoved(item.getOrgchildren());
    }

    void onOrgchildrenAdded(Orgchildren orgchildren) {
        if (orgchildren == null || orgchildren.getParent() == this) {
            return;
        }
        for (Orgitem item : orgchildren.getItems()) {
            this.fixNewChild(item);
        }
    }

    void onOrgchildrenRemoved(Orgchildren orgchildren) {
        if (orgchildren == null || orgchildren.getParent() == this) {
            return;
        }
        for (Orgitem item : orgchildren.getItems()) {
            if (!item.isSelected() || this._selectedItem != item) continue;
            this._selectedItem = null;
            return;
        }
    }

    private void fixNewChild(Orgitem item) {
        if (item.isSelected()) {
            if (this._selectedItem != null) {
                item.setSelectedDirectly(false);
                item.invalidate();
            } else {
                this._selectedItem = item;
            }
        }
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Orgchildren) {
            this._orgchildren = null;
            this._selectedItem = null;
        }
        super.onChildRemoved(child);
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (this._model != null && this._dataListener != null) {
            this._model.removeTreeDataListener(this._dataListener);
            this._model.addTreeDataListener(this._dataListener);
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this._model != null && this._dataListener != null) {
            this._model.removeTreeDataListener(this._dataListener);
        }
    }

    public Object clone() {
        Organigram clone = (Organigram)((Object)super.clone());
        if (this._orgchildren != null) {
            clone.afterUnmarshal();
        }
        if (clone._model != null) {
            TreeModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (TreeModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone._dataListener = null;
            clone.initDataListener();
            clone.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        }
        return clone;
    }

    private void afterUnmarshal() {
        this._orgchildren = (Orgchildren)((Object)this.getChildren().get(0));
        if (this._selectedItem != null) {
            for (Orgitem orgitem : this.getItems()) {
                if (!orgitem.isSelected()) continue;
                this._selectedItem = orgitem;
                break;
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, this._model);
        this.willSerialize(this._itemRenderer);
        Serializables.smartWrite((ObjectOutputStream)s, this._itemRenderer);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (TreeModel)s.readObject();
        this.didDeserialize(this._model);
        this._itemRenderer = (OrgitemRenderer)s.readObject();
        this.didDeserialize(this._itemRenderer);
        if (this._orgchildren != null) {
            this.afterUnmarshal();
        }
        if (this._model != null) {
            this.initDataListener();
        }
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._itemRenderer);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._itemRenderer);
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new TreeDataListener(){

                public void onChange(TreeDataEvent event) {
                    Organigram.this.onTreeDataChange(event);
                }
            };
        }
        this._model.addTreeDataListener(this._dataListener);
    }

    private void onTreeDataChange(TreeDataEvent event) {
        if (this.SELECTIVE_COMPONENT_UPDATE == null) {
            this.SELECTIVE_COMPONENT_UPDATE = Utils.testAttribute((Component)this, (String)"org.zkoss.zul.model.selectiveComponentUpdate.enable", (boolean)false, (boolean)true);
        }
        int type = event.getType();
        int[] path = event.getPath();
        Component target = path != null ? this.getChildByPath(path) : null;
        switch (type) {
            case 4: {
                if (target instanceof Orgitem) {
                    ((Orgitem)target).setSelected(((TreeSelectableModel)this._model).isPathSelected(path));
                }
                return;
            }
            case 5: {
                if (this._model instanceof TreeOpenableModel && target instanceof Orgitem) {
                    ((Orgitem)target).setOpen(((TreeOpenableModel)this._model).isPathOpened(path));
                }
                return;
            }
            case 11: {
                this.disableClientUpdate(true);
                return;
            }
            case 12: {
                this.disableClientUpdate(false);
                return;
            }
        }
        if (target != null) {
            Object node = this._model.getChild(path);
            int indexFrom = event.getIndexFrom();
            int indexTo = event.getIndexTo();
            switch (type) {
                case 1: {
                    int i;
                    for (i = indexFrom; i <= indexTo; ++i) {
                        this.onTreeDataInsert(target, node, i);
                    }
                    if (this.SELECTIVE_COMPONENT_UPDATE.booleanValue()) break;
                    int endSize = this._model.getChildCount(node);
                    for (i = indexTo + 1; i < endSize; ++i) {
                        this.onTreeDataContentChange(target, node, i);
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = indexTo; i >= indexFrom; --i) {
                        this.onTreeDataRemoved(target, node, i);
                    }
                    if (this.SELECTIVE_COMPONENT_UPDATE.booleanValue()) break;
                    int endSize = this._model.getChildCount(node);
                    for (i = indexTo; i < endSize; ++i) {
                        this.onTreeDataContentChange(target, node, i);
                    }
                    break;
                }
                case 0: {
                    for (int i = indexFrom; i <= indexTo; ++i) {
                        this.onTreeDataContentChange(target, node, i);
                    }
                    break;
                }
            }
        }
    }

    private void onTreeDataInsert(Component parent, Object node, int index) {
        Orgitem newItem = this.newUnloadedItem();
        Orgchildren orgchildren = Organigram.orgchildrenOf(parent);
        if (!(parent instanceof Orgitem) || ((Orgitem)parent).isLoaded()) {
            List siblings = orgchildren.getChildren();
            orgchildren.insertBefore((Component)newItem, (Component)(siblings.isEmpty() || index == siblings.size() ? null : (Orgitem)((Object)siblings.get(index))));
            this.renderChangedItem(newItem, this._model.getChild(node, index));
        }
    }

    private void onTreeDataRemoved(Component parent, Object node, int index) {
        Orgchildren orgchildren = Organigram.orgchildrenOf(parent);
        List items = orgchildren.getChildren();
        if (items.size() > index) {
            ((Component)items.get(index)).detach();
        } else if (!(parent instanceof Orgitem) || ((Orgitem)parent).isLoaded()) {
            orgchildren.detach();
        }
    }

    private void onTreeDataContentChange(Component parent, Object node, int index) {
        List items = Organigram.orgchildrenOf(parent).getChildren();
        if (!items.isEmpty()) {
            this.renderChangedItem((Orgitem)((Object)items.get(index)), this._model.getChild(node, index));
        }
    }

    private static Orgchildren orgchildrenOf(Component parent) {
        Orgchildren orgchildren;
        Orgchildren orgchildren2 = orgchildren = parent instanceof Organigram ? ((Organigram)parent).getOrgchildren() : ((Orgitem)parent).getOrgchildren();
        if (orgchildren == null) {
            orgchildren = new Orgchildren();
            orgchildren.setParent(parent);
        }
        return orgchildren;
    }

    private Component getChildByPath(int[] path) {
        if (path.length == 0) {
            return this;
        }
        Orgitem item = Organigram.getChildOrgitem(this.getOrgchildren(), path[0]);
        for (int j = 1; j < path.length && item != null; ++j) {
            item = Organigram.getChildOrgitem(item.getOrgchildren(), path[j]);
        }
        return item;
    }

    private static Orgitem getChildOrgitem(Orgchildren orgchildren, int i) {
        if (orgchildren == null) {
            return null;
        }
        List cs = orgchildren.getChildren();
        return i < 0 || i >= cs.size() ? null : (Orgitem)((Object)cs.get(i));
    }

    public <T> TreeModel<T> getModel() {
        return this._model;
    }

    public void setModel(TreeModel<?> model) {
        if (model != null) {
            if (!(model instanceof TreeSelectableModel)) {
                throw new UiException(String.valueOf(model.getClass()) + " must implement " + String.valueOf(TreeSelectableModel.class));
            }
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeTreeDataListener(this._dataListener);
                } else {
                    if (this._orgchildren != null) {
                        this._orgchildren.detach();
                    }
                    this.smartUpdate("model", true);
                }
                this.setModelDirectly(model);
                this.initDataListener();
            }
            this.postOnInitRender();
        } else if (this._model != null) {
            this._model.removeTreeDataListener(this._dataListener);
            this._model = null;
            if (this._orgchildren != null) {
                this._orgchildren.detach();
            }
            this.smartUpdate("model", false);
        }
    }

    private void setModelDirectly(TreeModel model) {
        this._model = model;
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        this.renderOrganigram();
    }

    public <T> OrgitemRenderer<T> getItemRenderer() {
        return this._itemRenderer;
    }

    public void setItemRenderer(OrgitemRenderer<?> renderer) {
        if (this._itemRenderer != renderer) {
            this._itemRenderer = renderer;
            if (this._model != null) {
                this.postOnInitRender();
            }
        }
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((OrgitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderOrganigram() {
        if (this._orgchildren == null) {
            Orgchildren children = new Orgchildren();
            children.setParent((Component)this);
        } else {
            this._orgchildren.getChildren().clear();
        }
        Object node = this._model.getRoot();
        Renderer renderer = new Renderer();
        try {
            this.renderChildren(renderer, this._orgchildren, node);
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    private void renderChildren(Renderer renderer, Orgchildren parent, Object node) throws Throwable {
        int j = this._model.getChildCount(node);
        for (int i = 0; i < j; ++i) {
            Orgitem orgitem = this.newUnloadedItem();
            orgitem.setParent((Component)parent);
            Object childNode = this._model.getChild(node, i);
            this.renderChildren0(renderer, parent, orgitem, childNode, i);
        }
    }

    private void renderChildren0(Renderer renderer, Orgchildren parent, Orgitem orgitem, Object childNode, int i) throws Throwable {
        SelectionControl control;
        TreeSelectableModel model;
        boolean isLeaf;
        renderer.render(orgitem, childNode, i);
        Object v = orgitem.getAttribute("org.zkoss.zul.model.renderAs");
        if (v != null) {
            orgitem = (Orgitem)((Object)v);
            orgitem.setOpen(false);
        }
        orgitem.setRendered(true);
        int[] path = null;
        boolean bl = isLeaf = childNode != null && this._model.isLeaf(childNode);
        if (this._model instanceof TreeSelectableModel && !(model = (TreeSelectableModel)this._model).isSelectionEmpty() && model.isPathSelected(path = this.getPath0(parent, i))) {
            this.addItemToSelection(orgitem);
        }
        if (this._model instanceof Selectable && (control = (model = (Selectable)this._model).getSelectionControl()) != null) {
            orgitem.setSelectable(control.isSelectable(childNode));
        }
        if (this._model instanceof TreeOpenableModel && !(model = (TreeOpenableModel)this._model).isOpenEmpty() && !isLeaf) {
            if (path == null) {
                path = this.getOrgitemPath((Component)this, (Component)orgitem);
            }
            orgitem.setOpen(model.isPathOpened(path));
        }
        if (!isLeaf && orgitem.getOrgchildren() == null) {
            Orgchildren orgchildren = new Orgchildren();
            orgchildren.setParent((Component)orgitem);
            if (orgitem.isOpen()) {
                this.renderChildren(renderer, orgchildren, childNode);
            }
        }
    }

    private int[] getPath0(Orgchildren parent, int index) {
        LinkedList<Integer> path = new LinkedList<Integer>();
        path.add(index);
        Orgchildren p = parent;
        while ((p = p.getParent()) instanceof Orgitem) {
            Component orgchildren = p.getParent();
            if (orgchildren == null) continue;
            path.add(0, orgchildren.getChildren().indexOf((Object)p));
            p = orgchildren;
        }
        int[] ipath = new int[path.size()];
        for (int j = 0; j < ipath.length; ++j) {
            ipath[j] = (Integer)path.get(j);
        }
        return ipath;
    }

    int[] getOrgitemPath(Component root, Component lastNode) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        Component curNode = lastNode;
        while (!root.equals(curNode)) {
            if (curNode instanceof Orgitem) {
                l.add(0, new Integer(((Orgitem)curNode).getIndex()));
            }
            curNode = curNode.getParent();
        }
        Integer[] objs = l.toArray(new Integer[l.size()]);
        int[] path = new int[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            path[i] = objs[i];
        }
        return path;
    }

    private Orgitem newUnloadedItem() {
        Orgitem orgitem = new Orgitem();
        orgitem.setOpen(false);
        return orgitem;
    }

    private OrgitemRenderer getRealRenderer() {
        return this._itemRenderer != null ? this._itemRenderer : _defaultRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItem(Orgitem item) {
        if (this._model != null) {
            Renderer renderer = new Renderer();
            try {
                this.renderItem0(renderer, item);
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    private void renderItem0(Renderer renderer, Orgitem orgitem) throws Throwable {
        this.renderItem0(renderer, orgitem, this._model.getChild(this.getOrgitemPath((Component)this, (Component)orgitem)));
    }

    private void renderItem0(Renderer renderer, Orgitem orgitem, Object node) throws Throwable {
        if (orgitem.isLoaded()) {
            return;
        }
        Orgchildren orgchildren = orgitem.getOrgchildren();
        if (this._model.isLeaf(node) && orgchildren != null) {
            orgchildren.detach();
        } else {
            if (orgchildren != null) {
                orgchildren.getChildren().clear();
            } else {
                orgchildren = new Orgchildren();
                orgchildren.setParent((Component)orgitem);
            }
            this.renderChildren(renderer, orgchildren, node);
        }
        Object v = orgitem.getAttribute("org.zkoss.zul.model.renderAs");
        if (v != null) {
            orgitem = (Orgitem)((Object)v);
            orgitem.setOpen(false);
        }
        orgitem.setLoaded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderChangedItem(Orgitem item, Object node) {
        if (this._model != null) {
            Orgchildren orgchildren = item.getOrgchildren();
            if (this._model.isLeaf(node)) {
                if (orgchildren != null) {
                    orgchildren.detach();
                }
            } else if (orgchildren == null) {
                orgchildren = new Orgchildren();
                orgchildren.setParent((Component)item);
            }
            Renderer renderer = new Renderer();
            try {
                renderer.renderChangedItem(item, node, item.getIndex());
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
    }

    public void service(AuRequest request, boolean everError) {
        String command = request.getCommand();
        if ("onSelect".equals(command)) {
            Desktop desktop = this.getDesktop();
            Map data = request.getData();
            Orgitem selectedItem = (Orgitem)desktop.getComponentByUuid((String)data.get("selectedItem"));
            Set<Orgitem> currentSelectedItem = Collections.singleton(selectedItem);
            Set<Orgitem> previousSelectedItem = Collections.singleton(this._selectedItem);
            Set currentSelectedObject = null;
            Set previousSelectedObject = null;
            if (this._selectedItem != null) {
                this._selectedItem.setSelectedDirectly(false);
            }
            if (selectedItem != null) {
                selectedItem.setSelectedDirectly(true);
            }
            this._selectedItem = selectedItem;
            if (this._model instanceof TreeSelectableModel) {
                previousSelectedObject = ((Selectable)this._model).getSelection();
                ((TreeSelectableModel)this._model).addSelectionPath(this.getOrgitemPath((Component)this, (Component)selectedItem));
                currentSelectedObject = ((Selectable)this._model).getSelection();
            }
            SelectEvent evt = new SelectEvent("onSelect", (Component)this, currentSelectedItem, previousSelectedItem, previousSelectedItem, currentSelectedObject, previousSelectedObject, previousSelectedObject, desktop.getComponentByUuidIfAny((String)data.get("reference")), null, AuRequests.parseKeys((Map)data));
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        if (this._model != null) {
            this.render(renderer, "model", true);
        }
        this.render(renderer, "selectedItem", (Object)this.getSelectedItem());
    }

    public String getZclass() {
        return this._zclass == null ? "z-organigram" : this._zclass;
    }

    static {
        Organigram.addClientEvent(Organigram.class, (String)"onSelect", (int)1);
        _defaultRenderer = new OrgitemRenderer(){

            public void render(Orgitem orgitem, final Object node, final int index) {
                Organigram organigram = orgitem.getOrganigram();
                Template template = organigram.getTemplate("model");
                if (template == null) {
                    Orgnode orgnode = new Orgnode(Objects.toString((Object)node));
                    orgitem.setValue(node);
                    orgnode.setParent((Component)orgitem);
                } else {
                    Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])template.create(orgitem.getParent(), (Component)orgitem, new VariableResolver(){

                        public Object resolveVariable(String name) {
                            if ("each".equals(name)) {
                                return node;
                            }
                            if ("forEachStatus".equals(name)) {
                                return new ForEachStatus(){

                                    public ForEachStatus getPrevious() {
                                        return null;
                                    }

                                    public Object getEach() {
                                        return this.getCurrent();
                                    }

                                    public int getIndex() {
                                        return index;
                                    }

                                    public Integer getBegin() {
                                        return 0;
                                    }

                                    public Integer getEnd() {
                                        throw new UnsupportedOperationException("end not available");
                                    }

                                    public Object getCurrent() {
                                        return node;
                                    }

                                    public boolean isFirst() {
                                        return this.getCount() == 1;
                                    }

                                    public boolean isLast() {
                                        return this.getIndex() + 1 == this.getEnd();
                                    }

                                    public Integer getStep() {
                                        return null;
                                    }

                                    public int getCount() {
                                        return this.getIndex() + 1;
                                    }
                                };
                            }
                            return null;
                        }
                    }, null));
                    if (items.length != 1) {
                        throw new UiException("The model template must have exactly one item, not " + items.length);
                    }
                    Orgitem newOrgitem = (Orgitem)items[0];
                    if (newOrgitem.getValue() == null) {
                        newOrgitem.setValue(node);
                    }
                    orgitem.setAttribute("org.zkoss.zul.model.renderAs", (Object)newOrgitem);
                    orgitem.detach();
                }
            }
        };
    }

    private class Renderer
    implements Serializable {
        private final OrgitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Organigram.this.getRealRenderer();
        }

        private void renderChangedItem(Orgitem item, Object node, int index) throws Throwable {
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)this._renderer).doTry();
                this._ctrled = true;
            }
            try {
                Orgchildren orgchildren = item.getOrgchildren();
                this._renderer.render(item, node, index);
                Object newOrgitem = item.getAttribute("org.zkoss.zul.model.renderAs");
                if (newOrgitem instanceof Orgitem) {
                    Orgitem newItem = (Orgitem)((Object)newOrgitem);
                    if (orgchildren != null) {
                        newItem.appendChild((Component)orgchildren);
                    }
                    if (Organigram.this._model instanceof TreeOpenableModel) {
                        TreeOpenableModel model = (TreeOpenableModel)Organigram.this._model;
                        newItem.setOpen(!model.isOpenEmpty() && model.isPathOpened(Organigram.this.getPath0((Orgchildren)newItem.getParent(), index)));
                        if (!item.isLoaded() && newItem.isOpen()) {
                            Organigram.this.renderChildren(this, orgchildren, node);
                        }
                        newItem.setLoaded(item.isLoaded());
                        newItem.setRendered(item.isRendered());
                    }
                } else {
                    item.setRendered(true);
                }
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                throw ex;
            }
            this._rendered = true;
        }

        private void render(Orgitem item, Object node, int index) throws Throwable {
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)this._renderer).doTry();
                this._ctrled = true;
            }
            try {
                this._renderer.render(item, node, index);
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                throw ex;
            }
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)this._renderer).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)this._renderer).doFinally();
            }
        }
    }
}

