/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.awt.image.RenderedImage;
import java.io.IOException;
import org.zkoss.image.Image;
import org.zkoss.image.Images;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.Linelayout;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Lineitem
extends XulElement {
    private boolean _pointVisible = true;
    private String _pointStyle;
    private String _pointImageSrc;
    private Image _pointImageContent;
    private String _pointIconSclass;
    private boolean _opposite;
    private String _frontSpace;
    private String _backSpace;
    private byte _imgver;

    public boolean isPointVisible() {
        return this._pointVisible;
    }

    public void setPointVisible(boolean pointVisible) {
        if (this._pointVisible != pointVisible) {
            this._pointVisible = pointVisible;
            this.smartUpdate("pointVisible", this._pointVisible);
        }
    }

    public String getPointStyle() {
        return this._pointStyle;
    }

    public void setPointStyle(String pointStyle) {
        if (!Objects.equals((Object)this._pointStyle, (Object)pointStyle)) {
            this._pointStyle = pointStyle;
            this.smartUpdate("pointStyle", this._pointStyle);
        }
    }

    public String getPointImageSrc() {
        return this._pointImageSrc;
    }

    public void setPointImageSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._pointImageContent != null || !Objects.equals((Object)this._pointImageSrc, (Object)src)) {
            this._pointImageSrc = src;
            this._pointImageContent = null;
            this.smartUpdate("pointImageSrc", new EncodedURL());
        }
    }

    public Image getPointImageContent() {
        return this._pointImageContent;
    }

    public void setPointImageContent(Image image) {
        if (this._pointImageSrc != null || image != this._pointImageContent) {
            this._pointImageContent = image;
            this._pointImageSrc = null;
            if (this._pointImageContent != null) {
                this._imgver = (byte)(this._imgver + 1);
            }
            this.smartUpdate("pointImageSrc", new EncodedURL());
        }
    }

    public void setPointImageContent(RenderedImage image) {
        try {
            this.setPointImageContent(image == null ? null : Images.encode((String)"a.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    public String getPointIconSclass() {
        return this._pointIconSclass;
    }

    public void setPointIconSclass(String pointIconSclass) {
        if (!Objects.equals((Object)this._pointIconSclass, (Object)pointIconSclass)) {
            this._pointIconSclass = pointIconSclass;
            this.smartUpdate("pointIconSclass", this._pointIconSclass);
        }
    }

    public boolean isOpposite() {
        return this._opposite;
    }

    public void setOpposite(boolean opposite) {
        if (this._opposite != opposite) {
            this._opposite = opposite;
            this.smartUpdate("opposite", this._opposite);
        }
    }

    public String getFrontSpace() {
        return this._frontSpace;
    }

    public void setFrontSpace(String frontSpace) {
        if (!Objects.equals((Object)this._frontSpace, (Object)frontSpace)) {
            this._frontSpace = frontSpace;
            this.smartUpdate("frontSpace", this._frontSpace);
        }
    }

    public String getBackSpace() {
        return this._backSpace;
    }

    public void setBackSpace(String backSpace) {
        if (!Objects.equals((Object)this._backSpace, (Object)backSpace)) {
            this._backSpace = backSpace;
            this.smartUpdate("backSpace", this._backSpace);
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Linelayout)) {
            throw new UiException("Wrong parent: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (this.getChildren().size() == 2) {
            throw new UiException("Only support two children in Lineitem");
        }
        super.beforeChildAdded(child, refChild);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        if (!this._pointVisible) {
            renderer.render("pointVisible", false);
        }
        this.render(renderer, "pointStyle", this._pointStyle);
        this.render(renderer, "pointImageSrc", this.getEncodedURL());
        this.render(renderer, "pointIconSclass", this._pointIconSclass);
        this.render(renderer, "opposite", this._opposite);
        this.render(renderer, "frontSpace", this._frontSpace);
        this.render(renderer, "backSpace", this._backSpace);
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    private String getEncodedURL() {
        if (this._pointImageContent != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, (int)this._imgver, (String)("c/" + this._pointImageContent.getName()), (String)this._pointImageContent.getFormat());
        }
        if (this._pointImageSrc == null) {
            return "data:image/gif;base64,R0lGODlhAQABAIAAAP///////yH5BAUUAAEALAAAAAABAAEAAAICTAEAOw==";
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(this._pointImageSrc) : "";
    }

    private class EncodedURL
    implements DeferredValue {
        private EncodedURL() {
        }

        public Object getValue() {
            return Lineitem.this.getEncodedURL();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Lineitem.this);
        }

        public Media getMedia(String pathInfo) {
            return Lineitem.this._pointImageContent;
        }
    }
}

