/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.event.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.au.out.AuEchoGlobal;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.impl.DesktopEventQueue;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.DesktopCleanup;

public class GroupEventQueue<T extends Event>
implements EventQueue<T>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(GroupEventQueue.class);
    private static final String CMD_PUBLISH = "z_groupeq_publish";
    private static final String CMD_CLOSE = "z_groupeq_close";
    private final Map<Desktop, QueueInfo> _infs = new HashMap<Desktop, QueueInfo>();
    private final Map<Desktop, List<T>> _evts = new HashMap<Desktop, List<T>>();
    private boolean _closed;
    private final Map<Desktop, String> _ids = new HashMap<Desktop, String>();

    public void publish(T event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        DesktopEventQueue<T> que = this.getDesktopEventQueue(false);
        if (que != null) {
            que.publish(event);
        }
        this.globalEcho(CMD_PUBLISH, event);
    }

    public void subscribe(EventListener<T> listener) {
        this.getDesktopEventQueue(true).subscribe(listener);
    }

    public void subscribe(EventListener<T> listener, EventListener<T> callback) {
        this.getDesktopEventQueue(true).subscribe(listener, callback);
    }

    public void subscribe(EventListener<T> listener, boolean async) {
        this.getDesktopEventQueue(true).subscribe(listener, async);
    }

    public boolean unsubscribe(EventListener<T> listener) {
        DesktopEventQueue<T> que = this.getDesktopEventQueue(false);
        if (que != null && que.unsubscribe(listener)) {
            if (que.isIdle()) {
                this.closeCurrent(true);
            }
            return true;
        }
        return false;
    }

    public boolean isSubscribed(EventListener<T> listener) {
        DesktopEventQueue<T> que = this.getDesktopEventQueue(false);
        return que != null && que.isSubscribed(listener);
    }

    public void close() {
        this._closed = true;
        this.closeCurrent(true);
        this.globalEcho(CMD_CLOSE, null);
    }

    public boolean isClose() {
        return this._closed;
    }

    private static Execution getExecution() {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("Execution required");
        }
        return exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DesktopEventQueue<T> getDesktopEventQueue(boolean autoCreate) {
        QueueInfo qi;
        Desktop desktop = GroupEventQueue.getExecution().getDesktop();
        Map<Desktop, QueueInfo> map = this._infs;
        synchronized (map) {
            qi = this._infs.get(desktop);
            if (qi == null) {
                if (!autoCreate) {
                    return null;
                }
                String serviceId = UUID.randomUUID().toString();
                qi = new QueueInfo(desktop, new EQService(serviceId), new EQCleanup());
                this._infs.put(desktop, qi);
                this._ids.put(desktop, serviceId);
            }
        }
        return qi.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void globalEcho(String cmd, T evt) {
        Desktop curdt = GroupEventQueue.getExecution().getDesktop();
        LinkedList<Desktop> dts = new LinkedList<Desktop>();
        Object id = "|";
        Map<Desktop, QueueInfo> map = this._infs;
        synchronized (map) {
            for (Desktop dt : this._infs.keySet()) {
                if (dt == curdt) continue;
                id = (String)id + this._ids.get(dt) + "|";
                dts.add(dt);
                if (evt == null) continue;
                Map<Desktop, List<T>> map2 = this._evts;
                synchronized (map2) {
                    List<T> evts = this._evts.get(dt);
                    if (evts == null) {
                        evts = new LinkedList<T>();
                        this._evts.put(dt, evts);
                    }
                    evts.add(evt);
                }
            }
        }
        if (!dts.isEmpty()) {
            Clients.response(null, (AuResponse)new AuEchoGlobal(cmd, (String)id, dts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrent(boolean unlisten) {
        QueueInfo qi;
        Desktop desktop = GroupEventQueue.getExecution().getDesktop();
        Map<Desktop, Object> map = this._evts;
        synchronized (map) {
            this._evts.remove(desktop);
        }
        map = this._ids;
        synchronized (map) {
            this._ids.remove(desktop);
        }
        Map<Desktop, QueueInfo> map2 = this._infs;
        synchronized (map2) {
            qi = this._infs.remove(desktop);
        }
        if (qi != null) {
            try {
                qi.queue.close();
            }
            catch (Throwable t) {
                log.warn("Failed to close " + String.valueOf(qi.queue), t);
            }
            if (unlisten) {
                qi.unlisten(desktop);
            }
        }
    }

    private class QueueInfo
    implements Serializable {
        private final DesktopEventQueue<T> queue = new DesktopEventQueue();
        private final AuService _svc;
        private final DesktopCleanup _clean;

        private QueueInfo(Desktop desktop, AuService svc, DesktopCleanup clean) {
            this._svc = svc;
            desktop.addListener((Object)this._svc);
            this._clean = clean;
            desktop.addListener((Object)this._clean);
        }

        private void unlisten(Desktop desktop) {
            desktop.removeListener((Object)this._svc);
            desktop.removeListener((Object)this._clean);
        }
    }

    private class EQCleanup
    implements DesktopCleanup,
    Serializable {
        private EQCleanup() {
        }

        public void cleanup(Desktop desktop) throws Exception {
            GroupEventQueue.this.closeCurrent(false);
        }
    }

    private class EQService
    implements AuService,
    Serializable {
        private final String _serviceId;

        public EQService(String id) {
            this._serviceId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean service(AuRequest request, boolean everError) {
            String nm = request.getCommand();
            if (GroupEventQueue.CMD_PUBLISH.equals(nm)) {
                DesktopEventQueue que;
                List evts;
                String id = (String)request.getData().get("");
                if (id == null || !id.contains("|" + this._serviceId + "|")) {
                    return false;
                }
                Map map = GroupEventQueue.this._evts;
                synchronized (map) {
                    evts = GroupEventQueue.this._evts.remove(request.getDesktop());
                }
                if (evts != null && (que = GroupEventQueue.this.getDesktopEventQueue(false)) != null) {
                    for (Event evt : evts) {
                        que.publish(evt);
                    }
                }
                return true;
            }
            if (GroupEventQueue.CMD_CLOSE.equals(nm)) {
                GroupEventQueue.this.closeCurrent(true);
                return true;
            }
            return false;
        }
    }
}

