/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.websocket;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private Map<String, Object> _extraHeaders = new HashMap<String, Object>(4);
    private List<String> _cookies;
    private Map<String, Object> _general = new HashMap<String, Object>(4);
    private Locale _locale = Locale.getDefault();
    private String _charset = Charset.defaultCharset().toString();
    private String _contentType;

    public ResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public void addCookie(Cookie cookie) {
        if (this._cookies == null) {
            this._cookies = new ArrayList<String>();
            this._extraHeaders.put("cookie", this._cookies);
        }
        if (cookie.getName() != null) {
            String c = cookie.getName() + "=" + cookie.getValue();
            if (cookie.getPath() != null) {
                c = c + ";path=" + cookie.getPath();
            }
            if (cookie.getDomain() != null) {
                c = c + ";domain=" + cookie.getDomain();
            }
            if (cookie.getMaxAge() != -1) {
                c = c + ";max-age=" + cookie.getMaxAge();
            }
            if (cookie.getSecure()) {
                c = c + ";secure";
            }
            this._cookies.add(c);
        }
    }

    public void setHeader(String name, String value) {
        this._extraHeaders.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this._extraHeaders.put(name, value);
    }

    public void setDateHeader(String name, long date) {
        this._extraHeaders.put(name, date);
    }

    public void addHeader(String name, String value) {
        this._extraHeaders.put(name, value);
    }

    public void addDateHeader(String name, long date) {
        this._extraHeaders.put(name, date);
    }

    public void addIntHeader(String name, int value) {
        this._extraHeaders.put(name, value);
    }

    public boolean containsHeader(String name) {
        return this._extraHeaders.containsKey(name);
    }

    protected Map<String, Object> getExtraHeaders() {
        return this._extraHeaders;
    }

    public String getHeader(String name) {
        return String.valueOf(this._extraHeaders.get(name));
    }

    public Collection<String> getHeaders(String name) {
        return super.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this._extraHeaders.keySet();
    }

    public void setStatus(int sc) {
        this._general.put("status", sc);
    }

    public Map<String, Object> getGeneral() {
        return this._general;
    }

    public void setLocale(Locale loc) {
        this._locale = loc;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setCharacterEncoding(String charset) {
        this._charset = charset;
    }

    public String getCharacterEncoding() {
        return this._charset;
    }

    public void setContentType(String type) {
        this._contentType = type;
    }

    public String getContentType() {
        return this._contentType;
    }
}

