/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.Nav;
import org.zkoss.zkmax.zul.Navbar;
import org.zkoss.zul.impl.LabelImageElement;

public class Navitem
extends LabelImageElement
implements Disable {
    private String _href;
    private String _target;
    private String _content;
    private String _badgeText = "";
    private boolean _disabled;
    private boolean _selected;

    public String getHref() {
        return this._href;
    }

    public void setHref(String href) throws WrongValueException {
        if (href != null && href.trim().length() == 0) {
            href = null;
        }
        if (!Objects.equals((Object)this._href, (Object)href)) {
            this._href = href;
            this.smartUpdate("href", new EncodedHref());
        }
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content == null) {
            content = "";
        }
        if (!Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this.smartUpdate("content", this.getContent());
        }
    }

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        if (target != null && target.trim().length() == 0) {
            target = null;
        }
        if (!Objects.equals((Object)this._target, (Object)target)) {
            this._target = target;
            this.smartUpdate("target", this._target);
        }
    }

    public Navbar getNavbar() {
        Component q;
        Navitem p = this;
        while ((q = p.getParent()) != null) {
            if (q instanceof Navbar) {
                return (Navbar)q;
            }
            p = q;
        }
        return null;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Navbar navbar = this.getNavbar();
            if (navbar != null) {
                navbar.selectItem(selected ? this : null);
            } else {
                this._selected = selected;
            }
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public String getBadgeText() {
        return this._badgeText;
    }

    public void setBadgeText(String badgeText) {
        if (!Objects.equals((Object)this._badgeText, (Object)badgeText)) {
            this._badgeText = badgeText;
            this.smartUpdate("badgeText", this._badgeText);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-navitem" : this._zclass;
    }

    public boolean isTopmost() {
        return !(this.getParent() instanceof Nav);
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Nav) && !(parent instanceof Navbar)) {
            throw new UiException("Unsupported parent for navitem: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        this.render(renderer, "selected", this.isSelected());
        this.render(renderer, "disabled", this.isDisabled());
        this.render(renderer, "content", this.getContent());
        this.render(renderer, "badgeText", this._badgeText);
        this.render(renderer, "href", this._href);
        this.render(renderer, "target", this._target);
    }

    private String getEncodedHref() {
        Desktop dt = this.getDesktop();
        return this._href != null && dt != null ? dt.getExecution().encodeURL(this._href) : null;
    }

    private class EncodedHref
    implements DeferredValue {
        private EncodedHref() {
        }

        public Object getValue() {
            return Navitem.this.getEncodedHref();
        }
    }
}

