/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.websocket;

import java.util.HashMap;
import java.util.Map;
import org.zkoss.json.JSONValue;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Library;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zkmax.au.websocket.WebSocketServerPush;

public class WebSocketDesktopInit
implements DesktopInit {
    private ExecutionInit _webSocketExecutionInit = new WebSocketExecutionInit();
    private EventInterceptor _webSocketEventInterceptor = new WebSocketDesktopRecycleEventInterceptor();
    private static Map webSocketClientOptions = new HashMap();

    public void init(Desktop desktop, Object request) throws Exception {
        desktop.getDevice().setServerPushClass(WebSocketServerPush.class);
        desktop.addListener((Object)this._webSocketExecutionInit);
        desktop.addListener((Object)this._webSocketEventInterceptor);
    }

    static void responseAuScript() {
        Clients.response((String)"zk.websocket.start", (AuResponse)new AuScript(null, String.format("zk.afterLoad('zkmax',function(){zWs.start('%s','https:'== document.location.protocol, %s)});", WebApps.getCurrent().getAttribute("websocketUrl").toString(), JSONValue.toJSONString((Object)webSocketClientOptions))));
    }

    static {
        webSocketClientOptions.put("connectionTimeout", Library.getIntProperty((String)"org.zkoss.zkmax.au.websocket.WebSocketEndPoint.connectionTimeout", (int)20000));
        webSocketClientOptions.put("reconnection", Boolean.valueOf(Library.getProperty((String)"org.zkoss.zkmax.au.websocket.WebSocketEndPoint.reconnection", (String)"true")));
        webSocketClientOptions.put("reconnectionAttempts", new JavaScriptValue(Library.getProperty((String)"org.zkoss.zkmax.au.websocket.WebSocketEndPoint.reconnectionAttempts", (String)"Infinity")));
        webSocketClientOptions.put("reconnectionDelay", Library.getIntProperty((String)"org.zkoss.zkmax.au.websocket.WebSocketEndPoint.reconnectionDelay", (int)1000));
        webSocketClientOptions.put("reconnectionDelayMax", Library.getIntProperty((String)"org.zkoss.zkmax.au.websocket.WebSocketEndPoint.reconnectionDelayMax", (int)5000));
    }

    private static class WebSocketDesktopRecycleEventInterceptor
    implements EventInterceptor {
        private WebSocketDesktopRecycleEventInterceptor() {
        }

        public void afterProcessEvent(Event event) {
            if ("onDesktopRecycle".equals(event.getName())) {
                WebSocketDesktopInit.responseAuScript();
            }
        }
    }

    private static class WebSocketExecutionInit
    implements ExecutionInit {
        private WebSocketExecutionInit() {
        }

        public void init(Execution exec, Execution parent) throws Exception {
            WebSocketDesktopInit.responseAuScript();
            exec.getDesktop().removeListener((Object)this);
        }
    }
}

