/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.ui.event.PortalDropEvent;
import org.zkoss.zkmax.ui.event.PortalMoveEvent;
import org.zkoss.zkmax.zul.Portalchildren;
import org.zkoss.zul.Panel;
import org.zkoss.zul.impl.XulElement;

public class Portallayout
extends XulElement {
    private String _maximizedMode = "column";
    private String _orient = "vertical";

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("Unknow orient : " + orient);
        }
        if (!Objects.equals(this._orient, orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public Panel getPanel(int col, int row) {
        if (col < 0 || row < 0 || this.getChildren().size() <= col) {
            return null;
        }
        List children = ((Component)this.getChildren().get(col)).getChildren();
        return children.size() <= row ? null : (Panel)children.get(row);
    }

    public boolean setPanel(Panel panel, int col, int row) {
        if (col < 0 || row < 0 || panel == null || this.getChildren().size() <= col) {
            return false;
        }
        Portalchildren children = (Portalchildren)((Object)this.getChildren().get(col));
        if (children.getChildren().size() <= row) {
            return children.appendChild((Component)panel);
        }
        return children.insertBefore((Component)panel, (Component)children.getChildren().get(row));
    }

    public int[] getPosition(Panel panel) {
        int[] pos = new int[]{-1, -1};
        if (panel == null || panel.getParent() == null) {
            return pos;
        }
        pos[0] = this.getChildren().indexOf(panel.getParent());
        pos[1] = pos[0] < 0 ? pos[0] : panel.getParent().getChildren().indexOf(panel);
        return pos;
    }

    public void setMaximizedMode(String mode) {
        if (!"whole".equals(mode) && !"column".equals(mode)) {
            throw new WrongValueException("Uknown mode: " + mode);
        }
        if (!this._maximizedMode.equals(mode)) {
            this._maximizedMode = mode;
            this.smartUpdate("maximizedMode", mode);
        }
    }

    public String getMaximizedMode() {
        return this._maximizedMode;
    }

    public String getZclass() {
        return this._zclass == null ? "z-portallayout" : this._zclass;
    }

    public void onPortalDrop(PortalDropEvent event) {
        PortalMoveEvent portalMoveEvent = new PortalMoveEvent("onPortalMove", (Component)this, event.getFrom(), event.getTo(), event.getDragged(), event.getDroppedIndex());
        if (!event.isDefaultPrevented()) {
            Portalchildren to = portalMoveEvent.getTo();
            int droppedIndex = portalMoveEvent.getDroppedIndex();
            Panel dragged = portalMoveEvent.getDragged();
            if (dragged.getParent() == to && droppedIndex >= to.getChildren().indexOf(dragged)) {
                ++droppedIndex;
            }
            to.insertBefore((Component)dragged, droppedIndex < to.getChildren().size() ? (Component)to.getChildren().get(droppedIndex) : null);
        }
        Events.postEvent((Event)portalMoveEvent);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        Runtime.init((Object)((Object)this));
        if (!"column".equals(this._maximizedMode)) {
            this.render(renderer, "maximizedMode", this._maximizedMode);
        }
        if (!"vertical".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Portalchildren)) {
            throw new UiException("Unsupported child for Portallayout: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, refChild);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onPortalDrop")) {
            PortalDropEvent evt = PortalDropEvent.getPortalDropEvent(request);
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Portallayout.addClientEvent(Portallayout.class, (String)"onPortalDrop", (int)0);
    }
}

