/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.zkoss.lang.Objects;
import org.zkoss.util.Pair;
import org.zkoss.zkmax.bind.ext.StandardBiMap;

class LinkedHashBiMap<K, V, T>
extends StandardBiMap<K, V> {
    private static final long serialVersionUID = 2015063012371522L;

    public static <K, V, T> LinkedHashBiMap<K, V, T> create() {
        return new LinkedHashBiMap<K, V, T>();
    }

    private LinkedHashBiMap() {
        super(new LinkedHashMap(), new WeakHashMap());
    }

    @Override
    protected V putInBothMaps(K key, V value, boolean force) {
        boolean containedKey = this.containsKey(key);
        if (containedKey && Objects.equals(value, this.get(key))) {
            return value;
        }
        if (force) {
            this.inverse().remove(value);
        }
        Object oldValue = this.delegate().put(key, value);
        this.updateInverseMap(key, containedKey, oldValue, value);
        return oldValue;
    }

    @Override
    protected void updateInverseMap(K key, boolean containedKey, V oldValue, V newValue) {
        if (containedKey) {
            this.removeFromInverseMap(key, oldValue);
        }
        Map<HashSet<Object>, Object> map = this.inverse().delegate();
        if (newValue instanceof Collection) {
            for (Object k : (Collection)newValue) {
                HashSet<K> set = (HashSet<K>)map.get(k);
                if (set == null) {
                    set = new HashSet<K>();
                    map.put((HashSet<Object>)k, set);
                }
                set.add(key);
            }
        } else if (newValue instanceof Map) {
            Map m = (Map)newValue;
            for (Map.Entry me : m.entrySet()) {
                Object k = me.getKey();
                Object v = me.getValue();
                HashSet<Pair> list = (HashSet<Pair>)map.get(v);
                if (list == null) {
                    list = new HashSet<Pair>();
                    map.put((HashSet<Object>)v, list);
                }
                list.add(new Pair(key, k));
            }
        } else {
            map.put((HashSet<Object>)newValue, key);
        }
    }

    @Override
    protected V removeFromBothMaps(Object key) {
        Object oldValue = this.delegate().remove(key);
        this.removeFromInverseMap(key, oldValue);
        return oldValue;
    }

    protected void removeFromInverseMap(K key, V oldValue) {
        Map map = this.inverse().delegate();
        if (oldValue instanceof Collection) {
            for (Object k : (Collection)oldValue) {
                Set set = (Set)map.get(k);
                if (set == null) continue;
                set.remove(key);
                if (!set.isEmpty()) continue;
                map.remove(k);
            }
        } else if (oldValue instanceof Map) {
            Map m = (Map)oldValue;
            for (Map.Entry me : m.entrySet()) {
                Object k = me.getKey();
                Object v = me.getValue();
                Set set = (Set)map.get(v);
                if (set == null) continue;
                set.remove(new Pair(key, k));
                if (!set.isEmpty()) continue;
                map.remove(v);
            }
        } else {
            map.remove(oldValue);
        }
    }

    public StandardBiMap<T, Set<K>> inverseFromSetValue() {
        return super.inverse();
    }

    public StandardBiMap<T, List<Pair<K, Object>>> inverseFromMapValue() {
        return super.inverse();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            stream.writeObject(entry.getKey());
            stream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setDelegates(new LinkedHashMap(Math.max(size * 2, 16)), new LinkedHashMap(Math.max(size * 2, 16)));
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.put(key, value);
        }
    }
}

