/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.impl.XulElement;

public class Drawer
extends XulElement {
    private String _title = null;
    private String _position = "right";
    private boolean _mask = true;
    private boolean _closable = false;
    private boolean _autodrop = false;

    public Drawer() {
        this.setVisibleDirectly(false);
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            this.smartUpdate("title", this._title);
        }
    }

    public String getPosition() {
        return this._position;
    }

    public void setPosition(String position) throws WrongValueException {
        if ("left".equals(position) || "right".equals(position) || "top".equals(position) || "bottom".equals(position)) {
            if (!Objects.equals((Object)this._position, (Object)position)) {
                this._position = position;
                this.smartUpdate("position", this._position);
            }
        } else {
            throw new WrongValueException("position cannot be " + position + ". Should be \"left\", \"right\", \"top\" or \"bottom\".");
        }
    }

    public boolean isMask() {
        return this._mask;
    }

    public void setMask(boolean mask) {
        if (this._mask != mask) {
            this._mask = mask;
            this.smartUpdate("mask", this._mask);
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("closable", this._closable);
        }
    }

    public boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("autodrop", this._autodrop);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        this.render(renderer, "title", this._title);
        this.render(renderer, "closable", this._closable);
        this.render(renderer, "autodrop", this._autodrop);
        if (!"right".equals(this._position)) {
            this.render(renderer, "position", this._position);
        }
        if (!this._mask) {
            renderer.render("mask", false);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onOpen".equals(cmd)) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this.setVisibleDirectly(evt.isOpen());
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-drawer";
    }

    public void setHflex(String flex) {
        throw new UnsupportedOperationException("not supported in drawer");
    }

    public void setVflex(String flex) {
        throw new UnsupportedOperationException("not supported in drawer");
    }

    public void open() {
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
    }

    static {
        Drawer.addClientEvent(Drawer.class, (String)"onOpen", (int)8193);
    }
}

