/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.WeakIdentityMap;
import org.zkoss.zkmax.bind.impl.SingleObjectMap;
import org.zkoss.zkmax.bind.impl.SingleObjectSet;
import org.zkoss.zkmax.bind.impl.SingleObjectWeakIdentitySet;

final class AllocUtilEx
extends AllocUtil {
    private static double _javaVersion = AllocUtilEx.getJavaVersion();

    AllocUtilEx() {
    }

    public <K, V> Map<K, V> putMap(Map<K, V> map, K key, V value) {
        if (map == null) {
            map = new SingleObjectMap();
        } else if (map instanceof SingleObjectMap && !map.containsKey(key)) {
            HashMap<K, V> map0 = new HashMap<K, V>(4);
            map0.putAll(map);
            map = map0;
        }
        map.put(key, value);
        return map;
    }

    public <K, V> Map<K, V> putLinkedHashMap(Map<K, V> map, K key, V value) {
        if (map == null) {
            map = new SingleObjectMap();
        } else if (map instanceof SingleObjectMap && !map.containsKey(key)) {
            LinkedHashMap<K, V> map0 = new LinkedHashMap<K, V>(4);
            map0.putAll(map);
            map = map0;
        }
        map.put(key, value);
        return map;
    }

    public <K, V> Map<K, V> newLinkedHashMap(int size) {
        return size <= 1 ? new SingleObjectMap() : new LinkedHashMap();
    }

    public <V> Set<V> addSet(Set<V> set, V value) {
        if (set == null) {
            set = new SingleObjectSet<V>();
        } else if (set instanceof SingleObjectSet && !set.contains(value)) {
            HashSet<V> set0 = new HashSet<V>(4);
            set0.addAll(set);
            set = set0;
        }
        set.add(value);
        return set;
    }

    public <V> Set<V> addLinkedHashSet(Set<V> set, V value) {
        if (set == null) {
            set = new SingleObjectSet<V>();
        } else if (set instanceof SingleObjectSet && !set.contains(value)) {
            LinkedHashSet<V> set0 = new LinkedHashSet<V>(4);
            set0.addAll(set);
            set = set0;
        }
        set.add(value);
        return set;
    }

    public <V> Set<V> addWeakIdentityHashSet(Set<V> set, V value) {
        if (set == null) {
            set = new SingleObjectWeakIdentitySet<V>();
        } else if (set instanceof SingleObjectWeakIdentitySet && !set.contains(value)) {
            Set set0 = new WeakIdentityMap(4).keySet();
            set0.addAll(set);
            set = set0;
        }
        set.add(value);
        return set;
    }

    public <V> List<V> addList(List<V> list, V value) {
        if (list == null) {
            list = new ArrayList<V>(1);
        }
        list.add(value);
        return list;
    }

    private static double getJavaVersion() {
        String version = System.getProperty("java.specification.version");
        if (version == null) {
            return 1.6;
        }
        try {
            return Double.parseDouble(version);
        }
        catch (NumberFormatException ex) {
            return 1.6;
        }
    }

    public Object processScript(Object script) {
        return script instanceof String ? (_javaVersion > 1.6 ? ((String)script).intern() : script) : script;
    }
}

