/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.websocket;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.Scheduler;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.ui.comet.CometServerPush;
import org.zkoss.zkmax.au.websocket.RequestWrapper;
import org.zkoss.zkmax.au.websocket.ResponseWrapper;
import org.zkoss.zkmax.au.websocket.WebSocketDesktopInit;
import org.zkoss.zkmax.au.websocket.WebSocketEndPoint;

public class WebSocketServerPush
implements ServerPush {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServerPush.class);
    private static final int GIVEUP = -99;
    private Desktop _desktop;
    private ThreadInfo _active;
    private final List<ThreadInfo> _pending = new LinkedList<ThreadInfo>();
    private WebSocketEndPoint _webSocketEndpoint;
    private RequestWrapper _request;
    private boolean _ready;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReady(boolean ready) {
        this._ready = ready;
        if (this._ready) {
            List<ThreadInfo> list = this._pending;
            synchronized (list) {
                if (!this._pending.isEmpty()) {
                    this._ready = false;
                    ThreadInfo info = this._pending.remove(0);
                    Object object = info.lock;
                    synchronized (object) {
                        info.setActive(null);
                        info.lock.notify();
                    }
                }
            }
        }
    }

    protected void setWebSocketConnectionInfos(WebSocketEndPoint webSocketEndpoint, HttpServletRequest request) {
        this._webSocketEndpoint = webSocketEndpoint;
        if (webSocketEndpoint == null) {
            this._request = null;
            return;
        }
        this._request = new RequestWrapper(request, null);
        this.setReady(true);
        if (((DesktopCtrl)this._desktop).scheduledServerPush()) {
            try {
                this._webSocketEndpoint.sendText("$ZKWS_ECHO$");
            }
            catch (IOException e) {
                log.warn("Message not sent: ", (Throwable)e);
            }
        }
    }

    public boolean isActive() {
        return this._active != null && this._active._nActive > 0;
    }

    public void start(Desktop desktop) {
        Double ieVersion = desktop.getExecution().getBrowser("ie");
        if (ieVersion != null && ieVersion < 10.0) {
            desktop.enableServerPush(false);
            ((DesktopCtrl)desktop).enableServerPush((ServerPush)new CometServerPush());
            return;
        }
        this._desktop = desktop;
        WebSocketEndPoint wsep = (WebSocketEndPoint)desktop.getStorage().getItem("org.zkoss.zkmax.au.websocket.WebSocketServerPush");
        if (wsep != null) {
            if (this._webSocketEndpoint == null) {
                this.setWebSocketConnectionInfos(wsep, (HttpServletRequest)desktop.getAttribute("org.zkoss.zkmax.ui.websocket.handshakeHttpServletRequest"));
            }
            wsep.setWebSocketServerPush(this);
        }
        this.startClientPush();
    }

    public void stop() {
        if (this._webSocketEndpoint == null) {
            log.warn("Ignored: Sever-push not started");
            return;
        }
        this.wakePending();
    }

    public void resume() {
        if (this._desktop == null) {
            throw new IllegalStateException("ServerPush cannot be resumed without desktop, or has been stopped!call #start(desktop)} instead");
        }
        this.startClientPush();
    }

    protected void startClientPush() {
        WebSocketDesktopInit.responseAuScript();
    }

    public <T extends Event> void schedule(EventListener<T> listener, T event, Scheduler<T> scheduler) {
        scheduler.schedule(listener, event);
        if (this._webSocketEndpoint != null) {
            try {
                this._webSocketEndpoint.sendText("$ZKWS_ECHO$");
            }
            catch (IOException e) {
                log.warn("Message not sent: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(long timeout) throws InterruptedException, DesktopUnavailableException {
        Thread curr = Thread.currentThread();
        if (this._active != null && this._active._thread.equals(curr)) {
            ++this._active._nActive;
            if (log.isDebugEnabled()) {
                log.debug("Re-activate");
            }
            return true;
        }
        ThreadInfo info = new ThreadInfo(curr);
        List<ThreadInfo> list = this._pending;
        synchronized (list) {
            if (this._desktop != null) {
                if (this._webSocketEndpoint == null || !this._pending.isEmpty() || !this._ready) {
                    this._pending.add(info);
                } else {
                    this._ready = false;
                    info.setActive(null);
                }
            }
        }
        if (!this.checkConnectionReady(info, timeout)) {
            return false;
        }
        if (this._desktop == null) {
            throw new DesktopUnavailableException("Stopped");
        }
        this._request.removeAllAttributes();
        Object response = (HttpServletResponse)this._desktop.getAttribute("org.zkoss.zkmax.ui.websocket.handshakeHttpServletResponse");
        if (response != null) {
            response = new ResponseWrapper((HttpServletResponse)response);
        }
        ExecutionImpl exec = new ExecutionImpl(this._request.getServletContext(), (HttpServletRequest)this._request, response, this._desktop, null);
        info.setActive((Execution)exec);
        Runtime.init((Object)this._desktop);
        this._active = info;
        ((WebAppCtrl)this._desktop.getWebApp()).getUiEngine().beginUpdate(this._active._exec);
        return true;
    }

    public boolean deactivate(boolean stop) {
        boolean stopped = false;
        if (this._active != null && Thread.currentThread().equals(this._active._thread) && --this._active._nActive <= 0) {
            Execution exec = this._active._exec;
            this._active._exec = null;
            this._active._nActive = 0;
            this._active = null;
            if (exec != null) {
                try {
                    ((WebAppCtrl)this._desktop.getWebApp()).getUiEngine().endUpdate(exec);
                }
                catch (Throwable ex) {
                    log.warn("Ignored error", ex);
                }
            }
            if (this._webSocketEndpoint == null) {
                log.warn("Websocket connection is closed");
            } else {
                try {
                    this._webSocketEndpoint.sendText("$ZKWS_ECHO$");
                }
                catch (IOException e) {
                    log.warn("Message not sent: ", (Throwable)e);
                }
            }
            if (stop) {
                this._desktop = null;
                this.wakePending();
                stopped = true;
            }
        }
        return stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void wakePending() {
        List<ThreadInfo> list = this._pending;
        synchronized (list) {
            for (ThreadInfo info : this._pending) {
                Object object = info.lock;
                synchronized (object) {
                    if (info._nActive == -99) {
                        continue;
                    }
                    info.lock.notify();
                }
            }
            this._pending.clear();
        }
    }

    public void onPiggyback() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkConnectionReady(ThreadInfo info, long timeout) throws InterruptedException {
        boolean loop;
        boolean connection = this._webSocketEndpoint == null;
        do {
            loop = false;
            boolean bTimeout = false;
            boolean bDead = false;
            boolean interrupted = false;
            try {
                List<ThreadInfo> list = info.lock;
                synchronized (list) {
                    if (connection ? this._webSocketEndpoint == null : info._nActive == 0) {
                        info.lock.wait(timeout <= 0L ? 600000L : timeout);
                    }
                    if (connection ? this._webSocketEndpoint == null : info._nActive == 0) {
                        bTimeout = timeout > 0L;
                        boolean bl = bDead = this._desktop == null || !this._desktop.isAlive();
                        if (bTimeout || bDead) {
                            info._nActive = -99;
                            if (bDead) {
                                throw new DesktopUnavailableException("Stopped");
                            }
                            boolean bl2 = false;
                            return bl2;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Executions.activate() took more than 10 minutes");
                        }
                        loop = true;
                    }
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
                throw e;
            }
            finally {
                if (bTimeout || bDead || interrupted) {
                    List<ThreadInfo> list = this._pending;
                    synchronized (list) {
                        this._pending.remove(info);
                    }
                }
            }
        } while (loop);
        return true;
    }

    private static class ThreadInfo {
        private final Object lock = new Object();
        private Thread _thread;
        private int _nActive;
        private Execution _exec;

        private ThreadInfo(Thread thread) {
            this._thread = thread;
        }

        private void setActive(Execution exec) {
            this._nActive = 1;
            this._exec = exec;
        }

        public String toString() {
            return "[" + String.valueOf(this._thread) + "," + this._nActive + "]";
        }
    }
}

