/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.Organigram;
import org.zkoss.zkmax.zul.Orgchildren;
import org.zkoss.zkmax.zul.Orgnode;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.ext.TreeOpenableModel;
import org.zkoss.zul.impl.XulElement;

public class Orgitem
extends XulElement
implements Disable {
    private Orgnode _orgnode;
    private Orgchildren _orgchildren;
    private Object _value;
    private boolean _disabled;
    private boolean _open = true;
    private boolean _selectable = true;
    private boolean _selected;
    private boolean _loaded;
    private boolean _rendered;

    public Orgitem() {
    }

    public Orgitem(String label) {
        this.setLabel(label);
    }

    public Orgitem(String label, Object value) {
        this.setLabel(label);
        this.setValue(value);
    }

    public boolean isSelectable() {
        return this._selectable;
    }

    public void setSelectable(boolean selectable) {
        if (this._selectable != selectable) {
            this._selectable = selectable;
            if (!this._selectable) {
                this.setSelected(false);
            }
            this.smartUpdate("selectable", selectable);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", disabled);
        }
    }

    public boolean isRendered() {
        return this._rendered;
    }

    void setRendered(boolean rendered) {
        if (this._rendered != rendered) {
            this._rendered = rendered;
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    void setLoaded(boolean loaded) {
        if (this._loaded != loaded) {
            this._loaded = loaded;
            this.smartUpdate("loaded", this._loaded);
        }
    }

    public int getIndex() {
        List list = this.getParent().getChildren();
        return list.indexOf((Object)this);
    }

    public Orgchildren getOrgchildren() {
        return this._orgchildren;
    }

    public Orgnode getOrgnode() {
        return this._orgnode;
    }

    public boolean isContainer() {
        return this._orgchildren != null;
    }

    public boolean isEmpty() {
        return this._orgchildren == null || this._orgchildren.getChildren().isEmpty();
    }

    public int getLevel() {
        Component orgchildren;
        int level = 0;
        Orgitem item = this;
        while ((orgchildren = item.getParent()) != null && (item = orgchildren.getParent()) != null && !(item instanceof Organigram)) {
            ++level;
        }
        return level;
    }

    public <T> T getValue() {
        return (T)this._value;
    }

    public <T> void setValue(T value) {
        this._value = value;
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            Organigram organigram;
            this._open = open;
            this.smartUpdate("open", this._open);
            if (this._orgchildren != null) {
                this.addVisibleItemCount((this._open ? 1 : -1) * this._orgchildren.getVisibleItemCount());
            }
            if ((organigram = this.getOrganigram()) != null && organigram.getModel() != null && this._open && !this.isLoaded()) {
                organigram.renderItem(this);
            }
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Organigram organigram = this.getOrganigram();
            if (organigram != null) {
                organigram.toggleItemSelection(this);
            } else {
                this._selected = selected;
            }
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public String getLabel() {
        return this._orgnode != null ? this._orgnode.getLabel() : null;
    }

    public void setLabel(String label) {
        this.autoOrgnode().setLabel(label);
    }

    private Orgnode autoOrgnode() {
        if (this._orgnode == null) {
            Orgnode orgnode = new Orgnode();
            orgnode.applyProperties();
            if (this.getOrgchildren() != null) {
                this.insertBefore((Component)orgnode, (Component)this._orgchildren);
            } else {
                orgnode.setParent((Component)this);
            }
        }
        return this._orgnode;
    }

    public String getImage() {
        return this._orgnode != null ? this._orgnode.getImage() : null;
    }

    public void setImage(String image) {
        this.autoOrgnode().setImage(image);
    }

    public Organigram getOrganigram() {
        Orgitem p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Organigram)) continue;
            return (Organigram)((Object)p);
        }
        return null;
    }

    public Orgitem getParentItem() {
        Component parent = this.getParent();
        Component grandParent = parent != null ? parent.getParent() : null;
        return grandParent instanceof Orgitem ? (Orgitem)grandParent : null;
    }

    public boolean setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            int count;
            this.smartUpdate("visible", visible);
            int n = count = this.isOpen() && this._orgchildren != null ? this._orgchildren.getVisibleItemCount() + 1 : 1;
            if (visible) {
                boolean result = super.setVisible(visible);
                this.addVisibleItemCount(count);
                return result;
            }
            this.addVisibleItemCount(-count);
            return super.setVisible(visible);
        }
        return visible;
    }

    public int getVisibleItemCount() {
        return this.isVisible() ? 1 + (this._open && this._orgchildren != null ? this._orgchildren.getVisibleItemCount() : 0) : 0;
    }

    void addVisibleItemCount(int count) {
        Orgchildren orgchildren = (Orgchildren)this.getParent();
        if (orgchildren != null && this.isVisible()) {
            orgchildren.addVisibleItemCount(count);
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Orgchildren)) {
            throw new UiException("Wrong parent: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    public void setParent(Component parent) {
        Organigram organigram;
        Component oldp = this.getParent();
        if (oldp == parent) {
            return;
        }
        Organigram oldOrganigram = oldp != null ? this.getOrganigram() : null;
        super.setParent(parent);
        if (oldOrganigram != null) {
            oldOrganigram.onOrgitemRemoved(this);
        }
        if (parent != null && (organigram = this.getOrganigram()) != null) {
            organigram.onOrgitemAdded(this);
        }
    }

    public void beforeChildAdded(Component child, Component insertBefore) {
        if (child instanceof Orgnode) {
            if (this._orgnode != null && this._orgnode != child) {
                throw new UiException("Only one orgnode is allowed: " + String.valueOf((Object)this));
            }
        } else if (child instanceof Orgchildren) {
            if (this._orgchildren != null && this._orgchildren != child) {
                throw new UiException("Only one orgchildren is allowed: " + String.valueOf((Object)this));
            }
        } else {
            throw new UiException("Unsupported child for Orgitem: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, insertBefore);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Orgnode) {
            if (super.insertBefore(newChild, refChild)) {
                this._orgnode = (Orgnode)newChild;
                return true;
            }
        } else if (newChild instanceof Orgchildren) {
            if (super.insertBefore(newChild, refChild)) {
                this._orgchildren = (Orgchildren)newChild;
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        if (this._orgchildren == child) {
            this.addVisibleItemCount(this._orgchildren.getVisibleItemCount());
        }
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Orgnode) {
            this._orgnode = null;
        } else if (child instanceof Orgchildren) {
            if (this.isOpen()) {
                this.addVisibleItemCount(-this._orgchildren.getVisibleItemCount());
            }
            this._orgchildren = null;
        }
        super.onChildRemoved(child);
    }

    public Object clone() {
        Orgitem clone = (Orgitem)((Object)super.clone());
        int cnt = 0;
        if (clone._orgnode != null) {
            ++cnt;
        }
        if (clone._orgchildren != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        for (Component child : this.getChildren()) {
            if (child instanceof Orgnode) {
                this._orgnode = (Orgnode)child;
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Orgchildren)) continue;
            this._orgchildren = (Orgchildren)child;
            if (--cnt != 0) continue;
            break;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal(-1);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        this.render(renderer, "selected", this.isSelected());
        this.render(renderer, "disabled", this.isDisabled());
        this.render(renderer, "loaded", this.isLoaded());
        if (!this.isOpen()) {
            renderer.render("open", false);
        }
        if (!this.isSelectable()) {
            renderer.render("selectable", false);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String command = request.getCommand();
        if ("onOpen".equals(command)) {
            boolean open = (Boolean)request.getData().get("open");
            Organigram organigram = this.getOrganigram();
            boolean hasOpenableModel = false;
            if (organigram != null && organigram.getModel() != null) {
                TreeModel model;
                if (open && !this.isLoaded()) {
                    organigram.renderItem(this);
                    if (this._orgchildren != null && this._orgchildren.getChildren().size() >= 5) {
                        this.invalidate();
                    }
                }
                if ((model = organigram.getModel()) instanceof TreeOpenableModel) {
                    int[] itemPath = organigram.getOrgitemPath((Component)organigram, (Component)this);
                    hasOpenableModel = open ? ((TreeOpenableModel)model).addOpenPath(itemPath) : ((TreeOpenableModel)model).removeOpenPath(itemPath);
                }
            }
            if (!hasOpenableModel && this._orgchildren != null && super.isVisible()) {
                if (open) {
                    this.addVisibleItemCount(this._orgchildren.getVisibleItemCount());
                } else {
                    this.addVisibleItemCount(-this._orgchildren.getVisibleItemCount());
                }
            }
            this._open = open;
            Events.postEvent((Event)new OpenEvent("onOpen", (Component)this, open));
        } else {
            super.service(request, everError);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-orgitem" : this._zclass;
    }

    static {
        Orgitem.addClientEvent(Orgitem.class, (String)"onOpen", (int)1);
    }
}

