/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.LoadBinding;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.sys.tracker.TrackerNode;
import org.zkoss.bind.xel.zel.BindELContext;

class TrackerNodeImplEx
implements TrackerNode,
Serializable {
    private static final long serialVersionUID = 1463169907348730644L;
    private final Object _script;
    private Map<Object, Set<TrackerNode>> _dependents;
    private Map<Object, Set<TrackerNode>> _brackets;
    private Map<Object, Set<TrackerNode>> _methods;
    private Set<LoadBinding> _bindings;
    private Set<ReferenceBinding> _refBindings;
    private Set<TrackerNode> _associates;
    private transient WeakReference<Object> _bean;
    private TrackerNode _parentNode;
    private boolean _inTemplate;

    public TrackerNodeImplEx(Object property) {
        this._script = property;
    }

    public TrackerNodeImplEx(Object property, boolean inTemplate) {
        this._script = property;
        this._inTemplate = inTemplate;
    }

    public void addAssociate(TrackerNode node) {
        this._associates = AllocUtil.inst.addSet(this._associates, (Object)node);
    }

    public TrackerNode getDependent(Object property) {
        List<TrackerNode> kids = this.getDependent0(property);
        if (kids == null || kids.isEmpty()) {
            Set<TrackerNode> nodes;
            Set<TrackerNode> set = nodes = this._brackets == null ? null : this._brackets.get(property);
            if (nodes != null && !nodes.isEmpty()) {
                kids = this.getDependent0(nodes.iterator().next());
            }
        }
        return kids != null ? kids.get(0) : null;
    }

    public Set<TrackerNode> getDependents(Object property) {
        String prop;
        Set<TrackerNode> nodes;
        LinkedHashSet<TrackerNode> set = new LinkedHashSet<TrackerNode>(5);
        List<TrackerNode> kid = this.getDependent0(property);
        if (kid != null) {
            set.addAll(kid);
        }
        Set<TrackerNode> set2 = nodes = this._brackets == null ? null : this._brackets.get(property);
        if (nodes == null && this._brackets != null && property instanceof String && BindELContext.isBracket((String)(prop = (String)property))) {
            nodes = this._brackets.get(prop.substring(1, prop.length() - 1));
        }
        if (nodes != null && !nodes.isEmpty()) {
            set.addAll(nodes);
        }
        return set;
    }

    public Set<TrackerNode> getDependents() {
        return this.collectDependents0(new HashSet<TrackerNode>());
    }

    private List<TrackerNode> getDependent0(Object script) {
        if (this._dependents != null) {
            Set<TrackerNode> set = this._dependents.get(script);
            if (set != null) {
                return new LinkedList<TrackerNode>(set);
            }
            Set<TrackerNode> set2 = set = this._methods != null ? this._methods.get(script) : null;
            if (set != null) {
                return new LinkedList<TrackerNode>(set);
            }
        }
        return null;
    }

    public void addDependent(Object script, TrackerNode dependent) {
        if (this._dependents == null || !this._dependents.containsKey(script)) {
            LinkedHashSet<TrackerNode> set = new LinkedHashSet<TrackerNode>();
            set.add(dependent);
            this._dependents = AllocUtil.inst.putLinkedHashMap(this._dependents, script, set);
        } else {
            this._dependents.get(script).add(dependent);
        }
        if (this.isMethod(script)) {
            String methodName = this.getMethodName((String)script);
            if (this._methods == null || !this._methods.containsKey(methodName)) {
                LinkedHashSet<TrackerNode> set = new LinkedHashSet<TrackerNode>();
                set.add(dependent);
                this._methods = AllocUtil.inst.putLinkedHashMap(this._methods, (Object)methodName, set);
            } else {
                this._methods.get(methodName).add(dependent);
            }
        }
    }

    private boolean isMethod(Object script) {
        if (script instanceof String) {
            String string = (String)script;
            int leftIndex = string.indexOf("(");
            return leftIndex > 0 && leftIndex < string.indexOf(")");
        }
        return false;
    }

    private String getMethodName(String string) {
        return string.substring(0, string.indexOf("("));
    }

    public void tieProperty(Object property, TrackerNode trackerNode) {
        if (this._brackets == null) {
            if (property != null) {
                LinkedHashSet<TrackerNode> set = new LinkedHashSet<TrackerNode>();
                set.add(trackerNode);
                this._brackets = AllocUtil.inst.putLinkedHashMap(this._brackets, property, set);
            }
        } else if (property != null) {
            Set<TrackerNode> set = this._brackets.get(property);
            if (set == null) {
                set = new LinkedHashSet<TrackerNode>();
                this._brackets = AllocUtil.inst.putLinkedHashMap(this._brackets, property, set);
            }
            set.add(trackerNode);
        }
    }

    public TrackerNode removeDependent(Object script) {
        return null;
    }

    public TrackerNode removeDependent(Object script, TrackerNode dependent) {
        if (this._dependents != null) {
            String methodName;
            Set<TrackerNode> methodNodes;
            Set<TrackerNode> nodes = this._dependents.get(script);
            if (this.isMethod(script) && this._methods != null && (methodNodes = this._methods.get(methodName = this.getMethodName((String)script))) != null && methodNodes.remove(dependent) && methodNodes.size() == 0) {
                this._methods.remove(methodName);
            }
            if (nodes != null && nodes.remove(dependent)) {
                if (nodes.size() == 0) {
                    this._dependents.remove(script);
                }
                return dependent;
            }
        }
        return null;
    }

    public void addBinding(Binding binding) {
        if (binding instanceof ReferenceBinding) {
            this._refBindings = AllocUtil.inst.addLinkedHashSet(this._refBindings, (Object)((ReferenceBinding)binding));
        } else {
            this._bindings = AllocUtil.inst.addLinkedHashSet(this._bindings, (Object)((LoadBinding)binding));
        }
    }

    public Set<Binding> getBindings() {
        HashSet<Binding> bindings = new HashSet<Binding>();
        bindings.addAll(this.getLoadBindings());
        bindings.addAll(this.getReferenceBindings());
        return bindings;
    }

    public Set<ReferenceBinding> getReferenceBindings() {
        return this._refBindings == null ? Collections.EMPTY_SET : this._refBindings;
    }

    public Set<LoadBinding> getLoadBindings() {
        return this._bindings == null ? Collections.EMPTY_SET : this._bindings;
    }

    private Set<TrackerNode> collectDependents0(Set<TrackerNode> nodes) {
        Set<TrackerNode> kids = this.getDirectDependents();
        nodes.addAll(kids);
        for (TrackerNode kid : kids) {
            ((TrackerNodeImplEx)kid).collectDependents0(nodes);
        }
        if (this._associates != null) {
            for (TrackerNode associate : this._associates) {
                if (nodes.contains(associate)) continue;
                nodes.add(associate);
                ((TrackerNodeImplEx)associate).collectDependents0(nodes);
            }
        }
        return nodes;
    }

    public Set<TrackerNode> getDirectDependents() {
        if (this._dependents == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<TrackerNode> set = new HashSet<TrackerNode>();
        for (Set<TrackerNode> value : this._dependents.values()) {
            set.addAll(value);
        }
        return set;
    }

    public Set<TrackerNode> getAssociates() {
        return this._associates == null ? Collections.EMPTY_SET : this._associates;
    }

    public Object getBean() {
        Object bean;
        Object v0 = bean = this._bean == null ? null : this._bean.get();
        if (bean == null && this._bean != null) {
            this.setBean(null);
        }
        return bean;
    }

    public void setBean(Object bean) {
        this._bean = bean == null ? null : new WeakReference<Object>(bean);
    }

    public Object getFieldScript() {
        return this._script;
    }

    public Map<Object, ?> getPropNameMapping() {
        return this._brackets == null ? Collections.emptyMap() : this._brackets;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[bean:").append(this.getBean()).append(",script:").append(this._script).append("]@").append(System.identityHashCode(this));
        return sb.toString();
    }

    public TrackerNode getParentNode() {
        return this._parentNode;
    }

    public void setParentNode(TrackerNode parentNode) {
        this._parentNode = parentNode;
    }

    public boolean isInTemplate() {
        return this._inTemplate;
    }

    public boolean isPropNameNodeMapped(TrackerNode trackerNode) {
        if (this._brackets != null) {
            for (Set<TrackerNode> trackerNodes : this._brackets.values()) {
                if (!trackerNodes.contains(trackerNode)) continue;
                return true;
            }
        }
        return false;
    }
}

