/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.Step;
import org.zkoss.zkmax.zul.StepModel;
import org.zkoss.zkmax.zul.StepRenderer;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Stepbar
extends XulElement {
    private static final Logger log = LoggerFactory.getLogger(Stepbar.class);
    private Boolean SELECTIVE_COMPONENT_UPDATE = null;
    private boolean _ignoreDataSelectionEvent;
    private boolean _wrappedLabels;
    private boolean _linear = true;
    private int _activeIndex;
    private StepModel<?> _model;
    private ListDataListener _listener;
    private StepRenderer<?> _stepRenderer;
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.onInitLaterPosted";
    private String _orient = "horizontal";
    private static final StepRenderer _defaultRenderer;

    public boolean isWrappedLabels() {
        return this._wrappedLabels;
    }

    public void setWrappedLabels(boolean wrappedLabels) {
        if (this._wrappedLabels != wrappedLabels) {
            this._wrappedLabels = wrappedLabels;
            this.smartUpdate("wrappedLabels", this._wrappedLabels);
        }
    }

    public boolean isLinear() {
        return this._linear;
    }

    public void setLinear(boolean linear) {
        if (this._linear != linear) {
            this._linear = linear;
            this.smartUpdate("linear", this._linear);
            if (this._linear) {
                this.updateCompleteStatus();
            }
        }
    }

    public int getActiveIndex() {
        if (this._model != null) {
            return this._model.getActiveIndex();
        }
        return this._activeIndex;
    }

    public void setActiveIndex(int activeIndex) {
        if (!this.isInitialized()) {
            this._activeIndex = activeIndex;
            return;
        }
        int size = this.getSteps().size();
        if (activeIndex < 0 || activeIndex >= size) {
            throw new UiException("Out of bound: " + activeIndex + " while size=" + size);
        }
        if (this._model != null) {
            this._model.setActiveIndex(activeIndex);
            return;
        }
        if (this._activeIndex != activeIndex) {
            this.updateActiveIndex(activeIndex);
            this.updateCompleteStatus();
        }
    }

    private void updateCompleteStatus() {
        if (!this._linear) {
            return;
        }
        int activeIndex = this._model != null ? this._model.getActiveIndex() : this._activeIndex;
        List<Step> steps = this.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            Step step = steps.get(i);
            if (this.isInitialized()) {
                step.setComplete(i < activeIndex);
                continue;
            }
            step.setCompleteDirectly(i < activeIndex);
        }
    }

    private void updateActiveIndex(int activeIndex) {
        this._activeIndex = activeIndex;
        if (this.isInitialized()) {
            this.smartUpdate("activeIndex", this._activeIndex);
            Events.postEvent((Event)new Event("onChange", (Component)this, (Object)activeIndex));
        }
    }

    public Step getActiveStep() {
        return this.getSteps().get(this.getActiveIndex());
    }

    public void setActiveStep(Step step) {
        if (step.getStepbar() != this) {
            throw new UiException("Not a child: " + String.valueOf((Object)step));
        }
        this.setActiveIndex(this.getSteps().indexOf((Object)step));
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals(orient, this._orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public StepRenderer getStepRenderer() {
        return this._stepRenderer;
    }

    public void setStepRenderer(StepRenderer stepRenderer) {
        if (this._stepRenderer != stepRenderer) {
            this._stepRenderer = stepRenderer;
            if (this._model != null) {
                this.postOnInitRender();
            }
        }
    }

    private Selectable<Object> getSelectableModel() {
        return (Selectable)this._model.getSteps();
    }

    public StepModel<?> getModel() {
        return this._model;
    }

    public void setModel(StepModel<?> model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.getSteps().removeListDataListener(this._listener);
                }
                this._model = model;
                this.initDataListener();
            }
            this.postOnInitRender();
        } else if (this._model != null) {
            this._model.getSteps().removeListDataListener(this._listener);
            this._model = null;
            this.getSteps().clear();
        }
    }

    private void initDataListener() {
        if (this._listener == null) {
            this._listener = event -> {
                if (this.SELECTIVE_COMPONENT_UPDATE == null) {
                    this.SELECTIVE_COMPONENT_UPDATE = Utils.testAttribute((Component)this, (String)"org.zkoss.zul.model.selectiveComponentUpdate.enable", (boolean)false, (boolean)true);
                }
                int newsz = this._model.getSteps().getSize();
                int oldsz = this.getSteps().size();
                int min = event.getIndex0();
                int max = event.getIndex1();
                boolean oldIDSE = this._ignoreDataSelectionEvent;
                switch (event.getType()) {
                    case 1: {
                        int cnt = newsz - oldsz;
                        if (cnt < 0) {
                            throw new UiException("Adding causes a smaller list?");
                        }
                        if (cnt == 0) {
                            return;
                        }
                        if (min < 0) {
                            min = max < 0 ? 0 : max - cnt + 1;
                        }
                        if (min > oldsz) {
                            min = oldsz;
                        }
                        StepRenderer renderer = this.getRealRenderer();
                        Component next = min < oldsz ? (Component)this.getSteps().get(min) : null;
                        try {
                            ArrayList<Step> steps;
                            int index = min;
                            while (--cnt >= 0) {
                                Step step = new Step();
                                step.applyProperties();
                                this.insertBefore((Component)step, next);
                                renderer.render(step, this._model.getSteps().getElementAt(index), index++);
                            }
                            if (!this.SELECTIVE_COMPONENT_UPDATE.booleanValue() && max < (steps = new ArrayList<Step>(this.getSteps())).size()) {
                                Iterator iterator = steps.iterator();
                                int start = 0;
                                int i = max + 1;
                                int j = steps.size();
                                while (i < j && iterator.hasNext()) {
                                    if (start < i) {
                                        iterator.next();
                                    } else {
                                        renderer.render((Step)((Object)((Object)iterator.next())), this._model.getSteps().getElementAt(i), i++);
                                    }
                                    ++start;
                                }
                            }
                            this._ignoreDataSelectionEvent = true;
                            if (min > this._activeIndex) break;
                            this.setActiveIndex(++this._activeIndex);
                            this.updateCompleteStatus();
                            this.updateActiveIndex(this._activeIndex);
                            break;
                        }
                        catch (Exception ex) {
                            log.error("", (Throwable)ex);
                            break;
                        }
                        finally {
                            this._ignoreDataSelectionEvent = oldIDSE;
                        }
                    }
                    case 2: {
                        int cnt = oldsz - newsz;
                        if (cnt < 0) {
                            throw new UiException("Removal causes a larger list?");
                        }
                        if (cnt == 0) {
                            return;
                        }
                        if (min >= 0) {
                            max = min + cnt - 1;
                        } else if (max < 0) {
                            max = cnt - 1;
                        }
                        if (max > oldsz - 1) {
                            max = oldsz - 1;
                        }
                        List<Step> steps = this.getSteps();
                        Component comp = (Component)steps.get(max);
                        while (--cnt >= 0) {
                            Component p = comp.getPreviousSibling();
                            comp.detach();
                            comp = p;
                        }
                        if (!this.SELECTIVE_COMPONENT_UPDATE.booleanValue()) {
                            StepRenderer renderer1 = this.getRealRenderer();
                            try {
                                steps = new ArrayList<Step>(this.getSteps());
                                if (max < steps.size()) {
                                    Iterator<Step> iterator = steps.iterator();
                                    int start = 0;
                                    int i = max;
                                    int j = steps.size();
                                    while (i < j && iterator.hasNext()) {
                                        if (start < i) {
                                            iterator.next();
                                        } else {
                                            renderer1.render(iterator.next(), this._model.getSteps().getElementAt(i), i++);
                                        }
                                        ++start;
                                    }
                                }
                            }
                            catch (Exception ex) {
                                log.error("", (Throwable)ex);
                            }
                        }
                        this._ignoreDataSelectionEvent = true;
                        try {
                            if (min > this._activeIndex) break;
                            this.setActiveIndex(--this._activeIndex);
                            this.updateCompleteStatus();
                            this.updateActiveIndex(this._activeIndex);
                            break;
                        }
                        finally {
                            this._ignoreDataSelectionEvent = oldIDSE;
                        }
                    }
                    case 4: {
                        if (oldIDSE) break;
                        this.updateActiveIndex(min);
                        this.updateCompleteStatus();
                    }
                }
            };
        }
        this._model.getSteps().addListDataListener(this._listener);
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        StepRenderer renderer = this.getRealRenderer();
        ListModel<?> steps = this._model.getSteps();
        try {
            this.getChildren().clear();
            for (int i = 0; i < steps.getSize(); ++i) {
                Selectable<Object> smodel;
                Step step = new Step();
                step.applyProperties();
                step.setParent((Component)this);
                Object data = steps.getElementAt(i);
                renderer.render(step, data, i);
                Object v = step.getAttribute("org.zkoss.zul.model.renderAs");
                if (v != null) {
                    step = (Step)((Object)v);
                }
                if ((smodel = this.getSelectableModel()) == null || !smodel.isSelected(data)) continue;
                this.setActiveStep(step);
            }
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (this._model != null && this._listener != null) {
            this._model.getSteps().removeListDataListener(this._listener);
            this._model.getSteps().addListDataListener(this._listener);
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this._model != null && this._listener != null) {
            this._model.getSteps().removeListDataListener(this._listener);
        }
    }

    private StepRenderer getRealRenderer() {
        return this._stepRenderer != null ? this._stepRenderer : _defaultRenderer;
    }

    public boolean next() {
        if (this._model != null) {
            this._model.next();
        } else {
            int nextIndex = this._activeIndex + 1;
            List<Step> steps = this.getSteps();
            if (nextIndex >= steps.size()) {
                return false;
            }
            this.setActiveIndex(nextIndex);
        }
        return true;
    }

    public boolean back() {
        if (this._model != null) {
            this._model.back();
        } else {
            int nextIndex = this._activeIndex - 1;
            if (nextIndex <= -1) {
                return false;
            }
            this.setActiveIndex(nextIndex);
        }
        return true;
    }

    public List<Step> getSteps() {
        return this.getChildren();
    }

    public void beforeChildAdded(Component child, Component insertBefore) {
        if (!(child instanceof Step)) {
            throw new UiException("Unsupported child for Stepbar: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, insertBefore);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        boolean result = super.insertBefore(newChild, refChild);
        if (this.isInitialized() && this._model == null && refChild != null && this.getSteps().indexOf(refChild) - 1 <= this._activeIndex) {
            this.setActiveIndex(this._activeIndex + 1);
        }
        return result;
    }

    public boolean removeChild(Component child) {
        int index = this.getChildren().indexOf(child);
        boolean result = super.removeChild(child);
        if (this.isInitialized() && this._model == null && result && index <= this._activeIndex && this._activeIndex == this.getSteps().size() && this._activeIndex != 0) {
            this.setActiveIndex(this._activeIndex - 1);
        }
        return result;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        this.render(renderer, "wrappedLabels", this._wrappedLabels);
        int size = this.getChildren().size();
        if (this._activeIndex < 0 || this._activeIndex >= size && (size != 0 || this._activeIndex != 0)) {
            throw new UiException("Out of bound: " + this._activeIndex + " while size=" + size);
        }
        if (this._activeIndex != 0) {
            this.render(renderer, "activeIndex", this._activeIndex);
        }
        if (!this._linear) {
            renderer.render("linear", false);
        } else {
            this.updateCompleteStatus();
        }
        if (!"horizontal".equals(this._orient)) {
            renderer.render("orient", this._orient);
        }
        super.renderProperties(renderer);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onChange".equals(cmd)) {
            int index = (Integer)request.getData().get("activeIndex");
            if (this._model != null) {
                this._model.setActiveIndex(index);
            } else {
                this._activeIndex = index;
            }
            Events.postEvent((Event)new Event(cmd, (Component)this));
        } else {
            super.service(request, everError);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-stepbar" : this._zclass;
    }

    static {
        Stepbar.addClientEvent(Stepbar.class, (String)"onChange", (int)16385);
        _defaultRenderer = (step, data, index) -> {
            Stepbar stepbar = step.getStepbar();
            Template template = stepbar.getTemplate("model");
            if (template == null) {
                step.setTitle(Objects.toString(data));
            } else {
                Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])template.create((Component)stepbar, (Component)step, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return data;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return this.getCurrent();
                                }

                                public int getIndex() {
                                    return index;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    throw new UnsupportedOperationException("end not available");
                                }

                                public Object getCurrent() {
                                    return data;
                                }

                                public boolean isFirst() {
                                    return this.getCount() == 1;
                                }

                                public boolean isLast() {
                                    return this.getIndex() + 1 == this.getEnd();
                                }

                                public Integer getStep() {
                                    return null;
                                }

                                public int getCount() {
                                    return this.getIndex() + 1;
                                }
                            };
                        }
                        return null;
                    }
                }, null));
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one item, not " + items.length);
                }
                Step newStep = (Step)items[0];
                step.setAttribute("org.zkoss.zul.model.renderAs", (Object)newStep);
                step.detach();
            }
        };
    }
}

