/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.ScrollEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.impl.XulElement;

public class Scrollview
extends XulElement {
    private String _orient = "vertical";

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        if (!"vertical".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onScroll") || cmd.equals("onScrolling")) {
            ScrollEvent evt = ScrollEvent.getScrollEvent((AuRequest)request);
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-scrollview";
    }

    static {
        Scrollview.addClientEvent(Scrollview.class, (String)"onScroll", (int)8192);
        Scrollview.addClientEvent(Scrollview.class, (String)"onScrolling", (int)8192);
    }
}

