/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.image.Images;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.impl.Utils;

public class Cropper
extends HtmlBasedComponent {
    private static final Logger log = LoggerFactory.getLogger(Cropper.class);
    private static String ON_CROP = "onCrop";
    private double _aspectRatio;
    private int _minWidth;
    private int _minHeight;
    private int _maxWidth;
    private int _maxHeight;
    private int _x;
    private int _y;
    private int _w;
    private int _h;
    private boolean _toolbarVisible = true;
    private boolean _instant;
    private String _croppedFormat = "image/png";
    private String _crossOrigin;
    private AImage _croppedImage;
    private String _src;
    private Image _image;
    private byte _imgver;

    public double getAspectRatio() {
        return this._aspectRatio;
    }

    public void setAspectRatio(double aspectRatio) {
        if (aspectRatio != this._aspectRatio) {
            if (aspectRatio < 0.0) {
                throw new WrongValueException("cannot be negative");
            }
            this._aspectRatio = aspectRatio;
            this.smartUpdate("aspectRatio", aspectRatio);
        }
    }

    public int getMinWidth() {
        return this._minWidth;
    }

    public void setMinWidth(int minWidth) {
        if (minWidth != this._minWidth) {
            if (minWidth < 0) {
                throw new WrongValueException("cannot be negative");
            }
            this._minWidth = minWidth;
            this.smartUpdate("minWidth", minWidth);
        }
    }

    public int getMinHeight() {
        return this._minHeight;
    }

    public void setMinHeight(int minHeight) {
        if (minHeight != this._minHeight) {
            if (minHeight < 0) {
                throw new WrongValueException("cannot be negative");
            }
            this._minHeight = minHeight;
            this.smartUpdate("minHeight", minHeight);
        }
    }

    public int getMaxWidth() {
        return this._maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        if (maxWidth != this._maxWidth) {
            if (maxWidth < 0) {
                throw new WrongValueException("cannot be negative");
            }
            this._maxWidth = maxWidth;
            this.smartUpdate("maxWidth", maxWidth);
        }
    }

    public int getMaxHeight() {
        return this._maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        if (maxHeight != this._maxHeight) {
            if (maxHeight < 0) {
                throw new WrongValueException("cannot be negative");
            }
            this._maxHeight = maxHeight;
            this.smartUpdate("maxHeight", maxHeight);
        }
    }

    public int getX() {
        return this._x;
    }

    public void setX(int x) {
        if (x != this._x) {
            if (x < 0) {
                throw new WrongValueException("cannot be negative");
            }
            this._x = x;
            this.smartUpdate("x", x);
        }
    }

    public int getY() {
        return this._y;
    }

    public void setY(int y) {
        if (y != this._y) {
            if (y < 0) {
                throw new WrongValueException("cannot be negative");
            }
            this._y = y;
            this.smartUpdate("y", y);
        }
    }

    public int getW() {
        return this._w;
    }

    public void setW(int w) {
        if (w != this._w) {
            if (w < 0) {
                throw new WrongValueException("cannot be negative");
            }
            this._w = w;
            this.smartUpdate("w", w);
        }
    }

    public int getH() {
        return this._h;
    }

    public void setH(int h) {
        if (h != this._h) {
            if (h < 0) {
                throw new WrongValueException("cannot be negative");
            }
            this._h = h;
            this.smartUpdate("h", h);
        }
    }

    public AImage getCroppedImage() {
        return this._croppedImage;
    }

    public boolean isToolbarVisible() {
        return this._toolbarVisible;
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        if (this._toolbarVisible != toolbarVisible) {
            this._toolbarVisible = toolbarVisible;
            this.smartUpdate("toolbarVisible", toolbarVisible);
        }
    }

    public String getCroppedFormat() {
        return this._croppedFormat;
    }

    public void setCroppedFormat(String croppedFormat) {
        if (croppedFormat != null && !croppedFormat.equalsIgnoreCase(this._croppedFormat)) {
            this._croppedFormat = croppedFormat;
            this.smartUpdate("_croppedFormat", this._croppedFormat);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._image != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._image = null;
            this.smartUpdate("src", new EncodedURL());
        }
    }

    public void setContent(Image image) {
        if (this._src != null || image != this._image) {
            this._image = image;
            this._src = null;
            if (this._image != null) {
                this._imgver = (byte)(this._imgver + 1);
            }
            this.smartUpdate("src", new EncodedURL());
        }
    }

    public void setContent(RenderedImage image) {
        try {
            this.setContent(image == null ? null : Images.encode((String)"a.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    public Image getContent() {
        return this._image;
    }

    public String getCrossOrigin() {
        return this._crossOrigin;
    }

    public void setCrossOrigin(String crossOrigin) {
        this._crossOrigin = "use-credentials".equalsIgnoreCase(crossOrigin) ? "use-credentials" : "anonymous";
        if (!this._crossOrigin.equals(crossOrigin)) {
            this._crossOrigin = crossOrigin;
            this.smartUpdate("crossOrigin", this._crossOrigin);
        }
    }

    public boolean isInstant() {
        return this._instant;
    }

    public void setInstant(boolean instant) {
        if (this._instant != instant) {
            this._instant = instant;
            this.smartUpdate("_instant", this._instant);
        }
    }

    public void resize(int deltaW, int deltaH) {
        if (deltaW != 0 && deltaH != 0) {
            this.resizeTo(this._w + deltaW, this._h + deltaH);
        }
    }

    public void resizeTo(int width, int height) {
        if (width < 0 || height < 0) {
            throw new WrongValueException("size cannot be negative");
        }
        this.setW(width);
        this.setH(height);
    }

    public void move(int deltaX, int deltaY) {
        if (deltaX != 0 && deltaY != 0) {
            this.moveTo(this._x + deltaX, this._y + deltaY);
        }
    }

    public void moveTo(int x, int y) {
        if (x < 0 || y < 0) {
            throw new WrongValueException("position cannot be negative");
        }
        this.setX(x);
        this.setY(y);
    }

    public void crop() {
        this.response((AuResponse)new AuInvoke((Component)this, "_crop"));
    }

    public void cancel() {
        this.disableClientUpdate(true);
        try {
            this.resizeTo(0, 0);
        }
        finally {
            this.disableClientUpdate(false);
        }
        this.response((AuResponse)new AuInvoke((Component)this, "_cancel"));
    }

    protected boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        Runtime.init((Object)((Object)this));
        if (this._aspectRatio != 0.0) {
            this.render(renderer, "aspectRatio", this._aspectRatio);
        }
        if (this._minWidth != 0) {
            this.render(renderer, "minWidth", this._minWidth);
        }
        if (this._minHeight != 0) {
            this.render(renderer, "minHeight", this._minHeight);
        }
        if (this._maxWidth != 0) {
            this.render(renderer, "maxWidth", this._maxWidth);
        }
        if (this._maxHeight != 0) {
            this.render(renderer, "maxHeight", this._maxHeight);
        }
        this.render(renderer, "x", this._x);
        this.render(renderer, "y", this._y);
        if (this._w != 0) {
            this.render(renderer, "w", this._w);
        }
        if (this._h != 0) {
            this.render(renderer, "h", this._h);
        }
        if (!this._toolbarVisible) {
            renderer.render("toolbarVisible", false);
        }
        if (this._instant) {
            renderer.render("_instant", true);
        }
        if (!"image/png".equalsIgnoreCase(this._croppedFormat)) {
            this.render(renderer, "_croppedFormat", this._croppedFormat);
        }
        this.render(renderer, "crossOrigin", this._crossOrigin);
        this.render(renderer, "src", this.getEncodedURL());
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        if ("onChange".equals(cmd) || "onChanging".equals(cmd) || "onCancel".equals(cmd)) {
            Integer x = (Integer)data.get("x");
            Integer y = (Integer)data.get("y");
            Integer w = (Integer)data.get("w");
            Integer h = (Integer)data.get("h");
            if (x != null) {
                this._x = x;
            }
            if (y != null) {
                this._y = y;
            }
            if (w != null) {
                this._w = w;
            }
            if (h != null) {
                this._h = h;
            }
            Events.postEvent((Event)Event.getEvent((AuRequest)request));
        } else if (ON_CROP.equals(cmd)) {
            UploadEvent evt = UploadEvent.getUploadEvent((String)cmd, (Component)this, (AuRequest)request);
            this._croppedImage = (AImage)evt.getMedia();
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    private String getEncodedURL() {
        if (this._image != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, (int)this._imgver, (String)("c/" + this._image.getName()), (String)this._image.getFormat());
        }
        if (this._src == null) {
            return "data:image/gif;base64,R0lGODlhAQABAIAAAP///////yH5BAUUAAEALAAAAAABAAEAAAICTAEAOw==";
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(this._src) : "";
    }

    static {
        Cropper.addClientEvent(Cropper.class, (String)"onChange", (int)16385);
        Cropper.addClientEvent(Cropper.class, (String)"onChanging", (int)16384);
        Cropper.addClientEvent(Cropper.class, (String)ON_CROP, (int)8193);
        Cropper.addClientEvent(Cropper.class, (String)"onCancel", (int)8193);
    }

    private class EncodedURL
    implements DeferredValue {
        private EncodedURL() {
        }

        public Object getValue() {
            return Cropper.this.getEncodedURL();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Cropper.this);
        }

        public Media getMedia(String pathInfo) {
            return Cropper.this._image;
        }
    }
}

