/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import org.zkoss.util.Converter;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.UiException;

public class JacksonConverter
implements Converter<Pair<Class<?>, Object>, Object> {
    private ObjectMapper jackson = new ObjectMapper();

    private JavaType getType(Type type) {
        return this.jackson.getTypeFactory().constructType(type, (Class)null);
    }

    public Object convert(Pair<Class<?>, Object> pair) {
        Class type = (Class)pair.getX();
        JavaType javaType = this.getType(type);
        Object attr = pair.getY();
        if (attr != null) {
            try {
                return this.jackson.readValue(attr.toString(), javaType);
            }
            catch (IOException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        return null;
    }
}

