/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.util.CollectionsX;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.ext.Blockable;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.ext.Readonly;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class InaccessibleWidgetBlockService
implements AuService,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(InaccessibleWidgetBlockService.class);
    private static AuService _svc;
    private static Set<String> _evts;

    public boolean service(AuRequest request, boolean everError) {
        return request.getComponent() != null && InaccessibleWidgetBlockService.shallBlockEvent(request) && InaccessibleWidgetBlockService.shallBlockPerComponent(request);
    }

    public static boolean isDisable() {
        return Boolean.parseBoolean(Library.getProperty((String)"org.zkoss.zkmax.au.IWBS.disable", (String)"false"));
    }

    private static boolean shallBlockEvent(AuRequest request) {
        if (_evts == null) {
            String s = Library.getProperty((String)"org.zkoss.zkmax.au.IWBS.events");
            if (s == null) {
                _evts = Collections.emptySet();
            } else {
                _evts = new HashSet<String>();
                _evts.addAll(CollectionsX.parse(null, (String)s, (char)','));
            }
        }
        return _evts == Collections.emptySet() || _evts.contains(request.getCommand());
    }

    protected static boolean shallBlockPerComponent(AuRequest request) {
        Component comp = request.getComponent();
        String cmd = request.getCommand();
        Object extCtrl = ((ComponentCtrl)comp).getExtraCtrl();
        if (extCtrl instanceof Blockable) {
            return ((Blockable)extCtrl).shallBlock(request);
        }
        if ("onOpen".equals(cmd)) {
            return false;
        }
        if (!Components.isRealVisible((Component)comp)) {
            return true;
        }
        if (comp instanceof Disable && ((Disable)comp).isDisabled()) {
            return true;
        }
        return comp instanceof Readonly && ((Readonly)comp).isReadonly() && ("onChange".equals(cmd) || "onChanging".equals(cmd) || "onSelect".equals(cmd));
    }

    public static class DesktopInit
    implements org.zkoss.zk.ui.util.DesktopInit {
        public void init(Desktop desktop, Object request) {
            if (InaccessibleWidgetBlockService.isDisable()) {
                return;
            }
            if (_svc == null) {
                _svc = new InaccessibleWidgetBlockService();
                logger.info("InaccessibleWidgetBlockService created");
            }
            desktop.addListener((Object)_svc);
            if (desktop.getWebApp().getAttribute("IWBSActivate") == null) {
                logger.info("InaccessibleWidgetBlockService activated");
                desktop.getWebApp().setAttribute("IWBSActivate", (Object)true);
            }
        }
    }
}

