/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.Navbar;
import org.zkoss.zkmax.zul.Navitem;
import org.zkoss.zkmax.zul.Navseparator;
import org.zkoss.zul.impl.LabelImageElement;

public class Nav
extends LabelImageElement {
    private boolean _open = false;
    private String _badgeText = null;

    public Nav() {
    }

    public Nav(String label) {
        super(label);
    }

    public String getBadgeText() {
        return this._badgeText;
    }

    public void setBadgeText(String badgeText) {
        if (!Objects.equals((Object)this._badgeText, (Object)badgeText)) {
            this._badgeText = badgeText;
            this.smartUpdate("badgeText", this._badgeText);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean opened) {
        if (this._open != opened) {
            this._open = opened;
            this.smartUpdate("open", this._open);
        }
    }

    public Navbar getNavbar() {
        Component q;
        Nav p = this;
        while ((q = p.getParent()) != null) {
            if (q instanceof Navbar) {
                return (Navbar)q;
            }
            p = q;
        }
        return null;
    }

    public String getZclass() {
        return this._zclass == null ? "z-nav" : this._zclass;
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Nav) && !(parent instanceof Navbar)) {
            throw new UiException("Unsupported parent for nav: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Nav || child instanceof Navitem || child instanceof Navseparator)) {
            throw new UiException("Unsupported child for nav: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, refChild);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        if (this._badgeText != null) {
            this.render(renderer, "badgeText", this._badgeText);
        }
        if (this.isOpen()) {
            renderer.render("open", true);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Nav.addClientEvent(Nav.class, (String)"onOpen", (int)1);
    }
}

