/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.zkoss.zul.AbstractTreeModel;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.TristateModel;

public class DefaultTristateTreeModel<E>
extends DefaultTreeModel<E>
implements TristateModel<E> {
    protected Set<Path> _partial = new LinkedHashSet<Path>();
    private boolean ignoreNestedCall = false;

    public DefaultTristateTreeModel(TreeNode<E> root) {
        this(root, false);
    }

    public DefaultTristateTreeModel(TreeNode<E> root, boolean emptyChildAsLeaf) {
        super(root, emptyChildAsLeaf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireSelectionChanged(int[] path) {
        if (!this.ignoreNestedCall) {
            boolean isSelected = this.isPathSelected(path);
            TreeNode item = (TreeNode)this.getChild(path);
            this.ignoreNestedCall = true;
            try {
                this.updateDescendantsNodesTristate(item, isSelected);
                this.updateAncestorsNodesTristate(item.getParent());
            }
            finally {
                this.ignoreNestedCall = false;
            }
        }
        super.fireSelectionChanged(path);
    }

    protected void fireTristateSelectionChanged(int[] path) {
        TreeDataEvent evt = new TreeDataEvent((TreeModel)this, 8, path, 0, 1);
        for (TreeDataListener l : this.getTreeDataListeners()) {
            l.onChange(evt);
        }
    }

    private void updateDescendantsNodesTristate(TreeNode<?> node, boolean isSelected) {
        LinkedList q = new LinkedList();
        q.offer(node);
        while (!q.isEmpty()) {
            TreeNode cur = (TreeNode)q.remove();
            if (isSelected) {
                this.addToSelection(cur);
            } else {
                this.removeFromSelection(cur);
            }
            this.removeFromPartial(cur);
            List children = cur.getChildren();
            if (children == null || children.isEmpty()) continue;
            q.addAll(children);
        }
    }

    private void updateAncestorsNodesTristate(TreeNode node) {
        for (TreeNode cur = node; cur != null; cur = cur.getParent()) {
            TristateModel.State curState;
            TristateModel.State preState = this.isSelected(cur) ? TristateModel.State.SELECTED : (this.isPartial(cur) ? TristateModel.State.PARTIAL : TristateModel.State.UNSELECTED);
            int selectedChild = 0;
            int partialChild = 0;
            int numberOfChild = 0;
            List children = cur.getChildren();
            if (children != null && !children.isEmpty()) {
                for (Object child : children) {
                    if (this.isSelected(child)) {
                        ++selectedChild;
                    }
                    if (this.isPartial(child)) {
                        ++partialChild;
                    }
                    ++numberOfChild;
                }
            }
            TristateModel.State state = numberOfChild == selectedChild ? TristateModel.State.SELECTED : (curState = selectedChild + partialChild == 0 ? TristateModel.State.UNSELECTED : TristateModel.State.PARTIAL);
            if (preState == curState) continue;
            if (TristateModel.State.PARTIAL == preState) {
                this.removeFromPartial(cur);
                if (TristateModel.State.SELECTED != curState) continue;
                this.addToSelection(cur);
                continue;
            }
            if (TristateModel.State.SELECTED == preState) {
                this.removeFromSelection(cur);
                if (TristateModel.State.PARTIAL != curState) continue;
                this.addToPartial(cur);
                continue;
            }
            if (TristateModel.State.SELECTED == curState) {
                this.addToSelection(cur);
                continue;
            }
            this.addToPartial(cur);
        }
    }

    public Object clone() {
        DefaultTristateTreeModel clone = (DefaultTristateTreeModel)((Object)super.clone());
        clone._partial = new LinkedHashSet<Path>(this._partial);
        return clone;
    }

    public void setMultiple(boolean multiple) {
        if (!multiple) {
            throw new IllegalArgumentException("Tristate tree model must be multiple selection");
        }
        super.setMultiple(multiple);
    }

    public boolean addPartialPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.addPartialPaths(paths);
        }
        return false;
    }

    public boolean addPartialPaths(int[][] paths) {
        boolean added = false;
        int len = paths != null ? paths.length : 0;
        for (int j = 0; j < len; ++j) {
            Path path;
            if (paths[j] == null || !this._partial.add(path = new Path(paths[j]))) continue;
            added = true;
            this.fireTristateSelectionChanged(path.path);
        }
        return added;
    }

    public boolean removePartialPath(int[] path) {
        if (path != null && path.length > 0) {
            int[][] paths = new int[1][path.length];
            paths[0] = path;
            return this.removePartialPaths(paths);
        }
        return false;
    }

    public boolean removePartialPaths(int[][] paths) {
        boolean found = false;
        int len = paths != null ? paths.length : 0;
        for (int j = 0; j < len && !this._partial.isEmpty(); ++j) {
            Path path = new Path(paths[j]);
            if (!this._partial.remove((Object)path)) continue;
            found = true;
            this.fireTristateSelectionChanged(path.path);
        }
        return found;
    }

    public boolean isPathPartial(int[] path) {
        return path != null && this._partial.contains((Object)new Path(path));
    }

    public int[] getPartialPath() {
        return this._partial.isEmpty() ? new int[]{} : this._partial.iterator().next().path;
    }

    public int[][] getPartialPaths() {
        if (this._partial.isEmpty()) {
            return new int[0][0];
        }
        int[][] paths = new int[this._partial.size()][];
        int j = 0;
        for (Path path : this._partial) {
            paths[j++] = path.path;
        }
        return paths;
    }

    public void clearPartial() {
        int[][] paths;
        if (!this._partial.isEmpty() && (paths = this.getPartialPaths()) != null) {
            this._partial.clear();
            for (int j = 0; j < paths.length; ++j) {
                this.fireSelectionChanged(paths[j]);
            }
        }
    }

    public Set<E> getPartials() {
        return Arrays.stream(this.getPartialPaths()).map(p -> this.getChild((int[])p)).collect(Collectors.toSet());
    }

    private boolean isPartialChanged(Collection<? extends E> partial) {
        if (this._partial.size() != partial.size()) {
            return true;
        }
        for (E e : partial) {
            if (this._partial.contains(e)) continue;
            return true;
        }
        return false;
    }

    public boolean isPartial(Object child) {
        int[] path = this.getPath((TreeNode)child);
        if (path != null && path.length > 0) {
            return this.isPathPartial(path);
        }
        return false;
    }

    public boolean addToPartial(E child) {
        int[] path = this.getPath((TreeNode)child);
        if (path != null && path.length > 0) {
            return this.addPartialPath(path);
        }
        return false;
    }

    public boolean removeFromPartial(Object child) {
        int[] path = this.getPath((TreeNode)child);
        if (path != null && path.length > 0) {
            return this.removePartialPath(path);
        }
        return false;
    }

    protected class Path
    extends AbstractTreeModel.Path {
        protected Path(int[] path) {
            super(path);
        }

        protected Path(AbstractTreeModel.Path p) {
            super(p);
        }
    }
}

