/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.tracker.Tracker;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.bind.xel.zel.BindExpressionBuilder;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ValueExpression;
import org.zkoss.zel.impl.parser.AstBracketSuffix;
import org.zkoss.zel.impl.parser.AstDotSuffix;
import org.zkoss.zel.impl.parser.AstIdentifier;
import org.zkoss.zel.impl.parser.AstMethodParameters;
import org.zkoss.zel.impl.parser.AstValue;
import org.zkoss.zel.impl.parser.Node;
import org.zkoss.zel.impl.parser.SimpleNode;
import org.zkoss.zkmax.bind.impl.TrackerImplEx;
import org.zkoss.zkmax.bind.impl.ValueExpressionImplEx;

public class BindExpressionBuilderEx
extends BindExpressionBuilder {
    private Node node;

    public BindExpressionBuilderEx(String expression, ELContext ctx) throws ELException {
        super(expression, ctx);
    }

    protected void visitNode(Node node) {
    }

    public Node getTargetNode() {
        return this.node;
    }

    private List<String> getFieldPath(Node node) {
        ArrayList<String> path = new ArrayList<String>(5);
        if (node instanceof AstValue) {
            int len = node.jjtGetNumChildren();
            for (int j = 0; j < len; ++j) {
                Node kid = node.jjtGetChild(j);
                if (kid instanceof AstMethodParameters) {
                    String result = BindELContext.toNodeString((Node)kid, (StringBuilder)new StringBuilder());
                    String prefix = (String)path.get(path.size() - 1);
                    path.set(path.size() - 1, prefix + result);
                    continue;
                }
                path.add(BindELContext.toNodeString((Node)kid, (StringBuilder)new StringBuilder()));
            }
        } else if (node instanceof AstIdentifier && !(node.jjtGetParent() instanceof AstValue)) {
            path.add(BindELContext.toNodeString((Node)node, (StringBuilder)new StringBuilder()));
        }
        return path;
    }

    public static String toNodeString(Node next, StringBuilder path) {
        if (next instanceof AstBracketSuffix) {
            String bracketString = BindExpressionBuilderEx.toNodeString(next.jjtGetChild(0), new StringBuilder());
            path.append("[").append(bracketString).append("]");
        } else if (next instanceof AstValue) {
            int len = next.jjtGetNumChildren();
            for (int j = 0; j < len; ++j) {
                Node kid = next.jjtGetChild(j);
                BindExpressionBuilderEx.toNodeString(kid, path);
            }
        } else if (next instanceof AstDotSuffix) {
            path.append(".").append(next.getImage());
        } else {
            path.append(next.getImage());
        }
        return path.toString();
    }

    public String getFieldNameIfAny() {
        if (this.node == null) {
            return null;
        }
        return this.getFieldName(this.getFieldPath(this.node));
    }

    public List<String> getFieldNamesIfAny() {
        if (this.node == null) {
            return Collections.EMPTY_LIST;
        }
        List<String> fieldPath = this.getFieldPath(this.node);
        LinkedList<List<String>> nestedFieldPaths = new LinkedList<List<String>>();
        if (!fieldPath.isEmpty()) {
            nestedFieldPaths.add(fieldPath);
        }
        if (this.node instanceof SimpleNode) {
            SimpleNode n = (SimpleNode)this.node;
            int n2 = n.jjtGetNumChildren();
            for (int i = 0; i < n2; ++i) {
                Node child = n.jjtGetChild(i);
                if (child == null) continue;
                this.getNestedFieldName(child, nestedFieldPaths);
            }
        }
        LinkedList<String> result = new LinkedList<String>();
        Collections.reverse(nestedFieldPaths);
        for (List list : nestedFieldPaths) {
            result.add(this.getFieldName(list));
        }
        return result;
    }

    private List<String> getNestedFieldName(Node node, List<List<String>> nestedFieldPaths) {
        ArrayList<String> path = new ArrayList<String>(5);
        if (node instanceof AstValue) {
            int len = node.jjtGetNumChildren();
            for (int j = 0; j < len; ++j) {
                Node kid = node.jjtGetChild(j);
                path.add(BindExpressionBuilderEx.toNodeString(kid, new StringBuilder()));
            }
        } else if (node instanceof AstIdentifier && !(node.jjtGetParent() instanceof AstValue)) {
            path.add(BindExpressionBuilderEx.toNodeString(node, new StringBuilder()));
        }
        if (!nestedFieldPaths.isEmpty()) {
            if (!path.isEmpty() && nestedFieldPaths.get(0).get(0).equals(path.get(0))) {
                nestedFieldPaths.add(path);
            }
        } else if (!path.isEmpty()) {
            nestedFieldPaths.add(path);
        }
        if (node instanceof SimpleNode) {
            SimpleNode n = (SimpleNode)node;
            int j = n.jjtGetNumChildren();
            for (int i = 0; i < j; ++i) {
                Node child = n.jjtGetChild(i);
                if (child == null) continue;
                this.getNestedFieldName(child, nestedFieldPaths);
            }
        }
        return path;
    }

    private String getFieldName(List<String> path) {
        if (path.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ListIterator<String> it = path.listIterator(1);
        while (it.hasNext()) {
            sb.append((String)it.next());
        }
        return sb.length() == 0 ? null : (sb.charAt(0) == '.' ? sb.substring(1) : sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTrackerNode(Node node, Object root) {
        Tracker tracker;
        Binding binding;
        if (node instanceof AstValue) {
            binding = this._ctx.getBinding();
            tracker = ((BinderCtrl)binding.getBinder()).getTracker();
            if (tracker instanceof TrackerImplEx) {
                try {
                    ((TrackerImplEx)tracker).setTargetValue(root);
                    this.addTracking(this.getFieldPath(node));
                }
                finally {
                    ((TrackerImplEx)tracker).setTargetValue(null);
                }
            } else {
                this.addTracking(this.getFieldPath(node));
            }
        } else if (node instanceof AstIdentifier && !(node.jjtGetParent() instanceof AstValue)) {
            binding = this._ctx.getBinding();
            tracker = ((BinderCtrl)binding.getBinder()).getTracker();
            if (tracker instanceof TrackerImplEx) {
                try {
                    ((TrackerImplEx)tracker).setTargetValue(root);
                    this.addTracking(this.getFieldPath(node));
                }
                finally {
                    ((TrackerImplEx)tracker).setTargetValue(null);
                }
            } else {
                this.addTracking(this.getFieldPath(node));
            }
        }
        if (node instanceof SimpleNode) {
            SimpleNode n = (SimpleNode)node;
            int j = n.jjtGetNumChildren();
            for (int i = 0; i < j; ++i) {
                Node child = n.jjtGetChild(i);
                if (child == null) continue;
                this.buildTrackerNode(child, null);
            }
        }
    }

    public void buildTrackerNode(Object root) {
        this.buildTrackerNode(this.node, root);
    }

    public ValueExpression createValueExpression(Class<?> expectedType) throws ELException {
        this.node = this.build();
        return new ValueExpressionImplEx(this.expression, this.node, this.fnMapper, this.varMapper, expectedType, this._ctx.getBinding() == null ? null : this);
    }
}

