/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Form;
import org.zkoss.bind.FormLegacy;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindEvaluatorXImpl;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.LoadPropertyBinding;
import org.zkoss.bind.sys.SaveBinding;
import org.zkoss.bind.sys.SaveFormBinding;
import org.zkoss.bind.xel.BindXelExpression;
import org.zkoss.bind.xel.BindXelFactory;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.ValueReference;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.zel.ValueExpression;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zkmax.bind.impl.AnnotateBinderEx;
import org.zkoss.zkmax.bind.impl.BindXelFactoryEx;

public class BindEvaluatorXImplEx
extends BindEvaluatorXImpl {
    private transient ExpressionFactory _nonLazyExpf;
    private static final long serialVersionUID = 20141216160422L;

    private ExpressionFactory getNonLazyExpressionFactory() {
        if (this._nonLazyExpf == null) {
            this._nonLazyExpf = Expressions.newExpressionFactory(BindXelFactory.class);
        }
        return this._nonLazyExpf;
    }

    public BindEvaluatorXImplEx(FunctionMapper mapper, Class<? extends ExpressionFactory> expfcls) {
        super(mapper, expfcls);
    }

    public BindEvaluatorXImplEx(FunctionMapper mapper) {
        this(mapper, BindXelFactoryEx.class);
    }

    public BindEvaluatorXImplEx() {
        this(null, BindXelFactoryEx.class);
    }

    private BindXelExpression init(BindContext ctx, String expression, Class<?> expectedType) {
        Binding binding;
        Component comp = null;
        if (ctx != null && (comp = ctx.getComponent()) == null && (binding = ctx.getBinding()) != null) {
            comp = binding.getComponent();
        }
        try {
            return (BindXelExpression)this.getExpressionFactory().parseExpression(this.newXelContext(ctx, comp), "${" + expression + "}", expectedType);
        }
        catch (Exception x) {
            throw MiscUtil.mergeExceptionInfo((Exception)x, (Object)comp);
        }
    }

    private BindXelExpression initNonLazy(BindContext ctx, String expression, Class<?> expectedType) {
        Binding binding;
        Component comp = null;
        if (ctx != null && (comp = ctx.getComponent()) == null && (binding = ctx.getBinding()) != null) {
            comp = binding.getComponent();
        }
        try {
            return (BindXelExpression)this.getNonLazyExpressionFactory().parseExpression(this.newXelContext(ctx, comp), "${" + expression + "}", expectedType);
        }
        catch (Exception x) {
            throw MiscUtil.mergeExceptionInfo((Exception)x, (Object)comp);
        }
    }

    private Form getFormIfAny(Component cmp, Binder binder) {
        if (binder == null || !(binder instanceof AnnotateBinderEx)) {
            Object result;
            if (cmp == null) {
                return null;
            }
            if (cmp.getAttribute("$FORM_ID$") != null) {
                return null;
            }
            if (cmp.getParent() != null && (result = cmp.getParent().getAttributeOrFellow("$FORM_ID$", true)) instanceof Form) {
                return (Form)result;
            }
            return null;
        }
        AnnotateBinderEx annoBinder = (AnnotateBinderEx)binder;
        Map<Component, String> cache = annoBinder.getLookupComponentFormIdCache();
        if (cmp == null) {
            return null;
        }
        String formId = cache.get(cmp);
        if (formId != null) {
            return ((BinderCtrl)binder).getForm(cmp, formId);
        }
        Annotation idanno = ((ComponentCtrl)cmp).getAnnotation("form", "id");
        if (idanno != null) {
            formId = (String)BindEvaluatorXUtil.eval((BindEvaluatorX)this, (Component)cmp, (String)AnnotationUtil.testString((String[])idanno.getAttributeValues("value"), (Annotation)idanno), String.class);
            cache.put(cmp, formId);
            return null;
        }
        return this.lookupForm(cmp.getParent(), cache, binder);
    }

    private Form lookupForm(Component cmp, Map<Component, String> cache, Binder binder) {
        if (cmp == null) {
            return null;
        }
        String formId = cache.get(cmp);
        if (formId != null) {
            return ((BinderCtrl)binder).getForm(cmp, formId);
        }
        Annotation idanno = ((ComponentCtrl)cmp).getAnnotation("form", "id");
        if (idanno != null) {
            formId = (String)BindEvaluatorXUtil.eval((BindEvaluatorX)this, (Component)cmp, (String)AnnotationUtil.testString((String[])idanno.getAttributeValues("value"), (Annotation)idanno), String.class);
            cache.put(cmp, formId);
            return ((BinderCtrl)binder).getForm(cmp, formId);
        }
        if (cmp.getParent() != null) {
            return this.lookupForm(cmp.getParent(), cache, binder);
        }
        cache.remove(cmp);
        return null;
    }

    public ExpressionX parseExpressionX(BindContext ctx, String expression, Class<?> expectedType) throws XelException {
        if (ctx != null) {
            boolean isLoadPropertyBindingWithFormLegacy;
            Binding binding = ctx.getBinding();
            Form form = this.getFormIfAny(ctx.getComponent(), ctx.getBinder());
            boolean isSaveBindingWithForm = binding instanceof SaveBinding && !(binding instanceof SaveFormBinding) && form != null;
            boolean bl = isLoadPropertyBindingWithFormLegacy = binding instanceof LoadPropertyBinding && form instanceof FormLegacy;
            if (isSaveBindingWithForm || isLoadPropertyBindingWithFormLegacy) {
                LazyBindXelExpression lazyBindXelExpression = new LazyBindXelExpression(ctx, expression, expectedType);
                XelContext newXelContext = this.newXelContext(ctx, ctx.getComponent());
                newXelContext.removeAttribute("$IGNORE_TRACKER$");
                newXelContext.setAttribute("$INVALIDATE_REF_VALUE$", (Object)true);
                lazyBindXelExpression.evaluate(newXelContext);
                return lazyBindXelExpression;
            }
        }
        return new LazyBindXelExpression(ctx, expression, expectedType);
    }

    private class LazyBindXelExpression
    extends BindXelExpression {
        protected BindXelExpression _selfExpr;
        private BindContext ctx;
        private String expression;
        private Class<?> expectedType;

        protected LazyBindXelExpression(ValueExpression expr) {
            super(expr);
            throw new IllegalAccessError("Not support!");
        }

        protected LazyBindXelExpression(BindContext ctx, String expression, Class<?> expectedType) {
            super(null);
            this.ctx = ctx;
            this.expression = expression;
            this.expectedType = expectedType;
        }

        public Object evaluate(XelContext xelc) throws XelException {
            return this.getValueExpression().evaluate(xelc);
        }

        private BindXelExpression getValueExpression() {
            if (this._selfExpr == null) {
                this._selfExpr = BindEvaluatorXImplEx.this.init(this.ctx, this.expression, this.expectedType);
            }
            return this._selfExpr;
        }

        public boolean isReadOnly(XelContext xelc) throws XelException {
            return this.getValueExpression().isReadOnly(xelc);
        }

        public void setValue(XelContext xelc, Object value) throws XelException {
            this.getValueExpression().setValue(xelc, value);
        }

        public String getExpressionString() {
            return this.getValueExpression().getExpressionString();
        }

        public Class getType(XelContext xelc) {
            return this.getValueExpression().getType(xelc);
        }

        public ValueReference getValueReference(XelContext xelc) {
            return this.getValueExpression().getValueReference(xelc);
        }
    }
}

