/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.LoggerFactory;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.GoldenPanel;
import org.zkoss.zul.impl.XulElement;

public class GoldenLayout
extends XulElement {
    private static final Gson GSON = new Gson();
    private static final String ON_MATRIX_UPDATE = "onMatrixUpdate";
    private String _areas;
    private List<List<String>> _areasMatrix = new ArrayList<List<String>>();
    private String _orient = "vertical";
    private Set<String> _areasNames = new HashSet<String>(4);
    private String _config;
    public static final String REGION_NORTH = "north";
    public static final String REGION_SOUTH = "south";
    public static final String REGION_EAST = "east";
    public static final String REGION_WEST = "west";
    public static final String REGION_STACK = "stack";
    public static final String TARGET_ROOT = "$root";
    private List<String> _regions = new ArrayList<String>(Arrays.asList("north", "south", "east", "west", "stack"));

    public String getAreas() {
        return this._areas;
    }

    public void setAreas(String areas) {
        if (TARGET_ROOT.equals(areas)) {
            throw new UiException("$root is a preserved area name.");
        }
        if (this.isInitialized()) {
            throw new UiException("Setting areas template is only supported on initial rendering.");
        }
        this._areas = areas;
        this.parseAreasMatrix();
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) {
        if (!this.isInitialized()) {
            this._orient = orient;
            return;
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    private void parseAreasMatrix() {
        BufferedReader reader = new BufferedReader(new StringReader(this._areas));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                List<String> items = Arrays.asList(line.trim().split("\\s+"));
                this._areasMatrix.add(items);
                this._areasNames.addAll(items);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Failed to parse areas", (Throwable)e);
        }
    }

    private JSONObject parseAreas() {
        ArrayList<JSONObject> l = new ArrayList<JSONObject>();
        String direction = "vertical".equals(this._orient) ? "row" : "column";
        l.add(this.parseConfig("row".equals(direction) ? this._areasMatrix : this.transpose(this._areasMatrix), direction, true));
        JSONObject json = new JSONObject();
        json.put((Object)"content", l);
        return json;
    }

    private JSONObject parseConfig(List matrix, String direction, boolean root) {
        boolean doNotStack = false;
        boolean splitted = false;
        int prevSplittedRow = 0;
        String nextDirection = "row".equals(direction) ? "column" : "row";
        JSONObject config = new JSONObject();
        for (int i = 1; i <= matrix.size(); ++i) {
            boolean shouldSplit = true;
            List prevRow = (List)matrix.get(i - 1);
            List currRow = null;
            if (i != matrix.size()) {
                currRow = (List)matrix.get(i);
            }
            if (currRow != null) {
                for (int j = 0; j < currRow.size(); ++j) {
                    if (((String)currRow.get(j)).equals(prevRow.get(j))) {
                        shouldSplit = false;
                        if (!doNotStack) continue;
                    } else {
                        doNotStack = true;
                        if (shouldSplit) {
                            continue;
                        }
                    }
                    break;
                }
            } else {
                shouldSplit = false;
            }
            if (!shouldSplit && (!splitted || i != matrix.size())) continue;
            if (!config.containsKey((Object)"content")) {
                config.put((Object)"content", new ArrayList());
            }
            ArrayList l = (ArrayList)config.get((Object)"content");
            l.add(this.parseConfig(this.transpose(matrix.subList(prevSplittedRow, i)), nextDirection, false));
            if (!config.containsKey((Object)"type")) {
                config.put((Object)"type", (Object)nextDirection);
            }
            prevSplittedRow = i;
            splitted = true;
        }
        if (!splitted && root) {
            return this.parseConfig(this.transpose(matrix), nextDirection, false);
        }
        if (!splitted && doNotStack) {
            throw new UiException("Not a valid format for goldenlayout areas");
        }
        if (!doNotStack) {
            String areaName = (String)((List)matrix.get(0)).get(0);
            config.put((Object)"type", (Object)REGION_STACK);
            config.put((Object)"content", new ArrayList());
            config.put((Object)"id", (Object)areaName);
            boolean transposed = "row".equals(direction);
            String hflex = String.valueOf(transposed ? ((List)matrix.get(0)).size() : matrix.size());
            String vflex = String.valueOf(transposed ? matrix.size() : ((List)matrix.get(0)).size());
            List<GoldenPanel> gps = this.getPanels(areaName);
            if (gps.size() == 0) {
                throw new UiException("Should have at least one GoldenPanel with area='" + areaName + "' specified.");
            }
            for (GoldenPanel gp : gps) {
                if (gp.getHflex() == null) {
                    if (this.isInitialized()) {
                        gp.setHflex(hflex);
                    } else {
                        gp.setHflexDirectly(hflex);
                    }
                }
                if (gp.getVflex() != null) continue;
                if (this.isInitialized()) {
                    gp.setVflex(vflex);
                    continue;
                }
                gp.setVflexDirectly(vflex);
            }
        }
        return config;
    }

    private List<List<String>> transpose(List<List<String>> matrixIn) {
        ArrayList<List<String>> matrixOut = new ArrayList<List<String>>();
        if (!matrixIn.isEmpty()) {
            int noOfElementsInList = matrixIn.get(0).size();
            for (int i = 0; i < noOfElementsInList; ++i) {
                ArrayList<String> col = new ArrayList<String>();
                for (List<String> row : matrixIn) {
                    col.add(row.get(i));
                }
                matrixOut.add(col);
            }
        }
        return matrixOut;
    }

    public Set<String> getAreasNames() {
        return this._areasNames;
    }

    public Integer getColumnsSize() {
        return this._areasMatrix.get(0).size() - 1;
    }

    public Integer getRowsSize() {
        return this._areasMatrix.size() - 1;
    }

    public List<GoldenPanel> getPanels(int col, int row) {
        if (col < 0 || row < 0) {
            throw new UiException("index should be 0 or positive");
        }
        int colMax = this._areasMatrix.size() - 1;
        int rowMax = this._areasMatrix.get(0).size() - 1;
        if (col > colMax || row > rowMax) {
            throw new UiException("Index out of bound, " + col + " > max col " + colMax + ", " + row + " > max row " + rowMax);
        }
        String name = this._areasMatrix.get(row).get(col);
        List<GoldenPanel> gpList = this.getPanels(name);
        return gpList;
    }

    public List<GoldenPanel> getPanels(String area) {
        ArrayList<GoldenPanel> gpList = new ArrayList<GoldenPanel>(2);
        if (area != null) {
            for (Component comp : this.getChildren()) {
                GoldenPanel gp = (GoldenPanel)comp;
                if (!area.equals(gp.getArea())) continue;
                gpList.add(gp);
            }
        }
        return gpList;
    }

    protected GoldenPanel getPanel(int col, int row) {
        List<GoldenPanel> list = this.getPanels(col, row);
        return list.size() > 0 ? list.get(list.size() - 1) : null;
    }

    protected GoldenPanel getPanel(String area) {
        List<GoldenPanel> list = this.getPanels(area);
        return list.size() > 0 ? list.get(list.size() - 1) : null;
    }

    public void deletePanels(String area) {
        List<GoldenPanel> gpList = this.getPanels(area);
        for (GoldenPanel gp : gpList) {
            gp.onClose();
        }
    }

    public void addPanel(GoldenPanel goldenPanel, int col, int row, String region) {
        if (col == -1 || row == -1) {
            this.addPanelToRoot(goldenPanel, region);
        } else {
            this.addPanel(goldenPanel, this.getPanel(col, row), region);
        }
    }

    public void addPanel(GoldenPanel goldenPanel, String area, String region) {
        this.movePanel(goldenPanel, area, region);
        goldenPanel.setParent((Component)this);
    }

    public void addPanel(GoldenPanel goldenPanel, GoldenPanel targetGoldenPanel, String region) {
        this.movePanel(goldenPanel, targetGoldenPanel, region);
        goldenPanel.setParent((Component)this);
    }

    public void addPanelToRoot(GoldenPanel goldenPanel, String region) {
        this.addPanel(goldenPanel, TARGET_ROOT, region);
    }

    public void movePanel(GoldenPanel goldenPanel, int col, int row, String region) {
        if (col == -1 || row == -1) {
            this.movePanelToRoot(goldenPanel, region);
        } else {
            this.movePanel(goldenPanel, this.getPanel(col, row), region);
        }
    }

    public void movePanel(GoldenPanel goldenPanel, String area, String region) {
        GoldenPanel targetGP = this.getPanel(area);
        if (targetGP != null) {
            this.movePanel(goldenPanel, targetGP, region);
        } else {
            this.movePanelToRoot(goldenPanel, region);
        }
    }

    public void movePanel(GoldenPanel goldenPanel, GoldenPanel targetGoldenPanel, String region) {
        if (targetGoldenPanel == null) {
            this.movePanelToRoot(goldenPanel, region);
        } else {
            if (!this._regions.contains(region)) {
                region = REGION_EAST;
            }
            this.syncAddedPanelFlex(goldenPanel, targetGoldenPanel);
            goldenPanel.droppedTo(targetGoldenPanel, region);
        }
    }

    public void movePanelToRoot(GoldenPanel goldenPanel, String region) {
        if (!this._regions.contains(region) || REGION_STACK.equals(region)) {
            region = REGION_EAST;
        }
        goldenPanel.droppedToRoot(region);
    }

    private void syncAddedPanelFlex(GoldenPanel goldenPanel, GoldenPanel targetGoldenPanel) {
        goldenPanel.setHflex(targetGoldenPanel.getHflex());
        goldenPanel.setVflex(targetGoldenPanel.getVflex());
    }

    protected List<List<String>> getAreasMatrix() {
        return this._areasMatrix;
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof GoldenPanel)) {
            throw new UiException("Unsupported child for goldenlayout: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, refChild);
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        Events.postEvent((String)"onInitMatrix", (Component)child, null);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        boolean insertBefore = super.insertBefore(newChild, refChild);
        if (this.isInitialized()) {
            this.parseAreas();
        }
        return insertBefore;
    }

    public void onCreate(Event evt) {
        this._config = JSONValue.toJSONString((Object)this.parseAreas());
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        if (this._areasMatrix.size() > 0) {
            this.render(renderer, "areas", this._areas);
            this.render(renderer, "config", this._config == null ? JSONValue.toJSONString((Object)this.parseAreas()) : this._config);
            this._config = null;
            this.render(renderer, "areasMatrix", GSON.toJson(this._areasMatrix));
        }
        if (!"vertical".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
        super.renderProperties(renderer);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        if (cmd.equals(ON_MATRIX_UPDATE)) {
            JSONArray matrix = (JSONArray)data.get("updateMatrix");
            String removedArea = (String)data.get("removedArea");
            String addedArea = (String)data.get("addedArea");
            String orient = (String)data.get("orient");
            if (removedArea != null) {
                this._areasNames.remove(removedArea);
            }
            if (addedArea != null) {
                this._areasNames.add(addedArea);
            }
            this.updateAreas((List)matrix);
            this._areasMatrix = matrix;
            this._orient = orient;
        } else {
            super.service(request, everError);
        }
    }

    private void updateAreas(List matrix) {
        StringBuilder sb = new StringBuilder();
        for (Object o : matrix) {
            sb.append(Strings.join((Object[])((List)o).toArray(new String[0]), (char)' ')).append("\n");
        }
        this._areas = sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected String updateInitialMatrix(GoldenPanel dropTarget, String region, String area) {
        List<List<String>> m;
        String dropTargetArea;
        if (dropTarget != null) {
            dropTargetArea = dropTarget.getArea();
            if (dropTargetArea == null) {
                dropTargetArea = TARGET_ROOT;
            }
        } else {
            dropTargetArea = TARGET_ROOT;
        }
        if (region == null || REGION_STACK.equals(region)) {
            region = REGION_EAST;
        }
        if ((m = this.getAreasMatrix()).isEmpty()) {
            ArrayList<String> row = new ArrayList<String>(2);
            row.add(area);
            m.add(row);
            return region;
        }
        if (TARGET_ROOT.equals(dropTargetArea)) {
            if (REGION_NORTH.equals(region)) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < m.get(0).size(); ++i) {
                    list.add(area);
                }
                m.add(0, list);
            } else if (REGION_SOUTH.equals(region)) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < m.get(0).size(); ++i) {
                    list.add(area);
                }
                m.add(list);
            } else {
                for (List<String> list : m) {
                    if (REGION_EAST.equals(region)) {
                        list.add(area);
                        continue;
                    }
                    list.add(0, area);
                }
            }
        } else {
            Integer x0 = null;
            Integer x1 = null;
            Integer y0 = null;
            Integer y1 = null;
            for (int row = 0; row < m.size(); ++row) {
                List<String> currRow = m.get(row);
                if (x1 == null) {
                    x0 = currRow.indexOf(dropTargetArea);
                    if (x0 == -1) continue;
                    y0 = row;
                    x1 = currRow.lastIndexOf(dropTargetArea);
                    --row;
                    continue;
                }
                if (!currRow.contains(dropTargetArea)) {
                    y1 = row - 1;
                    break;
                }
                if (row != m.size() - 1) continue;
                y1 = row;
                break;
            }
            if (x1 == null || y1 == null) {
                return region;
            }
            switch (region) {
                case "west": {
                    if (x1 - x0 == 0) {
                        for (List<String> list : m) {
                            list.add(x0 + 1, list.get(x0));
                        }
                    }
                    for (int row3 = y0.intValue(); row3 <= y1; ++row3) {
                        List<String> list = m.get(row3);
                        list.set(x0, area);
                    }
                    break;
                }
                case "east": {
                    if (x1 - x0 == 0) {
                        for (List<String> list : m) {
                            list.add(x0 + 1, list.get(x0));
                        }
                        Integer row3 = x1;
                        Integer n = x1 = Integer.valueOf(x1 + 1);
                    }
                    for (int row = y0.intValue(); row <= y1; ++row) {
                        List<String> list = m.get(row);
                        list.set(x1, area);
                    }
                    break;
                }
                case "north": {
                    void var13_35;
                    if (y1 - y0 == 0) {
                        m.add(y0 + 1, (ArrayList)((ArrayList)m.get(y0)).clone());
                    }
                    List<String> row = m.get(y0);
                    int n = x0;
                    while (var13_35 <= x1) {
                        row.set((int)var13_35, area);
                        ++var13_35;
                    }
                    break;
                }
                case "south": {
                    void var13_38;
                    Object row;
                    if (y1 - y0 == 0) {
                        m.add(y0 + 1, (ArrayList)((ArrayList)m.get(y0)).clone());
                        row = y1;
                        Integer n = y1 = Integer.valueOf(y1 + 1);
                    }
                    row = m.get(y1);
                    int n = x0;
                    while (var13_38 <= x1) {
                        row.set((int)var13_38, (String)area);
                        ++var13_38;
                    }
                    break;
                }
            }
        }
        return region;
    }

    static {
        GoldenLayout.addClientEvent(GoldenLayout.class, (String)ON_MATRIX_UPDATE, (int)8193);
    }
}

