/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Type;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Converter;
import org.zkoss.json.JSONAware;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;

public class JacksonConverter
implements Converter<Object, Object, Component> {
    private ObjectMapper jackson = new ObjectMapper();

    public JacksonConverter() {
        SimpleModule zkModule = new SimpleModule("ZKComponentModule", new Version(1, 0, 0, null, null, null));
        zkModule.addSerializer((JsonSerializer)new ZKComponentSerializer());
        zkModule.addSerializer((JsonSerializer)new ZKJSONAwareSerializer());
        this.jackson.registerModule((Module)zkModule);
    }

    public Object coerceToUi(Object beanProp, Component component, BindContext ctx) {
        try {
            return this.jackson.writeValueAsString(beanProp);
        }
        catch (JsonProcessingException e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    private JavaType getType(Type type) {
        return this.jackson.getTypeFactory().constructType(type, (Class)null);
    }

    public Object coerceToBean(Object compAttr, Component component, BindContext ctx) {
        Class type = (Class)ctx.getAttribute((Object)"org.zkoss.bind.BindingParamCall.type");
        JavaType javaType = this.getType(type);
        if (compAttr != null) {
            try {
                return this.jackson.readValue(compAttr.toString(), javaType);
            }
            catch (JsonParseException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            catch (JsonMappingException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
            catch (IOException e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
        return null;
    }

    private static class ZKJSONAwareSerializer
    extends JsonSerializer<JSONAware> {
        private ZKJSONAwareSerializer() {
        }

        public Class<JSONAware> handledType() {
            return JSONAware.class;
        }

        public void serialize(JSONAware value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeRawValue(value.toJSONString());
        }
    }

    private static class ZKComponentSerializer
    extends JsonSerializer<Component> {
        private ZKComponentSerializer() {
        }

        public Class<Component> handledType() {
            return Component.class;
        }

        public void serialize(Component value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeRawValue("zk.$('#" + value.getUuid() + "')");
        }
    }
}

