/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.websocket;

import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ZKWebSocket;
import org.zkoss.zk.ui.util.WebAppCleanup;
import org.zkoss.zk.ui.util.WebAppInit;
import org.zkoss.zkmax.au.websocket.WebSocketDesktopInit;
import org.zkoss.zkmax.au.websocket.WebSocketEndPoint;

public class WebSocketWebAppInit
implements WebAppInit,
WebAppCleanup {
    private static final String ATTR_FILTER_INSTALLED = "org.zkoss.zkmax.au.websocket.filter.installed";

    public void init(WebApp wapp) throws Exception {
        String url = WebSocketWebAppInit.getWebSocketUrl();
        wapp.setAttribute("websocketUrl", (Object)url);
        ServerEndpointConfig config = ServerEndpointConfig.Builder.create(WebSocketEndPoint.class, (String)url).configurator((ServerEndpointConfig.Configurator)new ZKWebSocket()).build();
        ServerContainer serverContainer = (ServerContainer)wapp.getServletContext().getAttribute("jakarta.websocket.server.ServerContainer");
        serverContainer.addEndpoint(config);
        if (!WebSocketWebAppInit.isFilterInstalled(wapp)) {
            wapp.getServletContext().addFilter("wsFilter", "org.zkoss.zkmax.au.websocket.WebSocketFilter").addMappingForUrlPatterns(null, false, new String[]{url + "/*"});
        }
        wapp.getConfiguration().addListener(WebSocketDesktopInit.class);
    }

    public static boolean isFilterInstalled(WebApp wapp) {
        Object o = wapp.getServletContext().getAttribute(ATTR_FILTER_INSTALLED);
        return o instanceof Boolean && (Boolean)o != false;
    }

    public static String getWebSocketUrl() {
        String url = Library.getProperty((String)"org.zkoss.zkmax.au.websocket.WebSocketEndPoint.urlPattern");
        if (url == null) {
            url = "/zkwm";
        } else if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public void cleanup(WebApp wapp) throws Exception {
        WebSocketEndPoint.shutdownPingExecutor();
    }
}

