/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.impl.XulElement;

public class Signature
extends XulElement {
    public static final String ON_SAVE = "onSave";
    public static final String ON_CLEAR = "onClear";
    private int _penSize = 1;
    private String _penColor = "black";
    private String _backgroundColor = "white";
    private String _backgroundImage;
    private boolean _backgroundIncluded = true;
    private boolean _toolbarVisible = true;
    private String _saveType = "image/png";
    private String _undoLabel;
    private String _saveLabel;
    private String _clearLabel;

    protected boolean isChildable() {
        return false;
    }

    public int getPenSize() {
        return this._penSize;
    }

    public void setPenSize(int penSize) {
        if (this._penSize != penSize) {
            this._penSize = penSize;
            this.smartUpdate("penSize", this._penSize);
        }
    }

    public String getPenColor() {
        return this._penColor;
    }

    public void setPenColor(String penColor) {
        if (!Objects.equals((Object)this._penColor, (Object)penColor)) {
            this._penColor = penColor;
            this.smartUpdate("penColor", this._penColor);
        }
    }

    public String getBackgroundColor() {
        return this._backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        if (!Objects.equals((Object)this._backgroundColor, (Object)backgroundColor)) {
            this._backgroundColor = backgroundColor;
            this.smartUpdate("backgroundColor", this._backgroundColor);
        }
    }

    public String getBackgroundImage() {
        return this._backgroundImage;
    }

    public void setBackgroundImage(String backgroundImage) {
        if (backgroundImage != null && backgroundImage.length() == 0) {
            backgroundImage = null;
        }
        if (!Objects.equals((Object)this._backgroundImage, (Object)backgroundImage)) {
            this._backgroundImage = backgroundImage;
            this.smartUpdate("backgroundImage", this::getEncodedURL);
        }
    }

    public boolean isBackgroundIncluded() {
        return this._backgroundIncluded;
    }

    public void setBackgroundIncluded(boolean backgroundIncluded) {
        if (this._backgroundIncluded != backgroundIncluded) {
            this._backgroundIncluded = backgroundIncluded;
            this.smartUpdate("backgroundIncluded", this._backgroundIncluded);
        }
    }

    public boolean isToolbarVisible() {
        return this._toolbarVisible;
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        if (this._toolbarVisible != toolbarVisible) {
            this._toolbarVisible = toolbarVisible;
            this.smartUpdate("toolbarVisible", this._toolbarVisible);
        }
    }

    public String getSaveType() {
        return this._saveType;
    }

    public void setSaveType(String saveType) {
        if (!Objects.equals((Object)this._saveType, (Object)saveType)) {
            this._saveType = saveType;
            this.smartUpdate("saveType", this._saveType);
        }
    }

    public String getUndoLabel() {
        return this._undoLabel;
    }

    public void setUndoLabel(String undoLabel) {
        if (!Objects.equals((Object)this._undoLabel, (Object)undoLabel)) {
            this._undoLabel = undoLabel;
            this.smartUpdate("undoLabel", this._undoLabel);
        }
    }

    public String getSaveLabel() {
        return this._saveLabel;
    }

    public void setSaveLabel(String saveLabel) {
        if (!Objects.equals((Object)this._saveLabel, (Object)saveLabel)) {
            this._saveLabel = saveLabel;
            this.smartUpdate("saveLabel", this._saveLabel);
        }
    }

    public String getClearLabel() {
        return this._clearLabel;
    }

    public void setClearLabel(String clearLabel) {
        if (!Objects.equals((Object)this._clearLabel, (Object)clearLabel)) {
            this._clearLabel = clearLabel;
            this.smartUpdate("clearLabel", this._clearLabel);
        }
    }

    public void undo() {
        this.response((AuResponse)new AuInvoke((Component)this, "undo"));
    }

    public void clear() {
        this.response((AuResponse)new AuInvoke((Component)this, "clear"));
    }

    public void save() {
        this.response((AuResponse)new AuInvoke((Component)this, "save"));
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals(ON_SAVE)) {
            Events.postEvent((Event)UploadEvent.getUploadEvent((String)cmd, (Component)this, (AuRequest)request));
        } else if (cmd.equals(ON_CLEAR)) {
            Events.postEvent((Event)new Event(cmd, (Component)this));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        Runtime.init((Object)((Object)this));
        if (this._penSize != 1) {
            this.render(renderer, "penSize", this._penSize);
        }
        if (!"black".equals(this._penColor)) {
            this.render(renderer, "penColor", this._penColor);
        }
        if (!"white".equals(this._backgroundColor)) {
            this.render(renderer, "backgroundColor", this._backgroundColor);
        }
        if (this._backgroundImage != null) {
            this.render(renderer, "backgroundImage", this.getEncodedURL());
        }
        if (!this._backgroundIncluded) {
            renderer.render("backgroundIncluded", this._backgroundIncluded);
        }
        if (!"image/png".equals(this._saveType)) {
            this.render(renderer, "saveType", this._saveType);
        }
        if (!this._toolbarVisible) {
            renderer.render("toolbarVisible", this._toolbarVisible);
        }
        this.render(renderer, "undoLabel", this._undoLabel);
        this.render(renderer, "saveLabel", this._saveLabel);
        this.render(renderer, "clearLabel", this._clearLabel);
    }

    private String getEncodedURL() {
        Desktop dt;
        if (this._backgroundImage != null && (dt = this.getDesktop()) != null) {
            return dt.getExecution().encodeURL(this._backgroundImage);
        }
        return "";
    }

    static {
        Signature.addClientEvent(Signature.class, (String)ON_SAVE, (int)0);
        Signature.addClientEvent(Signature.class, (String)ON_CLEAR, (int)0);
    }
}

