/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.websocket;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import java.util.UUID;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.http.SimpleSession;
import org.zkoss.zk.ui.http.ZKWebSocket;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zkmax.ui.http.FacadeHttpServletRequest;

public class WebSocketFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(final ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DesktopCache desktopCache;
        SimpleSession session;
        HttpSession httpSession = ((HttpServletRequest)request).getSession();
        Desktop desktop = null;
        if (httpSession != null && (session = (SimpleSession)httpSession.getAttribute("javax.zkoss.zk.ui.Session")) != null && (desktopCache = session.getDesktopCache()) != null) {
            desktop = desktopCache.getDesktopIfAny(request.getParameter("dtid"));
        }
        if (desktop != null) {
            desktop.setAttribute("org.zkoss.zkmax.ui.websocket.handshakeHttpServletRequest", (Object)this.createWSHandshakeRequest(request));
            desktop.setAttribute("org.zkoss.zkmax.ui.websocket.handshakeHttpServletResponse", (Object)response);
        }
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper((HttpServletRequest)request){
            private final String _connectionUuid;
            {
                super(arg0);
                this._connectionUuid = UUID.randomUUID().toString();
            }

            public Principal getUserPrincipal() {
                return new ZKWebSocket.ZKPrinciple(((HttpServletRequest)request).getUserPrincipal(), this._connectionUuid);
            }
        };
        chain.doFilter((ServletRequest)wrappedRequest, response);
    }

    public void destroy() {
    }

    protected FacadeHttpServletRequest createWSHandshakeRequest(ServletRequest request) {
        return new FacadeHttpServletRequest((HttpServletRequest)request, false);
    }
}

