/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.select;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.impl.Reflections;
import org.zkoss.zk.ui.util.UiLifeCycle;
import org.zkoss.zkmax.ui.select.annotation.Subscribe;

public class SelectorsExt {
    public static Object subscribeEventQueues(Object controller) {
        return SelectorsExt.subscribeEventQueues(controller, false);
    }

    private static List<SubscriptionInfo> subscribeEventQueues(final Object controller, final boolean rewire) {
        final ArrayList<SubscriptionInfo> subsInfo = new ArrayList<SubscriptionInfo>();
        Reflections.forMethods(controller.getClass(), Subscribe.class, (Reflections.MethodRunner)new Reflections.MethodRunner<Subscribe>(){

            public void onMethod(Class<?> clazz, Method method, Subscribe anno) {
                if ((method.getModifiers() & 8) != 0) {
                    throw new UiException("Cannot add forward to static method: " + method.getName());
                }
                EventQueue eq = EventQueues.lookup((String)anno.value(), (String)anno.scope(), (boolean)true);
                SubscribeMethodEventListener l = new SubscribeMethodEventListener(method, controller, anno.eventName());
                if (!rewire || !eq.isSubscribed((EventListener)l)) {
                    eq.subscribe((EventListener)l);
                    subsInfo.add(new SubscriptionInfo(anno.value(), anno.scope(), anno.autoUnsubscribe(), l));
                }
            }
        });
        return subsInfo.size() > 0 ? subsInfo : null;
    }

    static Object resubscribeEventQueues(Object controller) {
        return SelectorsExt.subscribeEventQueues(controller, true);
    }

    static void postSubscriptionHandling(Object subsInfo, Object target) {
        if (!(subsInfo instanceof List) || !(target instanceof Component) || ((Component)target).getDesktop() == null) {
            return;
        }
        for (SubscriptionInfo si : (List)subsInfo) {
            if (!si.isAutoUnsubscribe()) continue;
            ((Component)target).getDesktop().addListener((Object)new UnsubscribeListener((Component)target, (List)subsInfo));
            break;
        }
    }

    public static class ExtendedUtilityHandlerImpl
    extends SelectorComposer.UtilityHandlerImpl {
        private static final long serialVersionUID = 1L;

        public Object subscribeEventQueues(Object controller) {
            return SelectorsExt.subscribeEventQueues(controller);
        }

        public Object resubscribeEventQueues(Object controller) {
            return SelectorsExt.resubscribeEventQueues(controller);
        }

        public void postSubscriptionHandling(Object subsInfo, Object target) {
            SelectorsExt.postSubscriptionHandling(subsInfo, target);
        }
    }

    private static class SubscribeMethodEventListener
    implements EventListener<Event>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Method _ctrlMethod;
        private transient boolean _noMethodSet = false;
        private final Object _ctrl;
        private final String _sign;
        private final String _eventName;
        private final Object _methodLock = new Object();

        public SubscribeMethodEventListener(Method method, Object controller, String eventName) {
            this._ctrlMethod = method;
            this._ctrl = controller;
            this._sign = SubscribeMethodEventListener.toSignature(method);
            this._eventName = eventName;
        }

        private static String toSignature(Method m) {
            return m.toString();
        }

        private Method getCtrlMethodIfAny() {
            try {
                return this.getCtrlMethod();
            }
            catch (NoSuchMethodError x) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Method getCtrlMethod() {
            if (this._ctrlMethod != null) {
                return this._ctrlMethod;
            }
            if (this._noMethodSet) {
                throw new NoSuchMethodError(this._sign);
            }
            Object object = this._methodLock;
            synchronized (object) {
                Reflections.forMethods(this._ctrl.getClass(), Subscribe.class, (Reflections.MethodRunner)new Reflections.MethodRunner<Subscribe>(){

                    public void onMethod(Class<?> clazz, Method method, Subscribe anno) {
                        if (_ctrlMethod == null && _sign.equals(SubscribeMethodEventListener.toSignature(method))) {
                            _ctrlMethod = method;
                        }
                    }
                });
                if (this._ctrlMethod == null) {
                    this._noMethodSet = true;
                    throw new NoSuchMethodError(this._sign);
                }
            }
            return this._ctrlMethod;
        }

        public void onEvent(Event event) throws Exception {
            if (!this._eventName.isEmpty() && !this._eventName.equals(event.getName())) {
                return;
            }
            Method m = this.getCtrlMethod();
            Class<?>[] types = m.getParameterTypes();
            if (types.length == 0) {
                m.invoke(this._ctrl, new Object[0]);
            } else {
                ArrayList<Object> params = new ArrayList<Object>(types.length);
                if (Event.class.isAssignableFrom(types[0])) {
                    params.add(event);
                }
                if (params.size() != types.length) {
                    params.addAll(Arrays.asList((Object[])event.getData()));
                }
                m.invoke(this._ctrl, params.toArray());
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ctrl == null ? 0 : this._ctrl.hashCode());
            Method ctrlMethodIfAny = this.getCtrlMethodIfAny();
            result = 31 * result + (ctrlMethodIfAny == null ? 0 : ctrlMethodIfAny.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubscribeMethodEventListener other = (SubscribeMethodEventListener)obj;
            if (this._ctrl == null ? other._ctrl != null : !this._ctrl.equals(other._ctrl)) {
                return false;
            }
            Method ctrlMethodIfAny = this.getCtrlMethodIfAny();
            if (ctrlMethodIfAny == null) {
                return other.getCtrlMethodIfAny() == null;
            }
            return ctrlMethodIfAny.equals(other.getCtrlMethodIfAny());
        }
    }

    private static class SubscriptionInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private EventListener<Event> _listener;
        private String _qname;
        private String _scope;
        private boolean _autoUnsubscribe;

        public SubscriptionInfo(String qname, String scope, boolean autoUnsubscribe, EventListener<Event> listener) {
            this._listener = listener;
            this._qname = qname;
            this._scope = scope;
            this._autoUnsubscribe = autoUnsubscribe;
        }

        public EventListener<Event> getListener() {
            return this._listener;
        }

        public String getQueueName() {
            return this._qname;
        }

        public String getScope() {
            return this._scope;
        }

        public boolean isAutoUnsubscribe() {
            return this._autoUnsubscribe;
        }
    }

    private static class UnsubscribeListener
    implements Serializable,
    UiLifeCycle {
        private static final long serialVersionUID = 1L;
        private final List<SubscriptionInfo> _subsInfo;
        private final Component _self;

        public UnsubscribeListener(Component self, List<SubscriptionInfo> subsinfo) {
            this._subsInfo = subsinfo;
            this._self = self;
        }

        public void afterComponentAttached(Component comp, Page page) {
        }

        public void afterComponentDetached(Component comp, Page prevpage) {
            if (this._self == comp || Components.isAncestor((Component)comp, (Component)this._self)) {
                if (this._subsInfo != null && this._subsInfo.size() > 0) {
                    for (SubscriptionInfo si : this._subsInfo) {
                        EventQueue eq;
                        if (!si.isAutoUnsubscribe() || (eq = EventQueues.lookup((String)si.getQueueName(), (String)si.getScope(), (boolean)false)) == null) continue;
                        eq.unsubscribe(si.getListener());
                    }
                }
                prevpage.getDesktop().removeListener((Object)this);
            }
        }

        public void afterComponentMoved(Component parent, Component child, Component prevparent) {
        }

        public void afterPageAttached(Page page, Desktop desktop) {
        }

        public void afterPageDetached(Page page, Desktop prevdesktop) {
        }

        public void afterShadowAttached(ShadowElement arg0, Component arg1) {
        }

        public void afterShadowDetached(ShadowElement shadow, Component prevhost) {
        }
    }
}

