/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.impl;

import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.html.JavaScript;
import org.zkoss.html.StyleSheet;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.impl.PageImpl;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.PageRenderer;
import org.zkoss.zul.Include;

public class EmbeddedPageRenderer
implements PageRenderer {
    private final String _token;
    private final String _zkHostURL;

    public EmbeddedPageRenderer(String token, String zkHostURL) {
        try {
            Integer.parseInt(token.replace("_zEmbeddedID_", ""));
        }
        catch (NumberFormatException e) {
            throw new UiException("Invalid embedded token" + token);
        }
        this._token = token;
        this._zkHostURL = zkHostURL;
    }

    public void render(Page page, Writer out) throws IOException {
        Execution exec = Executions.getCurrent();
        exec.setResponseHeader("Content-Type", "text/javascript;charset=UTF-8");
        this.renderPage(exec, page, out);
    }

    private void renderPage(Execution exec, Page page, Writer out) throws IOException {
        boolean isIncludeDefer = ((PageImpl)page).getOwner() instanceof Include;
        StringBuilder sb = new StringBuilder(1024);
        String pageUuid = page.getUuid();
        if (!isIncludeDefer) {
            sb.append("zEmbedded['_z_loadZKContent_").append(this._token).append("'] = function(){").append("zEmbedded._injectDOM('").append(this._token).append("','").append(pageUuid).append("');\n");
            out.write(sb.toString());
        }
        HtmlPageRenders.outPageContent((Execution)exec, (Page)page, (Writer)out, (boolean)true);
        sb.setLength(0);
        if (!isIncludeDefer) {
            sb.append("};\n");
            this.outStyleSheets(exec, sb);
            this.outJavaScripts(exec, sb, pageUuid);
        }
        out.write(sb.toString());
    }

    private void outStyleSheets(Execution exec, StringBuilder sb) throws IOException {
        sb.append("zEmbedded._loadStyleSheets(");
        List styleSheets = HtmlPageRenders.getStyleSheets((Execution)exec, null, null);
        LinkedList styleSheetInfoList = new LinkedList();
        int size = styleSheets.size();
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            StyleSheet styleSheet = (StyleSheet)styleSheets.get(i);
            String href = styleSheet.getHref();
            String media = styleSheet.getMedia();
            if (href == null) continue;
            try {
                if (exec != null) {
                    href = (String)exec.evaluate((Page)null, href, String.class);
                }
                if (href == null || href.length() <= 0) continue;
                info.put("type", styleSheet.getType());
                info.put("href", this._zkHostURL + ServletFns.encodeURL((String)href));
                if (styleSheet.isDisabled()) {
                    info.put("disabled", "true");
                }
                if (media != null) {
                    info.put("media", media);
                }
                styleSheetInfoList.add(info);
                continue;
            }
            catch (ServletException e) {
                throw new UiException((Throwable)e);
            }
        }
        sb.append(JSONArray.toJSONString(styleSheetInfoList)).append(",'").append(this._token).append("');\n");
    }

    private void outJavaScripts(Execution exec, StringBuilder sb, String pageUuid) throws IOException {
        Desktop desktop = exec.getDesktop();
        String deviceType = desktop != null ? desktop.getDeviceType() : "ajax";
        LinkedHashSet javaScripts = new LinkedHashSet(32);
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType((String)deviceType)) {
            javaScripts.addAll(langdef.getJavaScripts());
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        LinkedList javaScriptInfoList = new LinkedList();
        for (JavaScript js : javaScripts) {
            Object src = js.getSrc();
            HashMap<String, Object> scriptInfo = new HashMap<String, Object>();
            String charset = js.getCharset();
            scriptInfo.put("charset", charset);
            if (src != null) {
                try {
                    src = this._zkHostURL + ServletFns.encodeURL((String)src);
                    scriptInfo.put("src", src);
                }
                catch (ServletException e) {
                    throw new UiException((Throwable)e);
                }
                if (((String)src).contains("/zk.wpd")) {
                    info.put("zkSrc", src);
                    info.put("zkCharset", charset);
                    continue;
                }
            } else {
                scriptInfo.put("content", js.getContent());
            }
            javaScriptInfoList.add(scriptInfo);
        }
        info.put("token", this._token);
        info.put("pageUuid", pageUuid);
        info.put("zkHostURL", this._zkHostURL);
        sb.append("zEmbedded._loadJavaScripts(").append(JSONObject.toJSONString(info)).append(",").append(JSONArray.toJSONString(javaScriptInfoList)).append(");");
    }
}

