/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.zkoss.bind.tracker.impl.BindUiLifeCycle;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;

public class BindUiLifeCycleExtension
implements BindUiLifeCycle.Extension {
    private static final String LIFE_CYCLE_HANDLING_KEY = "$BIND_LF_HANDLING$";

    public void markLifeCycleHandling(Component comp) {
        Set<Component> compSet = this.getLifeCycleHandlingSet(true);
        Stack<Component> stack = new Stack<Component>();
        stack.push(comp);
        while (!stack.isEmpty()) {
            comp = (Component)stack.pop();
            if (compSet.contains(comp)) continue;
            compSet.add(comp);
            for (Component c : comp.getChildren()) {
                stack.push(c);
            }
        }
    }

    public Set<Component> getLifeCycleHandlingSet(boolean create) {
        Execution exec = Executions.getCurrent();
        HashSet compSet = (HashSet)exec.getAttribute(LIFE_CYCLE_HANDLING_KEY);
        if (compSet == null && create) {
            compSet = new HashSet();
            exec.setAttribute(LIFE_CYCLE_HANDLING_KEY, compSet);
        }
        return compSet;
    }

    public boolean isLifeCycleHandling(Component comp) {
        Set<Component> compSet = this.getLifeCycleHandlingSet(false);
        return compSet == null ? false : compSet.contains(comp);
    }

    public void removeLifeCycleHandling(Component comp) {
        Set<Component> compSet = this.getLifeCycleHandlingSet(false);
        if (compSet != null && compSet.size() > 0) {
            compSet.remove(comp);
        }
    }
}

