/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.websocket;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.AuWriters;
import org.zkoss.zkmax.au.websocket.ResponseWrapper;
import org.zkoss.zkmax.au.websocket.WebSocketEndPoint;

public class WSAuWriter
implements AuWriter {
    private JSONObject _out;
    private JSONArray _rs;
    private Map<String, Object> _header;
    private Map<String, Object> _general;
    private WebSocketEndPoint _wsep;
    private byte[] _result;

    public void setCompress(boolean compress) {
    }

    public AuWriter open(Object websocketEndpoint, Object response) throws IOException {
        this._wsep = (WebSocketEndPoint)websocketEndpoint;
        this._rs = new JSONArray();
        this._out = AuWriters.getJSONOutput((JSONArray)this._rs);
        if (response != null) {
            this._header = ((ResponseWrapper)((Object)response)).getExtraHeaders();
            this._general = ((ResponseWrapper)((Object)response)).getGeneral();
        } else {
            this._header = new HashMap<String, Object>(4);
            this._general = new HashMap<String, Object>(4);
        }
        this._out.put((Object)"header", this._header);
        this._out.put((Object)"general", this._general);
        return this;
    }

    public void close(Object websocketEndpoint, Object response) throws IOException {
        if (response == null) {
            this._general.put("status", 500);
        }
        this._wsep.sendText(this._out.toJSONString());
        if (this._result == null) {
            this._result = this._out.toString().getBytes("UTF-8");
            this._rs = null;
            this._header = null;
        }
        this._out = null;
    }

    public Object complete() throws IOException {
        if (this._result != null) {
            throw new IllegalStateException();
        }
        this._result = this._out.toString().getBytes("UTF-8");
        this._rs = null;
        return this.save(this._result);
    }

    public void resend(Object prevContent) throws IOException {
        if (prevContent == null) {
            throw new IllegalArgumentException();
        }
        if (this._result != null || !this._rs.isEmpty()) {
            throw new IllegalStateException(this._rs.isEmpty() ? "resend twice or complete?" : "write called");
        }
        this._result = this.restore(prevContent);
        this._rs = null;
    }

    public void writeResponseId(int resId) throws IOException {
        this._out.put((Object)"rid", (Object)new Integer(resId));
    }

    public void write(AuResponse response) throws IOException {
        this._rs.add((Object)AuWriters.toJSON((AuResponse)response));
    }

    public void write(Collection<AuResponse> responses) throws IOException {
        for (AuResponse response : responses) {
            this.write(response);
        }
    }

    protected byte[] restore(Object data) {
        return (byte[])data;
    }

    protected Object save(byte[] data) {
        return data;
    }
}

