/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.http;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FacadeHttpServletRequest
extends HttpServletRequestWrapper {
    private final String _contextPath;
    private final HttpSession _hsession;
    private final Locale _locale;
    private final Set<Locale> _locales = new HashSet<Locale>(4);
    private final String _authType;
    private final Cookie[] _cookies;
    private final String _method;
    private final String _requestURI;
    private final StringBuffer _requestURL;
    private final String _servletPath;
    private final String _protocol;
    private final String _scheme;
    private final String _serverName;
    private final int _serverPort;
    private final String _remoteAddr;
    private final String _remoteHost;
    private final boolean _isSecure;
    private final int _remotePort;
    private final String _localName;
    private final ServletContext _servletContext;
    private final int _localPort;
    private final DispatcherType _dispatcherType;
    private final Map<String, Object> _attributes = new HashMap<String, Object>(2);
    private final Map<String, String> _headers = new HashMap<String, String>(4);

    public FacadeHttpServletRequest(HttpServletRequest request) {
        this(request, true);
    }

    public FacadeHttpServletRequest(HttpServletRequest request, boolean keepAttributes) {
        super(request);
        String name;
        this._contextPath = request.getContextPath();
        this._locale = request.getLocale();
        this._hsession = request.getSession();
        this._authType = request.getAuthType();
        this._cookies = request.getCookies();
        this._method = request.getMethod();
        this._requestURI = request.getRequestURI();
        this._requestURL = request.getRequestURL();
        this._servletPath = request.getServletPath();
        this._protocol = request.getProtocol();
        this._scheme = request.getScheme();
        this._serverName = request.getServerName();
        this._serverPort = request.getServerPort();
        this._remoteAddr = request.getRemoteAddr();
        this._remoteHost = request.getRemoteHost();
        this._isSecure = request.isSecure();
        this._remotePort = request.getRemotePort();
        this._servletContext = request.getServletContext();
        this._localName = request.getLocalName();
        this._localPort = request.getLocalPort();
        this._dispatcherType = request.getDispatcherType();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            this._headers.put(name.toLowerCase(), request.getHeader(name));
        }
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            this._locales.add(locale);
        }
        if (keepAttributes) {
            names = request.getAttributeNames();
            while (names.hasMoreElements()) {
                name = (String)names.nextElement();
                this._attributes.put(name, request.getAttribute(name));
            }
        }
    }

    public String getAuthType() {
        return this._authType;
    }

    public Cookie[] getCookies() {
        return this._cookies;
    }

    public long getDateHeader(String name) {
        return -1L;
    }

    public String getHeader(String name) {
        return this._headers.get(name.toLowerCase());
    }

    public Enumeration<String> getHeaders(String name) {
        HashSet<String> set = new HashSet<String>();
        String header = this._headers.get(name.toLowerCase());
        if (header != null && !"".equals(header.trim())) {
            set.add(header);
        }
        return Collections.enumeration(set);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this._headers.keySet());
    }

    public int getIntHeader(String name) throws NumberFormatException {
        Object value = this._attributes.get(name);
        return value == null ? -1 : Long.valueOf(value.toString()).intValue();
    }

    public String getMethod() {
        return this._method;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this._requestURI;
    }

    public StringBuffer getRequestURL() {
        return this._requestURL;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public HttpSession getSession(boolean create) {
        return this._hsession;
    }

    public HttpSession getSession() {
        return this._hsession;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return new LinkedList<Part>();
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public Object getAttribute(String name) {
        Object attr = this._attributes.get(name);
        return attr == null && name.startsWith("jakarta.servlet.") ? super.getAttribute(name) : attr;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this._attributes.keySet());
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        return -1;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String name) {
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(new HashSet(0));
    }

    public String[] getParameterValues(String name) {
        return new String[0];
    }

    public Map<String, String[]> getParameterMap() {
        return new HashMap<String, String[]>(0);
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this._attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    public void removeAllAttributes() {
        this._attributes.clear();
    }

    public Locale getLocale() {
        return this._locale;
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this._locales);
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this._servletContext.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return path;
    }

    public int getRemotePort() {
        return this._remotePort;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getLocalAddr() {
        return this._localName;
    }

    public int getLocalPort() {
        return this._localPort;
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new AssertionError((Object)"Not able to start async since it's a facade request");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new AssertionError((Object)"Not able to start async since it's a facade request");
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return this._dispatcherType;
    }
}

