/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.ext;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;
import org.zkoss.zkmax.bind.ext.ForwardingCollection;
import org.zkoss.zkmax.bind.ext.ForwardingMap;

public class StandardBiMap<K, V>
extends ForwardingMap<K, V>
implements Serializable {
    private transient Map<K, V> delegate;
    private transient StandardBiMap<V, K> inverse;
    private transient AtomicReference<Set<K>> keySet = new AtomicReference();
    private transient AtomicReference<Set<V>> valueSet = new AtomicReference();
    private transient AtomicReference<Set<Map.Entry<K, V>>> entrySet = new AtomicReference();
    private static final long serialVersionUID = 0L;

    protected StandardBiMap(Map<K, V> forward, Map<V, K> backward) {
        this.setDelegates(forward, backward);
    }

    private StandardBiMap(Map<K, V> backward, StandardBiMap<V, K> forward) {
        this.delegate = backward;
        this.inverse = forward;
    }

    @Override
    public Map<K, V> delegate() {
        return this.delegate;
    }

    protected void setDelegates(Map<K, V> forward, Map<V, K> backward) {
        StandardBiMap.checkState(this.delegate == null);
        StandardBiMap.checkState(this.inverse == null);
        StandardBiMap.checkArgument(forward.isEmpty());
        StandardBiMap.checkArgument(backward.isEmpty());
        StandardBiMap.checkArgument(forward != backward);
        this.delegate = forward;
        this.inverse = new Inverse<K, V>(backward, this);
    }

    void setInverse(StandardBiMap<V, K> inverse) {
        this.inverse = inverse;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inverse.containsKey(value);
    }

    @Override
    public V put(K key, V value) {
        return this.putInBothMaps(key, value, false);
    }

    public V forcePut(K key, V value) {
        return this.putInBothMaps(key, value, true);
    }

    protected V putInBothMaps(K key, V value, boolean force) {
        boolean containedKey = this.containsKey(key);
        if (containedKey && Objects.equals(value, this.get(key))) {
            return value;
        }
        if (force) {
            this.inverse().remove(value);
        } else {
            StandardBiMap.checkArgument(!this.containsValue(value), "value already present: %s", value);
        }
        V oldValue = this.delegate.put(key, value);
        this.updateInverseMap(key, containedKey, oldValue, value);
        return oldValue;
    }

    protected void updateInverseMap(K key, boolean containedKey, V oldValue, V newValue) {
        if (containedKey) {
            this.removeFromInverseMap(oldValue);
        }
        this.inverse.delegate.put(newValue, key);
    }

    @Override
    public V remove(Object key) {
        return this.containsKey(key) ? (V)this.removeFromBothMaps(key) : null;
    }

    protected V removeFromBothMaps(Object key) {
        V oldValue = this.delegate.remove(key);
        this.removeFromInverseMap(oldValue);
        return oldValue;
    }

    protected void removeFromInverseMap(V oldValue) {
        this.inverse.delegate.remove(oldValue);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.inverse.delegate.clear();
    }

    public StandardBiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    public Set<K> keySet() {
        Set<K> result;
        if (this.keySet == null) {
            this.keySet = new AtomicReference();
        }
        if ((result = this.keySet.get()) == null) {
            this.keySet.set(new KeySet());
        }
        return this.keySet.get();
    }

    @Override
    public Set<V> values() {
        Set<V> result;
        if (this.valueSet == null) {
            this.valueSet = new AtomicReference();
        }
        if ((result = this.valueSet.get()) == null) {
            this.valueSet.set(new ValueSet());
        }
        return this.valueSet.get();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> result;
        if (this.entrySet == null) {
            this.entrySet = new AtomicReference();
        }
        if ((result = this.entrySet.get()) == null) {
            this.entrySet.set(new EntrySet());
        }
        return this.entrySet.get();
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new IllegalArgumentException(StandardBiMap.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append("]");
        }
        return builder.toString();
    }

    private static class Inverse<K, V>
    extends StandardBiMap<K, V> {
        private static final long serialVersionUID = 0L;

        private Inverse(Map<K, V> backward, StandardBiMap<V, K> forward) {
            super(backward, forward);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(this.inverse());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.setInverse((StandardBiMap)stream.readObject());
        }

        Object readResolve() {
            return this.inverse().inverse();
        }
    }

    private class EntrySet
    extends ForwardingSet<Map.Entry<K, V>> {
        final Set<Map.Entry<K, V>> esDelegate;

        private EntrySet() {
            this.esDelegate = StandardBiMap.this.delegate.entrySet();
        }

        @Override
        protected Set<Map.Entry<K, V>> delegate() {
            return this.esDelegate;
        }

        @Override
        public void clear() {
            StandardBiMap.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            if (!this.esDelegate.remove(object)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            StandardBiMap.this.inverse.delegate.remove(entry.getValue());
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            final Iterator iterator = this.esDelegate.iterator();
            return new Iterator<Map.Entry<K, V>>(){
                Map.Entry<K, V> entry;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    this.entry = (Map.Entry)iterator.next();
                    final Map.Entry finalEntry = this.entry;
                    return new ForwardingMapEntry<K, V>(){

                        @Override
                        protected Map.Entry<K, V> delegate() {
                            return finalEntry;
                        }

                        @Override
                        public V setValue(V value) {
                            StandardBiMap.checkState(EntrySet.this.contains(this), "entry no longer in map");
                            if (Objects.equals(value, this.getValue())) {
                                return value;
                            }
                            StandardBiMap.checkArgument(!StandardBiMap.this.containsValue(value), "value already present: %s", value);
                            Object oldValue = finalEntry.setValue(value);
                            StandardBiMap.checkState(Objects.equals(value, StandardBiMap.this.get(this.getKey())), "entry no longer in map");
                            StandardBiMap.this.updateInverseMap(this.getKey(), true, oldValue, value);
                            return oldValue;
                        }
                    };
                }

                @Override
                public void remove() {
                    iterator.remove();
                    StandardBiMap.this.removeFromInverseMap(this.entry.getValue());
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            int i = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                array[i++] = it.next();
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.size();
            if (array.length < size) {
                array = ArraysX.resize((Object[])array, (int)size);
            }
            int i = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                array[i++] = it.next();
            }
            if (array.length > size) {
                array[size] = null;
            }
            return array;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return this.delegate().contains((Map.Entry)o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!c.contains(iterator.next())) continue;
                iterator.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Iterator iterator = this.iterator();
            boolean modified = false;
            while (iterator.hasNext()) {
                if (c.contains(iterator.next())) continue;
                iterator.remove();
                modified = true;
            }
            return modified;
        }
    }

    private abstract class ForwardingMapEntry<K, V>
    implements Map.Entry<K, V> {
        private ForwardingMapEntry() {
        }

        protected abstract Map.Entry<K, V> delegate();

        @Override
        public K getKey() {
            return this.delegate().getKey();
        }

        @Override
        public V getValue() {
            return this.delegate().getValue();
        }

        @Override
        public V setValue(V value) {
            return this.delegate().setValue(value);
        }

        @Override
        public boolean equals(Object object) {
            return this.delegate().equals(object);
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }
    }

    private class ValueSet
    extends ForwardingSet<V> {
        final Set<V> valuesDelegate;

        private ValueSet() {
            this.valuesDelegate = StandardBiMap.this.inverse.keySet();
        }

        @Override
        protected Set<V> delegate() {
            return this.valuesDelegate;
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator iterator = StandardBiMap.this.delegate.values().iterator();
            return new Iterator<V>(){
                V valueToRemove;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public V next() {
                    this.valueToRemove = iterator.next();
                    return this.valueToRemove;
                }

                @Override
                public void remove() {
                    iterator.remove();
                    StandardBiMap.this.removeFromInverseMap(this.valueToRemove);
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[this.size()];
            int i = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                array[i++] = it.next();
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.size();
            if (array.length < size) {
                array = ArraysX.resize((Object[])array, (int)size);
            }
            int i = 0;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                array[i++] = it.next();
            }
            if (array.length > size) {
                array[size] = null;
            }
            return array;
        }

        public String toString() {
            Iterator iterator = this.iterator();
            if (!iterator.hasNext()) {
                return "[]";
            }
            StringBuilder builder = new StringBuilder();
            builder.append('[').append(iterator.next());
            while (iterator.hasNext()) {
                builder.append(", ").append(iterator.next());
            }
            return builder.append(']').toString();
        }
    }

    private class KeySet
    extends ForwardingSet<K>
    implements Set<K> {
        private KeySet() {
        }

        @Override
        protected Set<K> delegate() {
            return StandardBiMap.this.delegate.keySet();
        }

        @Override
        public void clear() {
            StandardBiMap.this.clear();
        }

        @Override
        public boolean remove(Object key) {
            if (!this.contains(key)) {
                return false;
            }
            StandardBiMap.this.removeFromBothMaps(key);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> keysToRemove) {
            boolean modified = false;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!keysToRemove.contains(iterator.next())) continue;
                iterator.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> keysToRetain) {
            Iterator iterator = this.iterator();
            boolean modified = false;
            while (iterator.hasNext()) {
                if (keysToRetain.contains(iterator.next())) continue;
                iterator.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public Iterator<K> iterator() {
            final Iterator iterator = StandardBiMap.this.delegate.entrySet().iterator();
            return new Iterator<K>(){
                Map.Entry<K, V> entry;

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public K next() {
                    this.entry = (Map.Entry)iterator.next();
                    return this.entry.getKey();
                }

                @Override
                public void remove() {
                    iterator.remove();
                    StandardBiMap.this.removeFromInverseMap(this.entry.getValue());
                }
            };
        }
    }

    private abstract class ForwardingSet<E>
    extends ForwardingCollection<E>
    implements Set<E> {
        private ForwardingSet() {
        }

        @Override
        protected abstract Set<E> delegate();

        @Override
        public boolean equals(Object object) {
            return object == this || this.delegate().equals(object);
        }

        @Override
        public int hashCode() {
            return this.delegate().hashCode();
        }
    }
}

