/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.ext.Uploadable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.impl.XulElement;

public class Dropupload
extends XulElement {
    private static final String DEFAULT_DETECTION = "browser";
    private int _maxsize;
    private int _maxFileCount = -1;
    private String _viewerClass;
    private String _detection = "browser";
    private String _content;
    private boolean _native;
    private Component _anchor;
    private String _suppressedErrors;
    private String _accept;

    public void setMaxsize(int value) {
        if (value < 0) {
            value = -1;
        }
        if (this._maxsize != value) {
            this._maxsize = value;
            this.setAttribute("org.zkoss.zk.upload.maxsize", value);
            this.smartUpdate("maxsize", this._maxsize);
        }
    }

    public int getMaxsize() {
        return this._maxsize;
    }

    public void setDetection(String value) {
        if (!this._detection.equals(value)) {
            this._detection = value;
            this.smartUpdate("detection", this._detection);
        }
    }

    public String getDetection() {
        return this._detection;
    }

    public void setViewerClass(String value) {
        if (value != null && value.length() == 0) {
            value = null;
        }
        if (!Objects.equals((Object)this._viewerClass, (Object)value)) {
            this._viewerClass = value;
            this.smartUpdate("viewerClass", this._viewerClass);
        }
    }

    public String getViewerClass() {
        return this._viewerClass;
    }

    public void setContent(String value) {
        if (value != null && !value.equals(this._content)) {
            this._content = value;
            this.smartUpdate("content", this._content);
        }
    }

    public String getContent() {
        return this._content;
    }

    public void setNative(boolean value) {
        if (value != this._native) {
            this._native = value;
            this.setAttribute("org.zkoss.zk.upload.native", value);
        }
    }

    public boolean isNative() {
        return this._native;
    }

    public void setAnchor(Component anchor) {
        if (anchor != this._anchor) {
            this._anchor = anchor;
            this.smartUpdate("anchorUuid", this._anchor != null ? this._anchor.getUuid() : "");
        }
    }

    public Component getAnchor() {
        return this._anchor;
    }

    public void setMaxFileCount(int maxFileCount) {
        if (maxFileCount < 0) {
            maxFileCount = -1;
        }
        if (maxFileCount != this._maxFileCount) {
            this._maxFileCount = maxFileCount;
            this.smartUpdate("maxFileCount", this._maxFileCount);
        }
    }

    public int getMaxFileCount() {
        return this._maxFileCount;
    }

    public String getSuppressedErrors() {
        return this._suppressedErrors;
    }

    public void setSuppressedErrors(String suppressedErrors) {
        if (!Objects.equals((Object)this._suppressedErrors, (Object)suppressedErrors)) {
            this._suppressedErrors = suppressedErrors;
            this.smartUpdate("suppressedErrors", suppressedErrors);
        }
    }

    public void setSuppressedErrors(Collection<Uploadable.Error> suppressedErrors) {
        this.setSuppressedErrors(suppressedErrors == null ? null : suppressedErrors.stream().map(Object::toString).collect(Collectors.joining("|")));
    }

    public void setAccept(String accept) {
        if (accept == null) {
            accept = "";
        }
        if (!accept.equals(this._accept)) {
            this._accept = accept;
            this.smartUpdate("accept", this._accept);
        }
    }

    public String getAccept() {
        return this._accept;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        if (this._maxsize == 0) {
            this._maxsize = this.getDesktop().getWebApp().getConfiguration().getMaxUploadSize();
        }
        super.renderProperties(renderer);
        if (!Objects.equals((Object)this._detection, (Object)DEFAULT_DETECTION)) {
            this.render(renderer, "detection", this._detection);
        }
        this.render(renderer, "maxsize", this._maxsize);
        this.render(renderer, "viewerClass", this._viewerClass);
        this.render(renderer, "content", this._content);
        if (this._anchor != null) {
            this.render(renderer, "anchorUuid", this._anchor.getUuid());
        }
        if (this._maxFileCount != -1) {
            this.render(renderer, "maxFileCount", this._maxFileCount);
        }
        this.render(renderer, "suppressedErrors", this._suppressedErrors);
        this.render(renderer, "accept", this._accept);
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onUpload".equals(cmd)) {
            Events.postEvent((Event)UploadEvent.getUploadEvent((String)cmd, (Component)this, (AuRequest)request));
        } else if ("onMaxFileCountExceed".equals(cmd)) {
            Events.postEvent((Event)new Event("onMaxFileCountExceed", (Component)this, request.getData().get("filesCount")));
        } else {
            super.service(request, everError);
        }
    }

    static {
        Dropupload.addClientEvent(Dropupload.class, (String)"onUpload", (int)0);
        Dropupload.addClientEvent(Dropupload.class, (String)"onMaxFileCountExceed", (int)0);
    }
}

