/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.impl.XulElement;

public class Cardlayout
extends XulElement {
    private String _orient = "horizontal";
    private int _selectedIndex = 0;

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isHorizontal() {
        return "horizontal".equals(this._orient);
    }

    public boolean isVertical() {
        return "vertical".equals(this._orient);
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public void setSelectedIndex(int value) {
        if (!this.isInitialized()) {
            this._selectedIndex = value;
            return;
        }
        int size = this.getChildren().size();
        if (value < 0 || value >= size) {
            throw new UiException("Out of bound: " + value + " while size=" + size);
        }
        if (this._selectedIndex != value) {
            this._selectedIndex = value;
            this.smartUpdate("selectedIndex", this._selectedIndex);
        }
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        boolean result = super.insertBefore(newChild, refChild);
        if (refChild != null && this.getChildren().indexOf(refChild) - 1 <= this._selectedIndex) {
            ++this._selectedIndex;
        }
        return result;
    }

    public boolean removeChild(Component child) {
        int index = this.getChildren().indexOf(child);
        boolean result = super.removeChild(child);
        if (result && index <= this._selectedIndex && this._selectedIndex == this.getChildren().size() && this._selectedIndex != 0) {
            --this._selectedIndex;
        }
        return result;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        if (!this.isInitialized()) {
            int size = this.getChildren().size();
            if (this._selectedIndex < 0 || this._selectedIndex >= size && (size != 0 || this._selectedIndex != 0)) {
                throw new UiException("Out of bound: " + this._selectedIndex + " while size=" + size);
            }
        }
        if (this.isVertical()) {
            this.render(renderer, "orient", this._orient);
        }
        if (this._selectedIndex != 0) {
            this.render(renderer, "selectedIndex", this._selectedIndex);
        }
        super.renderProperties(renderer);
    }

    public boolean previous() {
        if (this._selectedIndex == 0) {
            return false;
        }
        this.setSelectedIndex(this._selectedIndex - 1);
        return true;
    }

    public boolean next() {
        int size = this.getChildren().size();
        if (size == 0 || this._selectedIndex == size - 1) {
            return false;
        }
        this.setSelectedIndex(this._selectedIndex + 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onChange".equals(cmd)) {
            Map data = request.getData();
            this.disableClientUpdate(true);
            try {
                this.setSelectedIndex(Integer.parseInt(data.get("selectedIndex").toString()));
            }
            finally {
                this.disableClientUpdate(false);
                Events.postEvent((Event)Event.getEvent((AuRequest)request));
            }
        } else {
            super.service(request, everError);
        }
    }

    static {
        Cardlayout.addClientEvent(Cardlayout.class, (String)"onChange", (int)8193);
    }
}

