/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.websocket;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.mesg.Messages;
import org.zkoss.util.resource.Labels;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuWriter;
import org.zkoss.zk.au.RequestOutOfSequenceException;
import org.zkoss.zk.au.out.AuAlert;
import org.zkoss.zk.au.out.AuObsolete;
import org.zkoss.zk.au.out.AuSendRedirect;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.ActivationTimeoutException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.SimpleSession;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.http.ZKWebSocket;
import org.zkoss.zk.ui.impl.DesktopImpl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.URIInfo;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.au.websocket.RequestWrapper;
import org.zkoss.zkmax.au.websocket.ResponseWrapper;
import org.zkoss.zkmax.au.websocket.WSAuWriter;
import org.zkoss.zkmax.au.websocket.WebSocketServerPush;

public class WebSocketEndPoint
extends Endpoint
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(WebSocketEndPoint.class);
    private static final int PING_INTERVAL_SECONDS = Library.getIntProperty((String)"org.zkoss.zkmax.au.websocket.WebSocketEndPoint.pingIntervalSecond", (int)25);
    private static final int PING_TIMEOUT_SECONDS = Library.getIntProperty((String)"org.zkoss.zkmax.au.websocket.WebSocketEndPoint.pingTimeoutSecond", (int)20);
    private static ScheduledExecutorService PING_EXECUTOR;
    private transient HttpSession _httpSession;
    private transient HttpServletRequest _httpServletRequest;
    private transient HttpServletResponse _httpServletResponse;
    private transient WebSocketServerPush _wssp;
    private transient jakarta.websocket.Session _wsession;
    private transient Session _session;
    private int _maxInactiveInterval;
    private transient ServletContext _ctx;
    private transient Desktop _desktop;
    private StringBuilder _partialMessage = new StringBuilder();
    private final String PARTIAL_MESSAGE_PREFIX = "$ZKPARTIALMESSAGE$";
    private final String MAX_TEXT_MSG_BUFFER_SIZE = "$ZKMAXTEXTMSGBUFFERSIZE$";
    private final String PING_INTERVAL = "$ZK_PING_INTERVAL$";
    private final String PING_TIMEOUT = "$ZK_PING_TIMEOUT$";
    private transient ScheduledFuture<?> _pingIntervalSchedule;
    private transient ScheduledFuture<?> _pingTimeoutSchedule;
    private ReentrantLock _lock = new ReentrantLock();
    private boolean _useAsyncRemote = false;

    public void onOpen(final jakarta.websocket.Session wsession, EndpointConfig config) {
        Runtime.init((Object)this);
        try {
            ZKWebSocket.initZkDesktop((jakarta.websocket.Session)wsession, (EndpointConfig)config);
        }
        catch (IllegalStateException e) {
            try {
                wsession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION, "ZK Session cannot be null!"));
            }
            catch (IOException ex) {
                throw new IllegalStateException("ZK Session cannot be null!");
            }
            return;
        }
        Desktop desktop = ZKWebSocket.getDesktop((jakarta.websocket.Session)wsession);
        if (desktop != null) {
            this._desktop = desktop;
            this._wsession = wsession;
            this._session = desktop.getSession();
            this._httpServletRequest = (HttpServletRequest)desktop.getAttribute("org.zkoss.zkmax.ui.websocket.handshakeHttpServletRequest");
            this._httpServletResponse = (HttpServletResponse)desktop.getAttribute("org.zkoss.zkmax.ui.websocket.handshakeHttpServletResponse");
            this._httpSession = (HttpSession)this._session.getNativeSession();
            this._ctx = this._httpSession.getServletContext();
            this._maxInactiveInterval = this._httpSession.getMaxInactiveInterval();
            wsession.setMaxIdleTimeout(this._maxInactiveInterval == -1 ? -1L : (long)(this._maxInactiveInterval * 1000));
            this._wssp = (WebSocketServerPush)((DesktopImpl)desktop).getServerPush();
            if (this._wssp != null) {
                this._wssp.setWebSocketConnectionInfos(this, this._httpServletRequest);
            }
            desktop.getStorage().setItem("org.zkoss.zkmax.au.websocket.WebSocketServerPush", (Object)this);
            wsession.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

                public void onMessage(String message) {
                    try {
                        WebSocketEndPoint.this.resetPingTimeout(PING_INTERVAL_SECONDS + PING_TIMEOUT_SECONDS);
                        if (message != null && message.startsWith("$ZKPARTIALMESSAGE$")) {
                            WebSocketEndPoint.this._partialMessage.append(message.substring("$ZKPARTIALMESSAGE$".length()));
                        } else {
                            if (WebSocketEndPoint.this._partialMessage.length() > 0) {
                                message = WebSocketEndPoint.this._partialMessage.append(message).toString();
                                WebSocketEndPoint.this._partialMessage.setLength(0);
                            }
                            if ("$3$".equals(message)) {
                                WebSocketEndPoint.this.schedulePing();
                            } else {
                                WebSocketEndPoint.this.process(wsession, message);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new UiException((Throwable)e);
                    }
                }
            });
            try {
                JSONObject obj = new JSONObject();
                int bufferSize = wsession.getMaxTextMessageBufferSize();
                if (bufferSize == 0) {
                    bufferSize = 65536;
                    wsession.setMaxTextMessageBufferSize(bufferSize);
                }
                obj.put((Object)"$ZKMAXTEXTMSGBUFFERSIZE$", (Object)bufferSize);
                obj.put((Object)"$ZK_PING_INTERVAL$", (Object)PING_INTERVAL_SECONDS);
                obj.put((Object)"$ZK_PING_TIMEOUT$", (Object)PING_TIMEOUT_SECONDS);
                this.sendText(obj.toJSONString());
                this.schedulePing();
            }
            catch (IOException e) {
                throw new UiException((Throwable)e);
            }
        }
        try {
            wsession.close();
        }
        catch (IOException e) {
            log.warn("SERVER ERROR", (Throwable)e);
        }
    }

    private void schedulePing() {
        if (PING_EXECUTOR != null) {
            this._lock.lock();
            try {
                if (this._pingIntervalSchedule != null) {
                    this._pingIntervalSchedule.cancel(true);
                }
                this._pingIntervalSchedule = PING_EXECUTOR.schedule(() -> {
                    this._wsession.getAsyncRemote().sendText("$2$");
                    this.resetPingTimeout(PING_TIMEOUT_SECONDS);
                }, (long)PING_INTERVAL_SECONDS, TimeUnit.SECONDS);
            }
            finally {
                this._lock.unlock();
            }
        }
    }

    private void resetPingTimeout(int timeout) {
        if (PING_EXECUTOR != null) {
            this._lock.lock();
            try {
                if (this._pingTimeoutSchedule != null) {
                    this._pingTimeoutSchedule.cancel(true);
                }
                this._pingTimeoutSchedule = PING_EXECUTOR.schedule(() -> {
                    try {
                        this._wsession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Pong Timeout"));
                    }
                    catch (IOException e) {
                        log.error("Ping or close error", (Throwable)e);
                    }
                }, (long)timeout, TimeUnit.SECONDS);
            }
            finally {
                this._lock.unlock();
            }
        }
    }

    public void onClose(jakarta.websocket.Session wsession, CloseReason closeReason) {
        if (this._wssp != null) {
            this._wssp.stop();
            this._wssp.setWebSocketConnectionInfos(null, null);
            this._wssp = null;
        }
        this._lock.lock();
        try {
            if (this._pingIntervalSchedule != null) {
                this._pingIntervalSchedule.cancel(true);
                this._pingIntervalSchedule = null;
            }
            if (this._pingTimeoutSchedule != null) {
                this._pingTimeoutSchedule.cancel(true);
                this._pingTimeoutSchedule = null;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public void onError(jakarta.websocket.Session wsession, Throwable throwable) {
        WSAuWriter out = new WSAuWriter();
        if (throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException) {
            log.info("WebSocket Timeout");
        } else if (!(throwable instanceof IOException)) {
            try {
                out.open(this, null);
                out.close(this, null);
            }
            catch (IOException e) {
                throw new UiException((Throwable)e);
            }
            finally {
                log.warn("SERVER ERROR", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(jakarta.websocket.Session wsession, String message) throws IOException, ServletException {
        LinkedList<AuRequest> aureqs;
        JSONObject req;
        if ("$ZKWS_READY$".equals(message)) {
            this._wssp.setReady(true);
            return;
        }
        Desktop desktop = ZKWebSocket.getDesktop((jakarta.websocket.Session)wsession);
        if (desktop == null) {
            log.warn("Desktop already destroyed");
            this.responseDesktopTimeout(message);
            wsession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Desktop destroyed"));
            return;
        }
        this._httpSession.setMaxInactiveInterval(this._maxInactiveInterval);
        try {
            String cmdId;
            req = (JSONObject)JSONValue.parse((String)message);
            if (Boolean.TRUE.equals(req.get((Object)"$ZKWS_ECHO$"))) {
                this.sendText("$ZKWS_ECHO$");
                return;
            }
            JSONObject reqParams = (JSONObject)req.get((Object)"content");
            aureqs = new LinkedList<AuRequest>();
            int j = 0;
            while ((cmdId = (String)reqParams.get((Object)("cmd_" + j))) != null) {
                String uuid = (String)reqParams.get((Object)("uuid_" + j));
                String data = (String)reqParams.get((Object)("data_" + j));
                Map decData = (Map)JSONValue.parse((String)data);
                aureqs.add(uuid == null || uuid.length() == 0 ? new AuRequest(desktop, cmdId, decData) : new AuRequest(desktop, uuid, cmdId, decData));
                ++j;
            }
        }
        catch (UnsupportedEncodingException e) {
            log.warn("", (Throwable)e);
            this.responseError(Exceptions.getMessage((Throwable)e));
            return;
        }
        RequestWrapper request = new RequestWrapper(this._httpServletRequest, (Map)req.get((Object)"header"));
        WebManager.setDesktop((HttpServletRequest)request, (Desktop)desktop);
        String sid = req.get((Object)"sid").toString();
        try {
            Integer.parseInt(sid);
        }
        catch (NumberFormatException e) {
            this.responseError("Illegal message");
            return;
        }
        WebApp wapp = desktop.getWebApp();
        Configuration config = wapp.getConfiguration();
        boolean keepAlive = false;
        try {
            boolean timerKeepAlive = config.isTimerKeepAlive();
            for (AuRequest aureq : aureqs) {
                String cmdId = aureq.getCommand();
                keepAlive = (timerKeepAlive || !"onTimer".equals(cmdId)) && !"dummy".equals(cmdId);
                if (!keepAlive) continue;
                break;
            }
        }
        catch (Throwable ex) {
            log.warn("", ex);
            this.responseError(Exceptions.getMessage((Throwable)ex));
            return;
        }
        if (aureqs.isEmpty()) {
            String errmsg = "Illegal request: cmd required";
            log.debug("Illegal request: cmd required");
            this.responseError("Illegal request: cmd required");
            return;
        }
        Object old = null;
        try {
            ((SimpleSession)this._session).notifyClientRequest(keepAlive);
            WSAuWriter out = new WSAuWriter();
            ResponseWrapper response = new ResponseWrapper(this._httpServletResponse);
            old = I18Ns.setup((Session)this._session, (ServletRequest)request, (ServletResponse)response, (String)"UTF-8");
            ExecutionImpl exec = new ExecutionImpl(this._ctx, (HttpServletRequest)request, (HttpServletResponse)response, desktop, null);
            exec.setRequestId(sid);
            SessionsCtrl.setCurrent((Session)this._session);
            try {
                out.open(this, (Object)response);
                response.setHeader("ZK-SID", sid);
                response.setStatus(200);
                ((WebAppCtrl)wapp).getUiEngine().execUpdate((Execution)exec, aureqs, (AuWriter)out);
            }
            catch (ActivationTimeoutException ex) {
                log.warn(ex.getMessage());
                response.setIntHeader("ZK-Error", 5502);
            }
            catch (RequestOutOfSequenceException ex) {
                log.warn(ex.getMessage());
                response.setIntHeader("ZK-Error", 5501);
            }
            catch (Exception e) {
                response.setStatus(500);
            }
            finally {
                out.close(this, (Object)response);
            }
        }
        catch (Throwable throwable) {
            SessionsCtrl.setCurrent((Session)null);
            if (((SimpleSession)this._session).isInvalidated()) {
                wsession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Idle Timeout"));
            }
            I18Ns.cleanup((ServletRequest)request, old);
            request.removeAllAttributes();
            throw throwable;
        }
        SessionsCtrl.setCurrent((Session)null);
        if (((SimpleSession)this._session).isInvalidated()) {
            wsession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Idle Timeout"));
        }
        I18Ns.cleanup((ServletRequest)request, (Object)old);
        request.removeAllAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseDesktopTimeout(String message) throws ServletException, IOException {
        JSONObject req = (JSONObject)JSONValue.parse((String)message);
        RequestWrapper request = new RequestWrapper(this._httpServletRequest, (Map)req.get((Object)"header"));
        WSAuWriter out = new WSAuWriter();
        ResponseWrapper response = new ResponseWrapper(this._httpServletResponse);
        WebApp wapp = WebApps.getCurrent();
        try {
            AuSendRedirect resp;
            String uri;
            URIInfo ui = wapp != null ? wapp.getConfiguration().getTimeoutURI(null) : null;
            String string = uri = ui != null ? ui.uri : null;
            if (uri != null) {
                if (!uri.isEmpty()) {
                    uri = Encodes.encodeURL((ServletContext)wapp.getServletContext(), (ServletRequest)request, (ServletResponse)response, (String)uri);
                }
                resp = new AuSendRedirect(uri, null);
            } else {
                String key;
                String dtid;
                String msg = wapp != null ? wapp.getConfiguration().getTimeoutMessage(null) : null;
                String string2 = dtid = this._desktop != null ? this._desktop.getId() : null;
                if (msg != null && msg.startsWith("label:") && (msg = Labels.getLabel((String)(key = msg.substring(6)), (Object[])new Object[]{dtid})) == null) {
                    log.warn("Label not found, {}", (Object)key);
                }
                if (msg == null) {
                    msg = Messages.get((int)MZk.UPDATE_OBSOLETE_PAGE, (Object)dtid);
                }
                resp = new AuObsolete(dtid, msg);
            }
            response.setHeader("Location", uri == null ? "" : uri);
            response.setStatus(302);
            out.open(this, (Object)response);
            out.write((AuResponse)resp);
        }
        finally {
            out.close((Object)request, (Object)response);
        }
    }

    private void responseError(String errmsg) throws IOException {
        WSAuWriter out = new WSAuWriter();
        out.open(this, null);
        out.write((AuResponse)new AuAlert(errmsg, true));
        out.close(this, null);
    }

    protected void sendText(String text) throws IOException {
        this._lock.lock();
        try {
            if (this._wsession.isOpen()) {
                if (this._useAsyncRemote) {
                    this._wsession.getAsyncRemote().sendText(text);
                } else {
                    try {
                        this._wsession.getBasicRemote().sendText(text);
                    }
                    catch (IllegalStateException e) {
                        this._wsession.getAsyncRemote().sendText(text);
                        this._useAsyncRemote = true;
                    }
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    protected void setWebSocketServerPush(WebSocketServerPush wssp) {
        this._wssp = wssp;
    }

    static void shutdownPingExecutor() {
        PING_EXECUTOR.shutdown();
    }

    static {
        if (PING_INTERVAL_SECONDS > 0) {
            PING_EXECUTOR = Executors.newScheduledThreadPool(Library.getIntProperty((String)"org.zkoss.zkmax.au.websocket.WebSocketEndPoint.pingSchedulingPoolSize", (int)1));
        }
    }
}

