/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.xel.mvel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.integration.VariableResolver;
import org.mvel.integration.impl.BaseVariableResolverFactory;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.util.Evaluators;

class XelMVELResolver
extends BaseVariableResolverFactory {
    private final XelContext _ctx;
    private Map<String, Object> _values;

    XelMVELResolver(XelContext ctx) {
        this._ctx = ctx;
    }

    public VariableResolver getVariableResolver(String name) {
        if (this._values != null && this._values.containsKey(name) || Evaluators.resolveVariable((XelContext)this._ctx, null, (Object)name) != null) {
            return (VariableResolver)(this.variableResolvers != null && this.variableResolvers.containsKey(name) ? this.variableResolvers.get(name) : new VarResolver(name));
        }
        return this.nextFactory != null ? this.nextFactory.getVariableResolver(name) : null;
    }

    public boolean isResolveable(String name) {
        return this.variableResolvers != null && this.variableResolvers.containsKey(name) || this._values != null && this._values.containsKey(name) || Evaluators.resolveVariable((XelContext)this._ctx, null, (Object)name) != null || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    public Set<String> getKnownVariables() {
        if (this.nextFactory != null) {
            return this.nextFactory.getKnownVariables();
        }
        return Collections.emptySet();
    }

    public VariableResolver createVariable(String name, Object value) {
        VariableResolver vr = this.getVariableResolver(name);
        if (vr == null) {
            vr = new VarResolver(name);
        }
        vr.setValue(value);
        return vr;
    }

    public VariableResolver createVariable(String name, Object value, Class type) {
        VariableResolver vr = this.getVariableResolver(name);
        if (vr != null && vr.getType() != null) {
            throw new CompileException("variable already defined within scope: " + String.valueOf(vr.getType()) + " " + name);
        }
        vr = new VarResolver(name, type);
        this.addResolver(name, vr);
        vr.setValue(value);
        return vr;
    }

    private void addResolver(String name, VariableResolver vr) {
        if (this.variableResolvers == null) {
            this.variableResolvers = new HashMap();
        }
        this.variableResolvers.put(name, vr);
    }

    private class VarResolver
    implements VariableResolver {
        private final String _name;
        private Class<?> _type;

        private VarResolver(String name) {
            this._name = name;
        }

        private VarResolver(String name, Class<?> type) {
            this._name = name;
            this._type = type;
        }

        public String getName() {
            return this._name;
        }

        public Class getType() {
            return this._type;
        }

        public void setStaticType(Class type) {
            this._type = type;
        }

        public int getFlags() {
            return 0;
        }

        public Object getValue() {
            Object o;
            if (XelMVELResolver.this._values != null && ((o = XelMVELResolver.this._values.get(this._name)) != null || XelMVELResolver.this._values.containsKey(this._name))) {
                return o;
            }
            return Evaluators.resolveVariable((XelContext)XelMVELResolver.this._ctx, null, (Object)this._name);
        }

        public void setValue(Object value) {
            if (this._type != null && value != null && value.getClass() != this._type) {
                if (!DataConversion.canConvert(this._type, value.getClass())) {
                    throw new CompileException("cannot assign " + value.getClass().getName() + " to type: " + this._type.getName());
                }
                try {
                    value = DataConversion.convert((Object)value, this._type);
                }
                catch (Exception e) {
                    throw new CompileException("cannot convert value of " + value.getClass().getName() + " to: " + this._type.getName());
                }
            }
            if (XelMVELResolver.this._values == null) {
                XelMVELResolver.this._values = new HashMap<String, Object>();
            }
            XelMVELResolver.this._values.put(this._name, value);
        }
    }
}

