/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.util;

import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.au.out.AuLoadingbar;

public class LoadingbarControl {
    private String _id;
    private Integer _animationSpeed;

    protected LoadingbarControl(String id, Integer animationSpeed) {
        this._id = id;
        this._animationSpeed = animationSpeed;
    }

    public String getId() {
        return this._id;
    }

    private static void response(AuResponse response) {
        Runtime.init((Object)response);
        Executions.getCurrent().addAuResponse(response);
    }

    public void start() {
        this.start(0, "top", false);
    }

    public void start(int value) {
        this.start(value, "top", false);
    }

    public void start(int value, String position) {
        this.start(value, position, false);
    }

    public void start(int value, String position, boolean indeterminate) {
        if (value < 0 || value > 100) {
            throw new WrongValueException("value should be in range 0~100");
        }
        if (!"top".equals(position) && !"bottom".equals(position)) {
            throw new WrongValueException("position should be top or bottom");
        }
        LoadingbarControl.response(new AuLoadingbar(this._id, value, position, indeterminate, this._animationSpeed));
    }

    public void update(int value) {
        if (value < 0 || value > 100) {
            throw new WrongValueException("value should be in range 0~100");
        }
        this.update(value, null);
    }

    public void update(boolean indeterminate) {
        this.update(null, indeterminate);
    }

    private void update(Integer value, Boolean indeterminate) {
        LoadingbarControl.response(new AuLoadingbar(this._id, value, null, indeterminate, this._animationSpeed));
    }

    public void finish() {
        this.update(100);
    }
}

