/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.Rowchildren;
import org.zkoss.zul.impl.XulElement;

public class Rowlayout
extends XulElement {
    public static int DEFAULT_NUM_COLUMNS = 12;
    public static String DEFAULT_SPACING = "0.333333333333333";
    private int _ncols = DEFAULT_NUM_COLUMNS;
    private String _spacing = DEFAULT_SPACING;

    public int getNcols() {
        return this._ncols;
    }

    public void setNcols(int ncols) {
        if (ncols < 1) {
            ncols = 1;
        }
        if (ncols != this._ncols) {
            this._ncols = ncols;
            this.smartUpdate("ncols", ncols);
        }
    }

    public String getSpacing() {
        return this._spacing;
    }

    public void setSpacing(String value) {
        double spacing = 0.0;
        int slash = -1;
        try {
            spacing = value.endsWith("%") ? Double.parseDouble(value.replace("%", "")) / 100.0 : ((slash = value.indexOf(47)) > 0 ? (double)Integer.parseInt(value.substring(0, slash)) / (double)Integer.parseInt(value.substring(slash + 1)) : Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(value + " cannot be accepted as spacing");
        }
        if (spacing < 0.0) {
            spacing = 0.0;
        }
        if (!Objects.equals((Object)spacing, (Object)Double.valueOf(this._spacing))) {
            this._spacing = String.valueOf(spacing);
            this.smartUpdate("spacing", spacing);
        }
    }

    public void setWidth(String width) {
        throw new UnsupportedOperationException("readonly");
    }

    public void setHflex(String hflex) {
        throw new UnsupportedOperationException("readonly");
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        if (this._ncols != DEFAULT_NUM_COLUMNS) {
            this.render(renderer, "ncols", this._ncols);
        }
        if (!DEFAULT_SPACING.equals(this._spacing)) {
            this.render(renderer, "spacing", this._spacing);
        }
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Rowchildren)) {
            throw new UiException("Unsupported child for Rowlayout: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, refChild);
    }
}

