/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zkmax.zul.Organigram;
import org.zkoss.zkmax.zul.Orgitem;
import org.zkoss.zul.impl.XulElement;

public class Orgchildren
extends XulElement {
    private int _visibleItemCount;

    public Organigram getOrganigram() {
        Orgchildren p = this;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Organigram)) continue;
            return (Organigram)((Object)p);
        }
        return null;
    }

    public Collection<Orgitem> getItems() {
        return new AbstractCollection<Orgitem>(){

            @Override
            public int size() {
                return Orgchildren.this.getItemCount();
            }

            @Override
            public boolean isEmpty() {
                return Orgchildren.this.getChildren().isEmpty();
            }

            @Override
            public Iterator<Orgitem> iterator() {
                return new Iterator<Orgitem>(){
                    private final Iterator<Component> _it;
                    private Iterator<Orgitem> _sub;
                    {
                        this._it = Orgchildren.this.getChildren().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this._sub != null && this._sub.hasNext() || this._it.hasNext();
                    }

                    @Override
                    public Orgitem next() {
                        if (this._sub != null && this._sub.hasNext()) {
                            return this._sub.next();
                        }
                        Orgitem item = (Orgitem)this._it.next();
                        Orgchildren children = item.getOrgchildren();
                        this._sub = children != null ? children.getItems().iterator() : null;
                        return item;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("readonly");
                    }
                };
            }
        };
    }

    public int getItemCount() {
        int sz = 0;
        for (Orgitem item : this.getChildren()) {
            Orgchildren children = item.getOrgchildren();
            if (children != null) {
                sz += children.getItemCount();
            }
            ++sz;
        }
        return sz;
    }

    public int getVisibleItemCount() {
        return this._visibleItemCount;
    }

    void addVisibleItemCount(int count) {
        if (count == 0) {
            return;
        }
        Component parent = this.getParent();
        if (parent instanceof Orgitem && ((Orgitem)parent).isOpen()) {
            ((Orgitem)parent).addVisibleItemCount(count);
        }
        this._visibleItemCount += count;
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        this.addVisibleItemCount(((Orgitem)child).getVisibleItemCount());
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        this.addVisibleItemCount(-((Orgitem)child).getVisibleItemCount());
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Organigram) && !(parent instanceof Orgitem)) {
            throw new UiException("Wrong parent: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    public void setParent(Component parent) {
        Organigram organigram;
        Component oldp = this.getParent();
        if (oldp == parent) {
            return;
        }
        Organigram oldOrganigram = oldp != null ? this.getOrganigram() : null;
        super.setParent(parent);
        if (oldOrganigram != null) {
            oldOrganigram.onOrgchildrenRemoved(this);
        }
        if (parent != null && (organigram = this.getOrganigram()) != null) {
            organigram.onOrgchildrenAdded(this);
        }
    }

    public void beforeChildAdded(Component child, Component insertBefore) {
        if (!(child instanceof Orgitem)) {
            throw new UiException("Unsupported child for orgchildren: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, insertBefore);
    }

    public String getZclass() {
        return this._zclass == null ? "z-orgchildren" : this._zclass;
    }

    public void setHflex(String flex) {
    }

    public void setWidth(String width) {
    }
}

