/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.comet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zkex.ui.comet.CometServerPush;
import org.zkoss.zkmax.ui.comet.CometAsyncServlet;
import org.zkoss.zkmax.ui.http.FacadeHttpServletRequest;

public class CometServerPush
extends org.zkoss.zkex.ui.comet.CometServerPush {
    private static final Logger log = LoggerFactory.getLogger(CometServerPush.class);
    private boolean _async;

    public CometServerPush() {
        this(CometServerPush.defaultAsync());
    }

    private static final boolean defaultAsync() {
        String PROP = "org.zkoss.zkmax.ui.comet.async.disabled";
        String s = Library.getProperty((String)"org.zkoss.zkmax.ui.comet.async.disabled");
        boolean disabled = "true".equals(s);
        boolean servlet3 = Servlets.isServlet3();
        if (!disabled && s != null && !servlet3 && log.isWarnEnabled()) {
            log.warn("org.zkoss.zkmax.ui.comet.async.disabled ignored, since the server doesn't support Servlet 3");
        }
        return !disabled && servlet3;
    }

    public CometServerPush(boolean async) {
        this._async = async;
    }

    public void start(Desktop desktop) {
        if (this._async && !CometAsyncServlet.isInstalled(desktop.getWebApp().getServletContext())) {
            if (log.isWarnEnabled()) {
                log.warn("The asynchronous comet not used because CometAsyncServlet failed to install");
            }
            this._async = false;
        }
        super.start(desktop);
    }

    protected String getStartScript() {
        if (!this._async) {
            return super.getStartScript();
        }
        return this.getStartScript("zkmax");
    }

    protected String getStopScript() {
        if (!this._async) {
            return super.getStopScript();
        }
        return "zk.afterLoad('zkex.cmsp', function(){zkmax.cmsp.stop('" + this.getDesktop().getId() + "');});";
    }

    protected void onStart() {
        if (!this._async) {
            super.onStart();
            return;
        }
    }

    protected synchronized boolean setBusy() {
        return super.setBusy();
    }

    protected void processRequest(Execution exec, CometServerPush.AsyncInfo ai) throws IOException {
        super.processRequest(exec, ai);
    }

    protected void beforeUpdate(CometServerPush.ThreadInfo info) {
        if (this._async) {
            Execution old = info.getExecution();
            Desktop desktop = old.getDesktop();
            info.setActive((Execution)new ExecutionImpl(desktop.getWebApp().getServletContext(), (HttpServletRequest)new FacadeHttpServletRequest((HttpServletRequest)old.getNativeRequest()), (HttpServletResponse)old.getNativeResponse(), desktop, null));
        }
    }
}

