/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.theme;

import jakarta.servlet.ServletRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.lang.Library;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.theme.StandardTheme;
import org.zkoss.web.theme.Theme;
import org.zkoss.zul.theme.DesktopThemeRegistry;

public class ResponsiveThemeRegistry
extends DesktopThemeRegistry {
    private Map<String, Theme> _registry = new HashMap<String, Theme>();
    public static final String TABLET_PREFIX = "tablet:";
    private static final int TABLET_PREFIX_LENGTH = "tablet:".length();
    private static final String TABLET_UI_DISABLED_KEY = "org.zkoss.zkmax.tablet.ui.disabled";

    public ResponsiveThemeRegistry() {
        this._registry.put("iceblue", (Theme)new StandardTheme());
    }

    public boolean register(Theme theme) {
        boolean success = false;
        String themeName = theme.getName();
        if (themeName.startsWith(TABLET_PREFIX) && themeName.length() > TABLET_PREFIX_LENGTH) {
            themeName = themeName.substring(TABLET_PREFIX_LENGTH);
            theme.setName(themeName);
            this._registry.put(themeName, theme);
            success = true;
        } else {
            success = super.register(theme);
        }
        return success;
    }

    public boolean deregister(Theme theme) {
        boolean success = false;
        String themeName = theme.getName();
        if (themeName.startsWith(TABLET_PREFIX) && themeName.length() > TABLET_PREFIX_LENGTH) {
            themeName = themeName.substring(TABLET_PREFIX_LENGTH);
            this._registry.remove(themeName);
            success = true;
        } else {
            success = super.deregister(theme);
        }
        return success;
    }

    private boolean isMobile() {
        Double number = Servlets.getBrowser((ServletRequest)ServletFns.getCurrentRequest(), (String)"mobile");
        return number != null && number > 0.0;
    }

    private boolean isTabletThemeSupported() {
        return this.isMobile() && "false".equals(Library.getProperty((String)TABLET_UI_DISABLED_KEY, (String)"false"));
    }

    public Theme[] getThemes() {
        if (this.isTabletThemeSupported()) {
            Collection<Theme> themes = this._registry.values();
            return themes.toArray(new Theme[themes.size()]);
        }
        return super.getThemes();
    }

    public boolean hasTheme(String themeName) {
        if (themeName == null) {
            return false;
        }
        if (this.isTabletThemeSupported()) {
            return this._registry.containsKey(themeName);
        }
        return super.hasTheme(themeName);
    }

    public Theme getTheme(String themeName) {
        if (this.isTabletThemeSupported()) {
            return this._registry.get(themeName);
        }
        return super.getTheme(themeName);
    }
}

