/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRPptxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.Locales;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.zul.JasperreportExporterFactory;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.impl.Utils;

public class Jasperreport
extends Iframe {
    private static final Logger log = LoggerFactory.getLogger(Jasperreport.class);
    private static final long serialVersionUID = 20080117L;
    private static final String TASK_PDF = "pdf";
    private static final String TASK_XML = "xml";
    private static final String TASK_HTML = "html";
    private static final String TASK_RTF = "rtf";
    private static final String TASK_XLS = "xls";
    private static final String TASK_JXL = "jxl";
    private static final String TASK_CSV = "csv";
    private static final String TASK_ODT = "odt";
    private static final String TASK_XLSX = "xlsx";
    private static final String TASK_DOCX = "docx";
    private static final String TASK_GRAPHICS_2D = "graphic2d";
    private static final String TASK_ODS = "ods";
    private static final String TASK_PPTX = "pptx";
    private static final String TASK_TEXT = "txt";
    private static final String TASK_XHTML = "xhtml";
    private static final String IMAGE_DIR = "img/";
    private String _source;
    private Map<String, Object> _parameters;
    private JRDataSource _datasource;
    private Connection _connection;
    private int _medver;
    private String _type = "pdf";
    private Locale _locale;
    private transient Map _imageMap;
    private transient Media _report;
    private Media _media;
    private boolean _hibernate;
    private String _exportName = "report";
    private JasperreportExporterFactory _jasperreportExporterFactory;

    public Jasperreport() {
        this.setHeight("100%");
        this.setWidth("100%");
    }

    public Jasperreport(String src) {
        this();
        this.setSrc(src);
    }

    public String getSrc() {
        return this._source;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._source, (Object)src)) {
            this._source = src;
            this.updateContent();
        }
    }

    public void setContent(Media media) {
        if (this._source != null || media != this._media) {
            this._media = media;
            this._source = null;
            this.updateContent();
        }
    }

    public Map<String, Object> getParameters() {
        return this._parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        if (!Objects.equals(this._parameters, parameters)) {
            this._parameters = parameters;
            this.updateContent();
        }
    }

    public void setHibernate(boolean hibernate) {
        if (this._hibernate != hibernate) {
            this._hibernate = hibernate;
            this.invalidate();
        }
    }

    public boolean isHibernate() {
        return this._hibernate;
    }

    public JRDataSource getDatasource() {
        return this._datasource;
    }

    public void setDatasource(JRDataSource dataSource) {
        if (!Objects.equals((Object)this._datasource, (Object)dataSource)) {
            this._datasource = dataSource;
            this.updateContent();
        }
    }

    public void setDataConnection(Connection connection) {
        if (!Objects.equals((Object)this._connection, (Object)connection)) {
            this._connection = connection;
            this.invalidate();
        }
    }

    public Connection getDataConnection() {
        return this._connection;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        if (type == null) {
            type = TASK_PDF;
        }
        if (!Objects.equals((Object)this._type, (Object)type)) {
            this._type = type;
            this.updateContent();
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        if (!Objects.equals((Object)this._locale, (Object)locale)) {
            this._locale = locale;
            this.updateContent();
        }
    }

    public String getExportName() {
        return this._exportName;
    }

    public void setExportName(String exportName) {
        if (Strings.isEmpty((String)exportName)) {
            throw new IllegalArgumentException("exportName can not be empty or null.");
        }
        if (!Objects.equals((Object)this._exportName, (Object)exportName)) {
            this._exportName = exportName;
        }
    }

    public void setJasperreporteExporterFactory(JasperreportExporterFactory factory) {
        if (!Objects.equals((Object)this._jasperreportExporterFactory, (Object)factory)) {
            this._jasperreportExporterFactory = factory;
            this.updateContent();
        }
    }

    public void setJasperreporteExporterFactory(String clsnm) throws NoSuchMethodException, InstantiationException, InvocationTargetException, ClassNotFoundException, IllegalAccessException {
        if (clsnm != null) {
            this.setJasperreporteExporterFactory((JasperreportExporterFactory)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public JasperreportExporterFactory getJasperreporteExporterFactory() {
        return this._jasperreportExporterFactory;
    }

    private void updateContent() {
        this._report = null;
        this.smartUpdate("src", new EncodedSrc());
    }

    protected String getEncodedSrc() {
        if (this._media == null && this._source == null) {
            return "data:image/gif;base64,R0lGODlhAQABAIAAAP///////yH5BAUUAAEALAAAAAABAAEAAAICTAEAOw==";
        }
        StringTokenizer st = new StringTokenizer(this._source != null ? this._source : this._media.getName(), ".");
        return Utils.getDynamicMediaURI((AbstractComponent)this, (int)this._medver++, (String)st.nextToken(), (String)(this._type.equals(TASK_JXL) ? TASK_XLS : this._type));
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    private Media doReport() {
        if (this._report != null) {
            return this._report;
        }
        InputStream is = null;
        try {
            JRExporter exporter;
            Map<String, Object> params;
            Runtime.init((Object)this);
            Execution exec = Executions.getCurrent();
            if (this._media == null) {
                is = exec.getDesktop().getWebApp().getResourceAsStream(exec.toAbsoluteURI(this._source, false));
                if (is == null && (is = Classes.getContextClassLoader(Jasperreport.class).getResourceAsStream(this._source)) == null) {
                    File fl = new File(this._source);
                    if (!fl.exists()) {
                        throw new RuntimeException("resource for " + this._source + " not found.");
                    }
                    is = new FileInputStream(fl);
                }
            } else {
                is = this._media.getStreamData();
            }
            Map exportPara = null;
            if (this._parameters == null) {
                params = new HashMap<String, Object>();
            } else {
                params = this._parameters;
                exportPara = (Map)params.remove("exportParameter");
            }
            if (this._locale != null) {
                params.put("REPORT_LOCALE", this._locale);
            } else if (!params.containsKey("REPORT_LOCALE")) {
                params.put("REPORT_LOCALE", Locales.getCurrent());
            }
            JasperPrint jasperPrint = this._connection == null ? (this._hibernate ? JasperFillManager.fillReport((InputStream)is, params) : JasperFillManager.fillReport((InputStream)is, params, (JRDataSource)(this._datasource != null ? this._datasource : new JREmptyDataSource()))) : JasperFillManager.fillReport((InputStream)is, params, (Connection)this._connection);
            JasperreportExporterFactory factory = this._jasperreportExporterFactory;
            if (factory == null) {
                factory = new JasperreporteExporterImpl();
            }
            if ((exporter = factory.getJRExporter(this._type)) == null) {
                throw new UiException("Type: " + this._type + " is not supported ");
            }
            ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            if (exportPara != null) {
                for (Object key : exportPara.keySet()) {
                    Object val = exportPara.get(key);
                    if (!(key instanceof JRExporterParameter)) continue;
                    exporter.setParameter((JRExporterParameter)key, val);
                }
            }
            if (!TASK_GRAPHICS_2D.equals(this._type)) {
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)arrayOutputStream);
                exporter.exportReport();
                this._imageMap = (Map)exporter.getParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP);
            } else {
                int imageWidth = 600;
                int imageHeight = 800;
                int imageType = 4;
                if (exportPara != null) {
                    if (exportPara.containsKey("imageWidth")) {
                        imageWidth = Integer.parseInt((String)exportPara.get("imageWidth"));
                    }
                    if (exportPara.containsKey("imageHeight")) {
                        imageHeight = Integer.parseInt((String)exportPara.get("imageHeight"));
                    }
                    if (exportPara.containsKey("imageType")) {
                        imageType = Integer.parseInt((String)exportPara.get("imageType"));
                    }
                }
                BufferedImage image = new BufferedImage(imageWidth, imageHeight, imageType);
                Graphics2D g2d = image.createGraphics();
                exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)g2d);
                exporter.exportReport();
                g2d.dispose();
                ImageIO.write((RenderedImage)image, "png", arrayOutputStream);
            }
            arrayOutputStream.close();
            String format = factory.getFormat(this._type);
            this._report = new AMedia(this._exportName + "." + format, format, factory.getContentType(this._type), arrayOutputStream.toByteArray());
            AMedia aMedia = this._report;
            return aMedia;
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.warn("Ignored: unable to close", (Throwable)e);
                }
            }
            if (this._connection != null) {
                try {
                    if (!this._connection.isClosed()) {
                        this._connection.close();
                    }
                }
                catch (SQLException e) {
                    log.warn("Ignored: unable to close JDBC connection", (Throwable)e);
                }
            }
        }
    }

    public Media getReport() {
        return this.doReport();
    }

    private AMedia getImage(String imageName) {
        if (this._imageMap == null) {
            log.warn("The image map not ready, " + imageName);
            return null;
        }
        byte[] imageBytes = (byte[])this._imageMap.get(imageName);
        return new AMedia(imageName, "", "image/gif", imageBytes);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)this);
        super.renderProperties(renderer);
    }

    private class EncodedSrc
    implements DeferredValue {
        private EncodedSrc() {
        }

        public Object getValue() {
            return Jasperreport.this.getEncodedSrc();
        }
    }

    public class JasperreporteExporterImpl
    implements JasperreportExporterFactory {
        @Override
        public JRExporter getJRExporter(String type) {
            JRPdfExporter result = null;
            if (Jasperreport.TASK_PDF.equals(type)) {
                result = new JRPdfExporter();
            } else if (Jasperreport.TASK_XML.equals(type)) {
                result = new JRXmlExporter();
            } else if (Jasperreport.TASK_HTML.equals(type)) {
                result = new HtmlExporter();
            } else if (Jasperreport.TASK_RTF.equals(type)) {
                result = new JRRtfExporter();
            } else if (Jasperreport.TASK_XLS.equals(type)) {
                result = new JRXlsExporter();
            } else if (Jasperreport.TASK_JXL.equals(type)) {
                result = new JRXlsExporter();
            } else if (Jasperreport.TASK_CSV.equals(type)) {
                result = new JRCsvExporter();
            } else if (Jasperreport.TASK_ODT.equals(type)) {
                result = new JROdtExporter();
            } else if (Jasperreport.TASK_XLSX.equals(type)) {
                result = new JRXlsxExporter();
            } else if (Jasperreport.TASK_DOCX.equals(type)) {
                result = new JRDocxExporter();
            } else if (Jasperreport.TASK_GRAPHICS_2D.equals(type)) {
                try {
                    result = new JRGraphics2DExporter();
                }
                catch (JRException e) {
                    throw new UiException("failed to init JRGraphics2DExporter .");
                }
            } else if (Jasperreport.TASK_ODS.equals(type)) {
                result = new JROdsExporter();
            } else if (Jasperreport.TASK_PPTX.equals(type)) {
                result = new JRPptxExporter();
            } else if (Jasperreport.TASK_TEXT.equals(type)) {
                result = new JRTextExporter();
            } else if (Jasperreport.TASK_XHTML.equals(type)) {
                result = new HtmlExporter();
            }
            if (result != null) {
                this.setupParam((JRExporter)result, type);
            }
            return result;
        }

        void setupParam(JRExporter exporter, String type) {
            if (Jasperreport.TASK_HTML.equals(type)) {
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, new HashMap());
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)Jasperreport.IMAGE_DIR);
            } else if (Jasperreport.TASK_JXL.equals(type)) {
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.TRUE);
            } else if (Jasperreport.TASK_TEXT.equals(type)) {
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)Float.valueOf(10.0f));
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)Float.valueOf(10.0f));
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)Float.valueOf(100.0f));
                exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)Float.valueOf(80.0f));
            }
        }

        @Override
        public String getContentType(String type) {
            if (Jasperreport.TASK_PDF.equals(type)) {
                return "application/pdf";
            }
            if (Jasperreport.TASK_XML.equals(type)) {
                return "text/xml";
            }
            if (Jasperreport.TASK_HTML.equals(type)) {
                return "text/html";
            }
            if (Jasperreport.TASK_RTF.equals(type)) {
                return "application/rtf";
            }
            if (Jasperreport.TASK_XLS.equals(type)) {
                return "application/vnd.ms-excel";
            }
            if (Jasperreport.TASK_JXL.equals(type)) {
                return "application/vnd.ms-excel";
            }
            if (Jasperreport.TASK_CSV.equals(type)) {
                return "text/csv";
            }
            if (Jasperreport.TASK_ODT.equals(type)) {
                return "application/vnd.oasis.opendocument.text";
            }
            if (Jasperreport.TASK_XLSX.equals(type)) {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            if (Jasperreport.TASK_DOCX.equals(type)) {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            if (Jasperreport.TASK_GRAPHICS_2D.equals(type)) {
                return "image/jpg";
            }
            if (Jasperreport.TASK_ODS.equals(type)) {
                return "application/vnd.oasis.opendocument.spreadsheet";
            }
            if (Jasperreport.TASK_PPTX.equals(type)) {
                return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            }
            if (Jasperreport.TASK_TEXT.equals(type)) {
                return "text/plain";
            }
            if (Jasperreport.TASK_XHTML.equals(type)) {
                return "text/html";
            }
            throw new UiException("Type: " + type + " is not supported .");
        }

        @Override
        public String getFormat(String type) {
            if (Jasperreport.TASK_PDF.equals(type)) {
                return Jasperreport.TASK_PDF;
            }
            if (Jasperreport.TASK_XML.equals(type)) {
                return Jasperreport.TASK_XML;
            }
            if (Jasperreport.TASK_HTML.equals(type)) {
                return Jasperreport.TASK_HTML;
            }
            if (Jasperreport.TASK_RTF.equals(type)) {
                return Jasperreport.TASK_RTF;
            }
            if (Jasperreport.TASK_XLS.equals(type)) {
                return Jasperreport.TASK_XLS;
            }
            if (Jasperreport.TASK_JXL.equals(type)) {
                return Jasperreport.TASK_XLS;
            }
            if (Jasperreport.TASK_CSV.equals(type)) {
                return Jasperreport.TASK_CSV;
            }
            if (Jasperreport.TASK_ODT.equals(type)) {
                return Jasperreport.TASK_ODT;
            }
            if (Jasperreport.TASK_XLSX.equals(type)) {
                return Jasperreport.TASK_XLSX;
            }
            if (Jasperreport.TASK_DOCX.equals(type)) {
                return Jasperreport.TASK_DOCX;
            }
            if (Jasperreport.TASK_GRAPHICS_2D.equals(type)) {
                return "jpg";
            }
            if (Jasperreport.TASK_ODS.equals(type)) {
                return Jasperreport.TASK_ODS;
            }
            if (Jasperreport.TASK_PPTX.equals(type)) {
                return Jasperreport.TASK_PPTX;
            }
            if (Jasperreport.TASK_TEXT.equals(type)) {
                return Jasperreport.TASK_TEXT;
            }
            if (Jasperreport.TASK_XHTML.equals(type)) {
                return Jasperreport.TASK_HTML;
            }
            throw new UiException("Type: " + type + " is not supported in JasperReports.");
        }
    }

    protected class ExtraCtrl
    extends Iframe.ExtraCtrl {
        protected ExtraCtrl() {
            super((Iframe)Jasperreport.this);
        }

        public Media getMedia(String pathInfo) {
            String imageName;
            int indexOfImg = pathInfo.lastIndexOf(Jasperreport.IMAGE_DIR);
            if (indexOfImg >= 0 && (imageName = pathInfo.substring(indexOfImg + Jasperreport.IMAGE_DIR.length())).indexOf(".") < 0) {
                return Jasperreport.this.getImage(imageName);
            }
            return Jasperreport.this.doReport();
        }
    }
}

