/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul;

import java.io.IOException;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.impl.XulElement;

public class Colorbox
extends XulElement {
    private String _color = "#000000";
    private int _rgb = 0;
    private boolean _disabled;

    public void setColor(String color) {
        if (!Objects.equals((Object)color, (Object)this._color)) {
            this._color = color;
            this._rgb = this._color == null ? 0 : Colorbox.decode(this._color);
            this.smartUpdate("color", this._color);
        }
    }

    public String getColor() {
        return this._color;
    }

    public void setValue(String value) {
        this.setColor(value);
    }

    public String getValue() {
        return this.getColor();
    }

    public int getRGB() {
        return this._rgb;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onChange".equals(cmd)) {
            Map data = request.getData();
            InputEvent inputEvent = InputEvent.getInputEvent((AuRequest)request, (Object)this._color);
            this.disableClientUpdate(true);
            try {
                this.setColor(inputEvent.getValue());
            }
            finally {
                this.disableClientUpdate(false);
            }
            Events.postEvent((Event)inputEvent);
        } else {
            super.service(request, everError);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-colorbox" : this._zclass;
    }

    protected boolean isChildable() {
        return false;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        Runtime.init((Object)this);
        renderer.render("color", this.getColor());
        this.render(renderer, "disabled", this._disabled);
    }

    private static int decode(String color) {
        if (color == null) {
            return 0;
        }
        if (color.length() != 7 || color.charAt(0) != '#') {
            throw new UiException("Incorrect color format (#RRGGBB) : " + color);
        }
        return Integer.parseInt(color.substring(1), 16);
    }

    static {
        Colorbox.addClientEvent(Colorbox.class, (String)"onChange", (int)1);
    }
}

