/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.rt;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.util.Cleanups;
import org.zkoss.util.Dates;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zkex.license.LicenseContent;
import org.zkoss.zkex.license.LicenseManager;
import org.zkoss.zkex.license.LicenseParam;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkex.rt.RuntimeLicense;
import org.zkoss.zkex.util.ObfuscatedString;

final class RuntimeLicenseManager
extends LicenseManager
implements RuntimeLicense {
    private final Object _lock = new Object();
    private volatile Timer _timer;
    private volatile WebApp _wapp;
    private List<LicenseContent> _contents;
    private volatile URL _dirUrl;
    private volatile long _latest;
    private static SimpleDateFormat _dateFormat = new SimpleDateFormat("MMMM dd, yyyy", Locale.US);
    private static int HOUR = 3600000;

    private RuntimeLicenseManager(LicenseParam param) {
        super(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean install(URL url) {
        URLConnection conn = null;
        try {
            conn = this.createConnection(url);
            Key[] keys = this.getKeys(conn, url);
            if (keys == null) {
                boolean bl = false;
                return bl;
            }
            this._dirUrl = url;
            this.install0(keys);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.log("Create connection failed: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private URLConnection createConnection(URL url) throws IOException {
        if ("jar".equals(url.getProtocol())) {
            return url.openConnection();
        }
        return null;
    }

    private void closeConnection(URLConnection conn) {
        try {
            JarURLConnection jarConn;
            if (conn instanceof JarURLConnection && !(jarConn = (JarURLConnection)conn).getUseCaches()) {
                jarConn.getJarFile().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Key[] getKeys(URLConnection conn, URL url) {
        if (conn instanceof JarURLConnection) {
            try {
                return this.getKeysFromJar((JarURLConnection)conn);
            }
            catch (IOException e) {
                this.log("Get keys from jar error: " + e.getMessage());
                return null;
            }
        }
        return this.getKeysFromFileSystem(url.getPath());
    }

    private Key[] getKeysFromJar(JarURLConnection conn) throws IOException {
        JarFile jarFile = conn.getJarFile();
        JarEntry jarDir = conn.getJarEntry();
        String dir = jarDir.getName();
        ArrayList<JarKey> keys = new ArrayList<JarKey>(2);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().startsWith(dir)) continue;
            keys.add(new JarKey(jarFile, entry));
        }
        return keys.toArray(new Key[keys.size()]);
    }

    private Key[] getKeysFromFileSystem(String dirName) {
        File dir = new File(dirName);
        File[] files = dir.listFiles();
        if (files == null) {
            return null;
        }
        Key[] result = new Key[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = new FileKey(files[i]);
        }
        return result;
    }

    private void info(String msg) {
        msg = "\n" + (String)msg + "\n";
        Logger log = LoggerFactory.getLogger((String)"global");
        if (log.isInfoEnabled()) {
            log.info((String)msg);
        } else {
            System.out.println((String)msg);
        }
    }

    private void log(String msg) {
        msg = "\n" + (String)msg + "\n";
        Logger log = LoggerFactory.getLogger((String)"global");
        if (log.isErrorEnabled()) {
            log.error((String)msg);
        } else {
            System.err.println((String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install0(Key[] files) {
        Object object = this._lock;
        synchronized (object) {
            this._contents = new ArrayList<LicenseContent>(files.length);
            String pkg = this.getPackage();
            String uid = "10.3.0.FL.20260105";
            HashMap<String, Boolean> _certMap = new HashMap<String, Boolean>();
            this._latest = 0L;
            for (Key f : files) {
                this._latest += f.lastModified() + f.length();
                try {
                    LicenseContent lc = this.install(f);
                    if (lc == null) continue;
                    Map mapInfo = (Map)lc.getExtra();
                    if (!mapInfo.containsKey(Runtime.EVALUATION_VERSION)) {
                        String number = (String)mapInfo.get(Runtime.VERIFICATION_NUMBER);
                        if (number == null || _certMap.containsKey(number)) {
                            this.log(String.valueOf(mapInfo.get(Runtime.WARNING_NUMBER)) + f.getPath());
                            continue;
                        }
                        if (!this.isValidPackage(pkg, (String)mapInfo.get(Runtime.PACKAGE))) {
                            this.log(String.valueOf(mapInfo.get(Runtime.WARNING_PACKAGE)) + f.getPath());
                            continue;
                        }
                        String version = (String)mapInfo.get(Runtime.VERSION);
                        if (version != null && !"10.3.0.FL.20260105".startsWith(version)) {
                            this.log(String.valueOf(mapInfo.get(Runtime.WARNING_VERSION)) + f.getPath());
                            continue;
                        }
                        if (Dates.now().after(this.getExpiryDate(lc))) {
                            this.log(String.valueOf(mapInfo.get(Runtime.WARNING_EXPIRY)) + f.getPath());
                            continue;
                        }
                        _certMap.put(number, Boolean.TRUE);
                    } else if (Dates.now().after(this.getExpiryDate(lc))) continue;
                    this._contents.add(lc);
                }
                catch (Exception e) {
                    this.log(new ObfuscatedString(new long[]{4307748939090133289L, 3763454470649753422L, -6872730590590579063L, -4639536792232415440L, -5784189857893158816L, 7307901420180268778L, -627643376646394353L, -7420280774293424959L, 2656306477204072694L, -2499488659900337288L, -8059070027533673028L, 7471492367409620715L, 822853263747496262L, -2451111032939294087L, 5181597043837345221L, -5675751368559367806L, 5049843703446154799L, 9141315134085574909L, -6165825001738499911L, -8027923838117731411L, -6842157638029734249L}).toString() + f.getPath());
                }
            }
            this._latest *= (long)files.length;
            if (this._contents.isEmpty()) {
                if (this._latest == 0L) {
                    this.log(new ObfuscatedString(new long[]{-6899918244677316866L, 2946753050424552565L, -1166500401249160465L, -6361152391287683152L, -1012658505712928448L, 2102941868302252760L, 3901913952577343105L, 1861727708660677834L, -3196033244540681827L, -1179475304557705732L, -8292713655681148352L, 1846152504906808191L, -5915587415450046371L, 7423933818392029259L, -8624164244204572166L, -1535967842794712539L, 8072868225759836711L, -3862751912709119543L}).toString());
                }
            } else {
                this.printInfo();
            }
        }
    }

    private synchronized LicenseContent install(Key key) throws Exception {
        return this.install(RuntimeLicenseManager.loadLicenseKey(key), this.getLicenseNotary());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadLicenseKey(Key keyFile) throws IOException {
        int size = Math.min((int)keyFile.length(), 0x100000);
        byte[] b = new byte[size];
        try (InputStream in = keyFile.inputStream();){
            int count;
            int n = 0;
            int len = b.length;
            do {
                if ((count = in.read(b, n, len - n)) >= 0) continue;
                throw new EOFException();
            } while ((n += count) < len);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDelay() {
        Object object = this._lock;
        synchronized (object) {
            if (this._contents.isEmpty()) {
                return HOUR;
            }
            int delay = 0;
            for (int i = 0; i < this._contents.size(); ++i) {
                int d = 1;
                try {
                    d = (Integer)((Map)this._contents.get(i).getExtra()).get(Runtime.CHECK_PERIOD);
                }
                catch (Exception e) {
                    d = 1;
                }
                if (delay == 0) {
                    delay = d;
                    continue;
                }
                if (delay <= d) continue;
                delay = d;
            }
            return delay * HOUR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startScheduler() {
        if (this._timer != null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._timer == null) {
                this._timer = new Timer();
                Cleanups.add((Cleanups.Cleanup)new Cleanups.Cleanup(){

                    public void cleanup() {
                        RuntimeLicenseManager.this.stopScheduler();
                    }
                });
            }
        }
        this.check();
    }

    @Override
    public boolean isScheduled() {
        return this._timer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopScheduler() {
        Object object = this._lock;
        synchronized (object) {
            if (this._timer != null) {
                this._timer.cancel();
                this._timer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LicenseContent getMaximum() {
        LicenseContent lc = null;
        Object object = this._lock;
        synchronized (object) {
            for (int i = 0; i < this._contents.size(); ++i) {
                LicenseContent lc1 = this._contents.get(i);
                if (lc != null && !this.getExpiryDate(lc).before(this.getExpiryDate(lc1))) continue;
                lc = lc1;
            }
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, LicenseContent> getAllMaximums() {
        Object object = this._lock;
        synchronized (object) {
            if (this._contents.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, LicenseContent> map = new HashMap<String, LicenseContent>(5);
            for (int i = 0; i < this._contents.size(); ++i) {
                String o;
                LicenseContent lc;
                LicenseContent lc1 = this._contents.get(i);
                Map infoMap = (Map)lc1.getExtra();
                if (infoMap == null || (lc = (LicenseContent)map.get(o = (String)infoMap.get(Runtime.PRODUCT_NAME))) != null && !this.getExpiryDate(lc).before(this.getExpiryDate(lc1))) continue;
                map.put(o, lc1);
            }
            return map;
        }
    }

    private Date getNotBefore(LicenseContent lc) {
        try {
            return _dateFormat.parse((String)((Map)lc.getExtra()).get(Runtime.ISSUE_DATE));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private Date getExpiryDate(LicenseContent lc) {
        try {
            String endDate = (String)((Map)lc.getExtra()).get(Runtime.EXPIRY_DATE);
            if (endDate == null) {
                return new Date(Long.MAX_VALUE);
            }
            return _dateFormat.parse(endDate);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseContent checkLatest() {
        URLConnection conn = null;
        try {
            conn = this.createConnection(this._dirUrl);
            Key[] keys = this.getKeys(conn, this._dirUrl);
            if (keys == null) {
                LicenseContent licenseContent = null;
                return licenseContent;
            }
            long latest = 0L;
            for (Key f : keys) {
                latest += f.lastModified() + f.length();
            }
            LicenseContent lc = this.getMaximum();
            if (this._latest != (latest *= (long)keys.length) || lc != null && Dates.now().after(this.getExpiryDate(lc))) {
                this.install0(keys);
                LicenseContent licenseContent = this.getMaximum();
                return licenseContent;
            }
            LicenseContent licenseContent = lc;
            return licenseContent;
        }
        catch (IOException e) {
            this.log("Create connection failed: " + e.getMessage());
            LicenseContent licenseContent = null;
            return licenseContent;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printInfo() {
        Object object = this._lock;
        synchronized (object) {
            for (int i = 0; i < this._contents.size(); ++i) {
                LicenseContent lc = this._contents.get(i);
                this.info((String)((Map)lc.getExtra()).get(Runtime.INFORMATION));
            }
        }
    }

    private boolean isValidPackage(String runtime, String license) {
        if (license == null) {
            return false;
        }
        return runtime.equals(license) || license.equals("EP") || license.equals("PP") && !runtime.equals("EP");
    }

    private String getPackage() {
        String pkg = this.getPackageVersion();
        return "CE".equals(pkg) ? "SP" : pkg.substring(0, pkg.length() - 1) + "P";
    }

    private String getPackageVersion() {
        return WebApps.getEdition();
    }

    private void check() {
        block6: {
            try {
                LicenseContent content = this.checkLatest();
                if (this._timer != null) {
                    this._timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            RuntimeLicenseManager.this.check();
                        }
                    }, this.getDelay());
                }
                if (content == null) {
                    throw new FileNotFoundException("Not a valid license found!");
                }
            }
            catch (FileNotFoundException e) {
                if (this.getLicenseParam() instanceof Runtime.EvalLicenseParam) {
                    this.log(Runtime.GENERAL_WARNING_EVALUATION);
                } else {
                    String version = this.getPackageVersion();
                    this.log(Runtime.WARNING_EVALUATION.replaceAll("\\{0\\}", version));
                }
                if (this._wapp == null) break block6;
                this._wapp.setAttribute("org.zkoss.zk.ui.notice", (Object)" Evaluation Only");
            }
        }
    }

    public static RuntimeLicenseManager getInstance(LicenseParam param) {
        return new RuntimeLicenseManager(param);
    }

    @Override
    public void setWapp(WebApp wapp) {
        this._wapp = wapp;
    }

    private static class JarKey
    implements Key {
        private final JarFile jar;
        private final JarEntry entry;

        public JarKey(JarFile jar, JarEntry entry) {
            this.jar = jar;
            this.entry = entry;
        }

        @Override
        public InputStream inputStream() throws IOException {
            return this.jar.getInputStream(this.entry);
        }

        @Override
        public long lastModified() {
            return this.entry.getTime();
        }

        @Override
        public long length() {
            return this.entry.getSize();
        }

        @Override
        public String getPath() {
            return this.jar.getName() + "/" + this.entry.getName();
        }
    }

    private static class FileKey
    implements Key {
        private final File file;

        public FileKey(File file) {
            this.file = file;
        }

        @Override
        public InputStream inputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public long lastModified() {
            return this.file.lastModified();
        }

        @Override
        public long length() {
            return this.file.length();
        }

        @Override
        public String getPath() {
            return this.file.getPath();
        }
    }

    private static interface Key {
        public InputStream inputStream() throws IOException;

        public long lastModified();

        public long length();

        public String getPath();
    }
}

