/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.sys.debugger.impl;

import org.slf4j.LoggerFactory;
import org.zkoss.bind.sys.debugger.impl.AbstractExecutionInfoCollector;
import org.zkoss.json.JSONObject;

public class DefaultExecutionInfoCollector
extends AbstractExecutionInfoCollector {
    private boolean _startLine = false;
    private Class<?> _viewModelClass;

    protected Class<?> getViewModelClass() {
        return this._viewModelClass;
    }

    public void setViewModelClass(Class<?> viewModelClass) {
        this._viewModelClass = viewModelClass;
    }

    @Override
    public void addInfo(JSONObject info) {
        Object type = info.get((Object)"type");
        if (!this._startLine) {
            this.out("=======================================");
            this._startLine = true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[" + String.valueOf(info.get((Object)"sid")) + "]");
        int stack = (Integer)info.get((Object)"stack");
        for (int i = 0; i < stack; ++i) {
            sb.append(" ");
            if (i == stack - 1) {
                if ("stack".equals(type)) {
                    sb.append(" + ");
                    continue;
                }
                sb.append(" *");
                continue;
            }
            sb.append(" ");
        }
        if ("add-binding".equals(type) || "add-command-binding".equals(type)) {
            sb.append("ADD-BINDING");
        }
        if ("stack".equals(type)) {
            sb.append(String.valueOf(info.get((Object)"name")) + "\t ");
        } else {
            sb.append("[" + String.valueOf(info.get((Object)"type")) + (String)(info.containsKey((Object)"subtype") ? ":" + String.valueOf(info.get((Object)"subtype")) : "") + "]\t");
        }
        if ("event".equals(type)) {
            sb.append("[" + String.valueOf(info.get((Object)"event")) + "]");
        } else if ("load".equals(type)) {
            if (info.containsKey((Object)"condition")) {
                sb.append("[" + String.valueOf(info.get((Object)"condition")) + "]\t");
            }
            sb.append(String.valueOf(info.get((Object)"fromExpr")) + " > " + String.valueOf(info.get((Object)"toExpr")) + "\t");
            if (Boolean.TRUE.equals(info.get((Object)"nullval"))) {
                sb.append("NULL");
            } else {
                sb.append(info.get((Object)"value"));
            }
        } else if ("command".equals(type)) {
            if (info.containsKey((Object)"event")) {
                sb.append("[" + String.valueOf(info.get((Object)"event")) + "]\t");
            }
            if (info.containsKey((Object)"commandExpr")) {
                sb.append("[" + String.valueOf(info.get((Object)"commandExpr")) + "]\t");
            }
            sb.append(info.get((Object)"command"));
        } else if ("validation".equals(type)) {
            sb.append(String.valueOf(info.get((Object)"validatorExpr")) + "\t" + String.valueOf(info.get((Object)"validator")) + "\t result = " + String.valueOf(info.get((Object)"result")));
        } else if ("save".equals(type)) {
            if (info.containsKey((Object)"condition")) {
                sb.append("[" + String.valueOf(info.get((Object)"condition")) + "]\t");
            }
            sb.append(String.valueOf(info.get((Object)"fromExpr")) + " > " + String.valueOf(info.get((Object)"toExpr")) + "\t");
            if (Boolean.TRUE.equals(info.get((Object)"nullval"))) {
                sb.append("NULL");
            } else {
                sb.append(info.get((Object)"value"));
            }
        } else if ("notify-change".equals(type)) {
            sb.append("[" + String.valueOf(info.get((Object)"base")) + "][" + String.valueOf(info.get((Object)"prop")) + "]");
        } else if ("add-binding".equals(type)) {
            if (info.containsKey((Object)"condition")) {
                sb.append("[" + String.valueOf(info.get((Object)"condition")) + "]\t");
            }
            sb.append(String.valueOf(info.get((Object)"fromExpr")) + " > " + String.valueOf(info.get((Object)"toExpr")));
        } else if ("add-command-binding".equals(type)) {
            sb.append("[" + String.valueOf(info.get((Object)"event")) + "]\t" + String.valueOf(info.get((Object)"commandExpr")));
        } else if ("anno-warn".equals(type)) {
            sb.append(String.valueOf(info.get((Object)"attr")) + " = @" + String.valueOf(info.get((Object)"anno")) + "()");
        }
        if (info.containsKey((Object)"widget")) {
            sb.append("\t<" + String.valueOf(info.get((Object)"widget")) + " uuid=\"" + String.valueOf(info.get((Object)"uuid")) + "\" id=\"" + String.valueOf(info.get((Object)"id")) + "\" />");
        }
        if (info.containsKey((Object)"note")) {
            sb.append("\t" + String.valueOf(info.get((Object)"note")));
        }
        if (info.containsKey((Object)"location")) {
            sb.append("\t" + String.valueOf(info.get((Object)"location")));
        }
        this.out(sb.toString());
    }

    protected void out(String string) {
        LoggerFactory.getLogger(this.getViewModelClass()).info(string);
    }
}

